jQuery(function($) {
    var activeTypes = [], activeSection, myMap, prev_infowindow = false, mapOptions, collectionBySection = {}, collectionByType = {}, collectionById = {}, typesBySection = {};
    var now = new Date();
    var day =  now.getDay();
    var mapCanvas = $('#dsloc-map-canvas');
    var canTrigger = false;
    $('.dsloc-control-wrap__select').chosen({
        disable_search: true,
        width: "100%"
    });

    $('.dsloc-map-wrap__col-list').jScrollPane({
        verticalGutter: 0,
        horizontalGutter: 0,
        autoReinitialise: true
    });
    var listScrollApi = $('.dsloc-map-wrap__col-list').data('jsp');
    $('.dsloc-checkbox-block-input').on('change', function() {
        activeTypes = [];
        $('.dsloc-checkbox-block-input:checked').each(function() {
            activeTypes.push($(this).data('type'))
        });
        recalcItemsVisibility();
    });

    $('.dsloc-control-wrap__select').on('change', function() {
        if (prev_infowindow) {
            prev_infowindow.close();
            onInfoWindowClose();
        }
        $('.dsloc-infobox-mobile').removeClass('dsloc-infobox-mobile__visible');

        activeSection = $(this.options[this.selectedIndex]).data('section');
        var sectionCode = $(this).val();
        if( sectionCode != null )
        {
        	location.hash = 'section-' + sectionCode;
        }
        
        $(this).trigger("chosen:updated");
        if( activeSection == undefined)
        {
        	activeSection = 0;
        }
        recalcItemsVisibility();
        setSectionCenter( activeSection );
        tileListener = google.maps.event.addListener(myMap,'tilesloaded',function(){
			google.maps.event.removeListener(tileListener);
			canTrigger = true;
        });
    });
    function enableScrollZoom() {
        var newMapOptions = mapOptions;
        newMapOptions.center = myMap.getCenter();
        newMapOptions.zoom = myMap.getZoom();
        newMapOptions.scrollwheel = true;
        myMap.setOptions(newMapOptions);
    }
    function disableScrollZoom() {
        var newMapOptions = mapOptions;
        newMapOptions.center = myMap.getCenter();
        newMapOptions.zoom = myMap.getZoom();
        newMapOptions.scrollwheel = false;
        myMap.setOptions(newMapOptions);
    }
    function onInfoWindowClose() {
        $('.dsloc-store-list__item').removeClass('dsloc-store-list__item_active');
        enableScrollZoom();
    }
    function moveCenter(coordinates) {
        myMap.panTo(coordinates);
        myMap.setZoom(15);
    }

    function setSectionCenter( sectionId )
    {
        var bounds = new google.maps.LatLngBounds();
        if( typeof collectionBySection[sectionId] != 'undefined' )
        {
            var positions = [];
            $.each(collectionBySection[sectionId], function(index, value) {
                // if (value.opacity) {
                    positions.push(value.getPosition());
                // }
            });
            if (positions.length > 0) {
                if (positions.length == 1) {
                    moveCenter(positions[0]);
                } else {
                    for (var i = positions.length - 1; i >= 0; i--) {
                        bounds.extend(positions[i])
                    };
                    myMap.fitBounds(bounds);
                }
            }
        }
    }


    function recalcItemsVisibility()
    {
            $('.dsloc-store-list__item').hide();
            $('.dsloc-store-list__item[data-section="' + activeSection + '"]').each(function() {
                var thisType = parseInt($(this).data('type'));
                if( activeTypes.indexOf(thisType) !== -1 )
                {
                    $(this).show();
                }
            });
            
            if( typeof typesBySection[activeSection]  == 'object')
            {
                $('.dsloc-checkbox-block').addClass('dsloc-checkbox-block__hidden');
                $('.dsloc-checkbox-block').each( function() {
                    var cbTypeId = parseInt($(this).find('.dsloc-checkbox-block-input').data('type'));
                    if( typesBySection[activeSection].indexOf(cbTypeId) !== -1 )
                    {
                        $(this).removeClass('dsloc-checkbox-block__hidden');
                    }
                });

            } 
        listScrollApi.reinitialise();


        visibleMarkersByType = [];
        visibleMarkersBySection = [];
        $.each(collectionByType, function(typeIndex, typeColl) {
            $.each( typeColl, function( index, imarker ) {
                typeIndex = parseInt(typeIndex);
                if( activeTypes.indexOf(typeIndex) == -1 )
                {
                    imarker.setOpacity(0);
                }
                else
                {
                    visibleMarkersByType.push(index)
                }
            })
        })
        

        $.each(collectionBySection, function(sectionIndex, sectionColl) {
            $.each( sectionColl, function( index, imarker ) {
                sectionIndex = parseInt(sectionIndex);
                if(  sectionIndex == activeSection )
                {
                    visibleMarkersBySection.push(index)
                }
                else
                {
                     imarker.setOpacity(0);
                }
            })
        })
        $.each(collectionById, function(index, imarker ){
            if( visibleMarkersBySection.indexOf(index) != -1 && visibleMarkersByType.indexOf(index) != -1 )
            {
                imarker.setOpacity(1);
            }
        });
        canTrigger = true;
    }
    function recalcSize(infowindow, marker)
    {

        var image = $('.dsloc-infobox-header-img');
        var isImage = true;
        if (image.length == 0) {
            isImage = false;
            image = $('.dsloc-infobox-header-text');
        };
        image.css('width','100%');
        var jQinfobox = $('.dsloc-infobox');
      
        var currentImageHeight = image.outerHeight();
        var currentImageWidth = image.outerWidth();
        var currentHeaderHeight = $('.dsloc-infobox-header').outerHeight();
        var currentHeaderWidth = $('.dsloc-infobox-header').outerHeight();
        var halfHeight = (mapCanvas.outerHeight() - 20) / 2 - 15;

        if( currentImageHeight < currentHeaderHeight )
        {
            if(isImage)
            {
                image.css('width','');
                image.css('height','100%');
            }
        }
        currentImageHeight = image.outerHeight();
        currentImageWidth = image.outerWidth();
        var newHeaderHeight;
        if (currentImageHeight > halfHeight ) {
            newHeaderHeight = halfHeight ;
        } else {
            newHeaderHeight = currentImageHeight;
        }
        $('.dsloc-infobox-header').css('height',newHeaderHeight + 'px');
        var newHeaderWidth = $('.dsloc-infobox-header').outerWidth();
        var imageTopOffset = (newHeaderHeight - currentImageHeight) / 2;
        var imageLeftOffset = (newHeaderWidth - currentImageWidth) / 2;
        if(isImage)
        {
            image.css('top', imageTopOffset);
            image.css('left', imageLeftOffset);
        }
        var maxBodyHeight = mapCanvas.outerHeight() - 20 - newHeaderHeight;
        $('.dsloc-infobox-body-wrap').css('max-height',maxBodyHeight + 'px');
        if( typeof $('.dsloc-infobox-body-wrap').data('jsp') != 'undefined')
        {
             $('.dsloc-infobox-body-wrap').data('jsp').destroy();
        }
        $('.dsloc-map-canvas .dsloc-infobox-body-wrap')
            .jScrollPane({
                verticalGutter: 0,
                horizontalGutter: 0,
                autoReinitialise: true
            });
      $('.dsloc-infobox-mobile .dsloc-infobox-body-wrap')
        .css('height', $('.dsloc-infobox-mobile').height() -  $('.dsloc-infobox-mobile .dsloc-infobox-header-text').height()  + 'px')
        .jScrollPane({
            verticalGutter: 0,
            horizontalGutter: 0,
            autoReinitialise: true
        });     
        var InfoBoxTopOffset = jQinfobox.outerHeight() - (mapCanvas.outerHeight() / 2) + 10;
        $('.dsloc-infobox-corner').css('bottom', InfoBoxTopOffset - 5);
        infowindow.setOptions({
            pixelOffset: new google.maps.Size(20,InfoBoxTopOffset  ),
        });
        
    }
    function openBaloon(marker,infowindow)
    {
        $('.dsloc-infobox-mobile').html(infowindow.content_);
        $('.dsloc-infobox-mobile .dsloc-infobox-header').append('<div class="dsloc-infobox-header-close-btn">&times;</div>');
        $('.dsloc-infobox-mobile').addClass('dsloc-infobox-mobile__visible');

        if (prev_infowindow) {
            prev_infowindow.close();
            onInfoWindowClose();
        }
        prev_infowindow = infowindow;
        myMap.setCenter(marker.getPosition());
        infowindow.open(myMap,marker);
        setTimeout(function() {
            recalcSize(infowindow, marker);
        } , 0 );
        google.maps.event.clearListeners(infowindow, 'domready');
        google.maps.event.addListener(infowindow, 'domready', function() {
            setTimeout(function() {
                recalcSize(infowindow, marker);
                var jQinfobox = $('.dsloc-infobox');
                jQinfobox.off('mouseenter').on('mouseenter', function() {
                    disableScrollZoom();
                });
                jQinfobox.off('mouseleave').on('mouseleave', function() {
                    enableScrollZoom();
                });
                $('.dsloc-infobox-worktime-link').off('click').on('click', function(e) {
                    e.preventDefault();
                    $('.dsloc-infobox-worktime-link').hide().addClass('dsloc-infobox-worktime-link_hidden');
                    $('.dsloc-infobox-worktime-table-wrap').show().removeClass('dsloc-infobox-worktime-table-wrap_hidden');
                    recalcSize(infowindow, marker);
                });

                $('.dsloc-infobox-worktime-table__row_active').off('click').on('click', function(e) {
                    e.preventDefault();
                    $('.dsloc-infobox-worktime-table-wrap').hide().addClass('dsloc-infobox-worktime-table-wrap_hidden');
                    $('.dsloc-infobox-worktime-link').show().removeClass('dsloc-infobox-worktime-link_hidden');
                    recalcSize(infowindow, marker);
            
                });
                infowindow.setOptions({
                     infoBoxClearance: new google.maps.Size(10, 10)
                });
            },
            50
            );
        });

    }
    $('.dsloc-map-wrap__col-map').on('click', '.dsloc-infobox-header-close-btn', function () {
        if (prev_infowindow) {
            prev_infowindow.close();
        }
        $('.dsloc-infobox-mobile').removeClass('dsloc-infobox-mobile__visible');
    });
    function initialize() {
        var myStyles = [
            {
                featureType: 'poi',
                elementType: 'labels',
                stylers: [
                    {visibility: 'off'}
                ]
            }
        ];
       mapOptions = {
            zoom: 14,
            // center: new google.maps.LatLng(55.028162, 82.908321),
            panControl: false,
            zoomControl: true,
            mapTypeControl: false,
            scaleControl: false,
            streetViewControl: true,
            overviewMapControl: true,
            scrollwheel: true,
            styles: myStyles
        };
        myMap = new google.maps.Map(document.getElementById('dsloc-map-canvas'), mapOptions);

        processMarkers();

    }

    google.maps.event.addDomListener(window, 'load', initialize);

    function processMarkers() {
        $.ajax({
            // url:'/?' + dl.Prefix + 'store_locator=1&' + dl.Prefix + 'action=get_all_data',
            url:dl.ajaxurl + '?action=' + dl.Prefix + 'get_all_data',
            method: 'GET',
            success: function(r) {
                var icons = r.icons;
                $.each(r.items, function(index, val) {
                    if(typeof  typesBySection[val.section_id] == 'undefined')
                    {
                        typesBySection[val.section_id] = [];
                    }
                    if(  typesBySection[val.section_id].indexOf(val.icon) == -1 )
                    {
                        typesBySection[val.section_id].push( parseInt(val.icon) );
                    }
                    var LatLng = val.coordinates.split(',');
                    var markerOptions = {
                        position: new google.maps.LatLng(LatLng[0], LatLng[1]),
                        map: myMap,
                        title: val.name,
                        optimized: true,
                        icon:  {
                            path: google.maps.SymbolPath.CIRCLE,
                            scale: 1,
                            fillOpacity: 0,
                            strokeOpacity: 0
                        }

                    };

                    var marker = new google.maps.Marker(markerOptions);

                    if( (icons||{})[val.icon] )
                    {
                        if( icons[val.icon]['src'])
                        {
                            var iconSrc = icons[val.icon]['src'];
                            var img = new Image();

                            img.onload = function(){
                                var whRatio = img.width / img.height;
                                var scaledWidth;
                                var scaledHeight;
                                if(whRatio > 1)
                                {
                                    var tmpWidth = img.width > 31 ? 31 : img.width;
                                    scaledWidth = tmpWidth;
                                    scaledHeight = tmpWidth / whRatio;
                                }
                                else
                                {
                                    var tmpHeight = img.height > 31 ? 31 : img.height;
                                    scaledHeight = tmpHeight;
                                    scaledWidth = tmpHeight * whRatio;
                                }
                                var myIcon = new google.maps.MarkerImage(iconSrc, null, null, null, new google.maps.Size(scaledWidth, scaledHeight));
                                marker.setIcon(myIcon);

                            };
                            img.src = iconSrc;

                        }
                    }
                   
                    if( typeof collectionBySection[val.section_id] == "undefined") {
                        collectionBySection[val.section_id] = {};
                    }
                    // mc.addMarker(marker);
                    collectionBySection[val.section_id][val.id] = marker;

                    if( typeof collectionByType[val.icon] == "undefined") {
                        collectionByType[val.icon] = {};
                    }
                    // mc.addMarker(marker);
                    collectionByType[val.icon][val.id] = marker;

                    collectionById[val.id] = marker;

                    balloonContent = '<div class="dsloc-infobox-corner"></div>';
                    if( val.image != '')
                    {
                        balloonContent += '<div class="dsloc-infobox-header"><img class="dsloc-infobox-header-img" src="' + val.image + '" alt=""/><div class="dsloc-infobox-gradient"></div><div class="dsloc-infobox-header-text dsloc-infobox-header-text__' + dloptions.infobox_header_align + '">' + val.name + '</div></div>';
                    }
                    else
                    {
                        balloonContent += '<div class="dsloc-infobox-header" style="background-color:' + r.icons[val.icon]['infobox_color'] + '"><div class="dsloc-infobox-gradient"></div><div class="dsloc-infobox-header-text dsloc-infobox-header-text__' + dloptions.infobox_header_align + '">' + val.name + '</div></div>';
                    }
                    balloonContent += '<div class="dsloc-infobox-body-wrap"><div class="dsloc-infobox-body">';
                    balloonContent += '<div class="dsloc-infobox-adress-wrap"><i class="dsloc-icon dsloc-icon-small-pointer dsloc-infobox-icon"></i><div class="dsloc-infobox-adress">' + val.address + '</div></div>';

                    if(val.work_time !='' && typeof val.work_time_sorted != 'undefined' )
                    {
                        balloonContent += '<div class="dsloc-infobox-work-time-wrap"><i class="dsloc-icon dsloc-icon-clock dsloc-infobox-icon"></i>';
                        balloonContent += '<div class="dsloc-infobox-worktime">';
                        if(  val.work_time_sorted[day]['from'] == val.work_time_sorted[day]['to']  )
                        {
                            balloonContent += '<a href="#" class="dsloc-infobox-worktime-link">' + val.work_time_sorted[day]['from'] + '</a>';
                        }
                        else
                        {
                            balloonContent += '<a href="#" class="dsloc-infobox-worktime-link"><span class="dsloc-infobox-worktime-link-span__nw">' + val.work_time_sorted[day]['from'] + '</span> – <span class="dsloc-infobox-worktime-link-span__nw">' + val.work_time_sorted[day]['to'] + '</span></a>';
                        }
                        
                        balloonContent += '</div>';
                        balloonContent += '<div class="dsloc-infobox-worktime-table-wrap dsloc-infobox-worktime-table-wrap_hidden">';
                        balloonContent += '<table class="dsloc-infobox-worktime-table ">';
                        $.each(val.work_time_display, function(index, time){
                            if( time.dayNums.indexOf(day) !== -1)
                            {
                                balloonContent += '<tr class="dsloc-infobox-worktime-table__row dsloc-infobox-worktime-table__row_active">';
                            }
                            else
                            {
                                balloonContent += '<tr class="dsloc-infobox-worktime-table__row">';
                            }

                            if( typeof time.to != 'undefined')
                            {
                                 balloonContent += '<td class="dsloc-infobox-worktime-table__cell-day">' + time.from + ' - ' + time.to + '</td>';
                            }
                            else
                            {
                                 balloonContent += '<td class="dsloc-infobox-worktime-table__cell-day">' + time.from + '</td>';
                            }

                            if( time.time_from = time.time_to )
                            {
                                balloonContent += '<td class="dsloc-infobox-worktime-table__cell-time">' + time.time + '</td> </tr>';
                            }
                            else
                            {
                                balloonContent += '<td class="dsloc-infobox-worktime-table__cell-time"><span class="dsloc-infobox-worktime-link-span__nw">' + time.time_from + '</span> - <span class="dsloc-infobox-worktime-link-span__nw">' + time.time_to + '</span></td> </tr>';
                            }
                        });
                        balloonContent += '</table>';
                        balloonContent += '</div>';
                        balloonContent += '</div>';
                    }
                    balloonContent += '<div class="dsloc-infobox-other-wrap"><div class="dsloc-infobox-other">';
                    if(val.phone !='')
                    {
                        balloonContent += '<div>' + val.phone + '</div>';
                    }
                    if( typeof(val.url) == 'object')
                    {
                        balloonContent += '<a href="' + val.url.href + '" class="dsloc-infobox-link">' + val.url.display + '</a>';
                    }
                    balloonContent += '</div></div>';
                    if(val.description !='')
                    {
                        balloonContent += '<div class="dsloc-infobox-description-wrap"><div class="dsloc-infobox-description">' + val.description + '</div></div>';
                    }

                    balloonContent += '</div></div>';

                   
                    var baloonWidth = ((mapCanvas.width() / 2 - 20) > 350) ? 350 : (mapCanvas.width() / 2 - 20);
                    var maxBaloonHeight = mapCanvas.height() - 20;
                    var minBaloonHeight = mapCanvas.height() / 2 + 10;
                    var minBaloonWidth = 200;
                    if ($('.dsloc-infobox-mobile').length < 1) {
                        $('.dsloc-map-wrap__col-map').append('<div class="dsloc-infobox-mobile"></div>');
                    }
                    var infowindow = new InfoBox({
                        content: balloonContent,
                        boxClass: 'dsloc-infobox',
                        alignBottom: true,
                        infoBoxClearance: new google.maps.Size(10, -9999),
                        boxStyle: {

                            width: baloonWidth + 'px',
                            maxHeight: maxBaloonHeight + 'px',
                            minHeight: minBaloonHeight + 'px',
                            minWidth: minBaloonWidth + 'px'
                        },
                        pixelOffset: new google.maps.Size(20, 0),
                        closeBoxURL: dl.Url + 'imgs/close-icon.png',
                        closeBoxMargin: '5px',
                        enableEventPropagation: false
                    });

                    google.maps.event.addListener(infowindow,'closeclick',function(){
                        onInfoWindowClose();
                    });
                    $('#dsloc-obj-' + val.id).on('click', function() {
                        if( canTrigger == true )
                        {
                        	myMap.setZoom(15);
                            openBaloon(marker,infowindow);
                            if ($('.dsloc-infobox-mobile').is(':visible')) {
                                $('html,body').animate({scrollTop: $('.dsloc-map-canvas').offset().top - 10 },400);
                            } else {
                                $('html,body').animate({scrollTop: $('.dsloc-wrap').offset().top - 50},400);
                            }
                            $(this).addClass('dsloc-store-list__item_active');
                        }
                    });
                    google.maps.event.addListener(marker, 'click', function() {
                        if( canTrigger == true )
                        {
                            openBaloon(marker, infowindow);
                            $('#dsloc-obj-' + val.id).addClass('dsloc-store-list__item_active');
                            listScrollApi.scrollToElement($('#dsloc-obj-' + val.id));

                        }
                    });
                
                });
                $('.dsloc-control-wrap__select').change();
                $('.dsloc-checkbox-block-input:first').change();

            }
        });
    };
    var sectionCode = location.hash.replace('#section-','');
    var citySelect = $('.dsloc-control-wrap__select');
    if( sectionCode.length > 0 && $('.dsloc-control-wrap__select option[value="'+sectionCode+'"]').length > 0  )
    {
        citySelect.val(sectionCode);
    
    }
    $('.dsloc-marker, .dsloc-store-list__item-marker').each(function(){
        var that = $(this);
        var bg = $(this).css('background-image').replace(/url\(["']?([^'"]+)['"]?\)/, "$1");
        var bgimg = new Image();
        bgimg.onload = function(){
            if( bgimg.width < 22 && bgimg.height < 32 )
            {
                that.css('background-size', 'auto');
            }
        };
        bgimg.src = bg;


    });
    $(window).on('resize', function() {
        if($(window).outerWidth() < 961) {
            if( typeof $('.dsloc-map-wrap__col-list').data('jsp') != 'undefined')
            {
                 $('.dsloc-map-wrap__col-list').data('jsp').destroy();
            }
        } else {
            if( typeof $('.dsloc-map-wrap__col-list').data('jsp') == 'undefined')
            {
                $('.dsloc-map-wrap__col-list').jScrollPane({
                    verticalGutter: 0,
                    horizontalGutter: 0,
                    autoReinitialise: true
                });
            }  
        }

    });
    window.mapNPointsReinit = function() {
        setTimeout(function(){
            $('#dsloc-wrap .jspContainer').parent().each(function(){
                $(this).data('jsp').reinitialise();
            })
            google.maps.event.trigger(myMap, 'resize');
            $('.dsloc-control-wrap__select').change();

        },500);
    }
    setTimeout(function(){
        $(window).resize();
    }, 150);
});