<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Document</title>
	<script src="https://maps.googleapis.com/maps/api/js?v=3.exp"></script>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
</head>
<body>
	<style>
		#map-canvas {
			width: 600px;
			height: 400px;
			border: 1px solid red;
		}
		#coords {
			width: 500px;
		}
	</style>
	<script>
		var marker, map;
		function initialize()
		{
			geocoder = new google.maps.Geocoder();
			var myLatlng = new google.maps.LatLng(48.632909,12.216797);
			var mapOptions = {
				zoom: 4,
				center: myLatlng,
				disableDefaultUI: true,
				panControl: false,
				zoomControl: true,
				mapTypeControl: true,
				scaleControl: true,
				streetViewControl: false,
				overviewMapControl: true
			};
			map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
			marker = new google.maps.Marker({
				// position: myLatlng,
				map: map,
				draggable: true,
				title:"Drag me!" 
			});
			google.maps.event.addListener(map, 'click', function(event) {
				marker.setPosition(event.latLng);
				marker.setMap(map);
			});	
			google.maps.event.addListener(marker, 'position_changed', function() {
				$('#coords').val(marker.getPosition().toUrlValue());
			});	
		}
		function setCenterAndMarker(lat, lng, zoom)
		{
			zoom = zoom || 16;
			var latlng = new google.maps.LatLng(lat,lng);
			map.setCenter( latlng );
			map.setZoom( zoom );
			marker.setPosition(latlng);
			marker.setMap(map);

		}

		jQuery(function(){
			$('#geocode').on( 'click', function codeLatLng() {
				var address = $('#address').val();
				geocoder.geocode( { 'address': address}, function(results, status) {
					if (status == google.maps.GeocoderStatus.OK) {
						map.setCenter(results[0].geometry.location);
						map.setZoom(16);
						marker.setMap(map);
						marker.setPosition(results[0].geometry.location);

					} else {
						alert('Geocode was not successful for the following reason: ' + status);
					}
				});

			});
			setTimeout( function(){
				setCenterAndMarker(55.041463,82.91635, 5);
			}, 3000);
		});


		google.maps.event.addDomListener(window, 'load', initialize);

	</script>
   <div id="panel">
      <input id="address" type="textbox" value="Novosibirsk">
      <input id="geocode" type="button" value="Geocode">
    </div>

	<div id="map-canvas">
		
	</div>
	<input type="text" id="coords">
</body>
</html>