<?php
	add_action('wp_ajax_load-options_box-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-featurebox-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-row-settings', 'beopen_visualeditor_load_row_settings');

	function beopen_visualeditor_load_row_settings() {
		global $wpdb; // this is how you get access to the database
		global $beopen_row_animations;
		?>
		<form id="form-settings">
			<input type="hidden" id="pageId" name="pageId" value="<?php echo $_POST['pageId']; ?>" />
			<input type="hidden" id="rowId" name="rowId" value="<?php echo $_POST['rowId']; ?>" />


        <p>
        <label>Anchor (Use with links #anchor)</label>        
        <input type="text" id="anchor" name="anchor" value="" />
        </p>			
			
			<p>
				<label>Text Color (Overwrite everything)</label>        
				<input type="text" id="textColor" name="textColor" value="" />
			<div id="textColorPicker" class="beopen-color-picker"></div>
		</p>

		<p>
			<label>Title Color (Overwrite everything)</label>        
			<input type="text" id="titleColor" name="titleColor" value="" />
		<div id="titleColorPicker" class="beopen-color-picker"></div>
		</p>


		<p>
			<label for="titleAlternativeStyle">Title Alternative Style</label>
			<select id="titleAlternativeStyle" name="titleAlternativeStyle">
				<?php
				$options = array(
					'' => 'Normal',
					'smallLine' => 'Small with Line'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>        
			</select>
		</p>        

		<p>
			<label for="backgroundAlternativeStyle">Background Alternative Style</label>
			<select id="backgroundAlternativeStyle" name="backgroundAlternativeStyle">
				<?php
				$options = array(
					'' => 'None',
					'innerShadow' => 'Inner Shadow'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>        
			</select>
		</p>


		<p>
			<label>Background Color</label>        
			<input type="text" id="color" name="color" value="" />
		<div id="colorPicker" class="beopen-color-picker"></div>
		</p>

		<p>
			<label>Background Image</label>
			<input type="text" id="backgroundImage" name="backgroundImage" value="" class="beopen_upload_input" />        
			<input class="beopen_no_picture" type="button" value="" />
		</p>

		<p>
			<label>Background Position</label>
			<select id="backgroundPosition" name="backgroundPosition">
				<?php
				$options = array(
					'left top' => 'Left Top',
					'left center' => 'Left Center',
					'left bottom' => 'Left Bottom',
					'center top' => 'Center Top',
					'center center' => 'Center Center',
					'center bottom' => 'Center Bottom',
					'right top' => 'Right Top',
					'right center' => 'Right Center',
					'right bottom' => 'Right Bottom'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>
			</select>        
		</p>

		<p>
			<label>Background Image Tile (Repeat)</label>
			<select id="backgroundRepeat" name="backgroundRepeat" >
				<?php
				$options = array(
					'no-repeat' => 'No repeat',
					'repeat' => 'Tile',
					'repeat-x' => 'Tile Horizontally',
					'repeat-y' => 'Tile Vertically'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>
			</select>
		</p>

		<p>
			<label>Background Image Attachment</label>
			<select id="backgroundAttachment" name="backgroundAttachment" >
				<?php
				$options = array(
					'scroll' => 'Scroll',
					'fixed' => 'Fixed'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>
			</select>
		</p>

		<p>
			<label>Background Size</label>
			<select id="backgroundSize" name="backgroundSize" >
				<?php
				$options = array(
					'' => 'Exact Size',
					'cover' => 'Cover'
				);

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>
			</select>
		</p>

		<p>
			<label>Background Video</label>
			<input type="text" id="backgroundVideo" name="backgroundVideo" value="" class="beopen_upload_input" />        
			<input class="beopen_no_picture" type="button" value="" />            
		</p>

		<p>
			<label>Background Video Opacity</label>
			<input type="text" id="backgroundVideoOpacity" name="backgroundVideoOpacity" value="100" />
			<span>(0 - totally transparent to 100 - totally opaque)</span>
		</p>

		<p>
			<label>Padding Top</label>       
			<input type="text" id="paddingTop" name="paddingTop" value="10" />
			<span class="description">Default <strong>10</strong> (px)</span>
		</p>

		<p>
			<label>Padding Bottom</label>       
			<input type="text" id="paddingBottom" name="paddingBottom" value="10" />
			<span class="description">Default <strong>10</strong> (px)</span>
		</p>

		<p>
			<label>Animations</label>
			<select id="animations" name="animations">
				<?php
				$options = $beopen_row_animations;

				foreach ($options as $value => $label) {
					echo '<option value="' . $value . '">' . $label . '</option>';
				}
				?>
			</select>        
		</p>	
		
		

		</form>
		<?php
		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_load-board-settings', 'beopen_visualeditor_load_board_settings');

	function beopen_visualeditor_load_board_settings() {
		global $wpdb; // this is how you get access to the database
		?>
		<form id="form-settings">
			<input type="hidden" id="pageId" name="pageId" value="<?php echo $_POST['pageId']; ?>" />
			<?php /* <input type="hidden" id="boardId" name="boardId" value="<?php echo $_POST['boardId']; ?>" /> */ ?>

			<p>
				<label>Content</label>
				<select name="item_count" id="item_count">
					<?php
					for ($i = 1; $i <= 10; $i++) {
						print '<option value="' . $i . '">' . $i . '</option>';
					}
					?>	
				</select>
			</p>


		</form>
		<?php
		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_load-slideshow-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-latest_posts-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-testimonials-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-motto-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-call_to_action-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-portfolio-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-wide_portfolio_grid-settings', 'beopen_visualeditor_load_defined_settings');

	function beopen_visualeditor_load_defined_settings() {
		global $wpdb; // this is how you get access to the database
		global $visual_editor_elements;
		?>
		<form id="form-settings">
			<input type="hidden" id="pageId" name="pageId" value="<?php echo $_POST['pageId']; ?>" />
			<input type="hidden" id="elementId" name="elementId" value="<?php echo $_POST['elementId']; ?>" />
			<?php
			$elementSettings = $visual_editor_elements[$_POST['elementType']];

			foreach ($elementSettings['options'] as $elementOptions) {
				echo '<p>';
				beopen_show_field($elementOptions, false, true);
				echo '</p>';
			}
			?>
		</form>
		<?php
		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_load-processes-settings', 'beopen_visualeditor_load_defined_settings');
	add_action('wp_ajax_load-services-settings', 'beopen_visualeditor_load_defined_settings');
	add_action('wp_ajax_load-clients-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_load-html_box-settings', 'beopen_visualeditor_load_defined_settings');
	add_action('wp_ajax_load-wide_html_box-settings', 'beopen_visualeditor_load_defined_settings');

	add_action('wp_ajax_save-board', 'beopen_visualeditor_save_board');

	function beopen_visualeditor_save_board() {
		global $wpdb; // this is how you get access to the database



		if ($_POST['page'] != 'beopen-template-preview') {

			$beopen_visualeditor_pages = get_option('beopen_visualeditor_pages', array());

			$beopen_visualeditor_pages[beopen_slug($_POST['page'])] = $_POST['page'];

			update_option('beopen_visualeditor_pages', $beopen_visualeditor_pages);

			// generate the response
			$response = json_encode(array(
				'slug' => beopen_slug($_POST['page']),
				'name' => $_POST['page']
			));


			// response output
			header("Content-Type: application/json");
			echo $response;
		}

		update_option('beopen_visualeditor_' . beopen_slug($_POST['page']), $_POST['board']);



		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_load-board', 'beopen_visualeditor_load_board');

	function beopen_visualeditor_load_board() {
		global $wpdb; // this is how you get access to the database
		// generate the response
		$response = json_encode(array(
			'board' => get_option('beopen_visualeditor_' . $_POST['page'])
		));

		// response output
		header("Content-Type: application/json");
		echo $response;

		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_delete-board', 'beopen_visualeditor_delete_board');

	function beopen_visualeditor_delete_board() {
		global $wpdb; // this is how you get access to the database

		$beopen_visualeditor_pages = get_option('beopen_visualeditor_pages', array());

		unset($beopen_visualeditor_pages[beopen_slug($_POST['page'])]);

		update_option('beopen_visualeditor_pages', $beopen_visualeditor_pages);

		die(); // this is required to return a proper result
	}

	add_action('wp_ajax_rename-board', 'beopen_visualeditor_rename_board');

	function beopen_visualeditor_rename_board() {
		global $wpdb; // this is how you get access to the database



		$page = $_POST['page'];
		$page_slug = beopen_slug($_POST['page']);

		$newpage = $_POST['newpage'];
		$newpage_slug = beopen_slug($_POST['newpage']);

		if ($page_slug != $newpage_slug) {


			$beopen_visualeditor_pages = get_option('beopen_visualeditor_pages', array());

			$beopen_visualeditor_pages_keys = array_keys($beopen_visualeditor_pages);
			$beopen_visualeditor_pages_values = array_values($beopen_visualeditor_pages);

			$i = 0;
			foreach ($beopen_visualeditor_pages as $k => $v) {
				if ($k == $page_slug) {
					$beopen_visualeditor_pages_keys[$i] = $newpage_slug;
					$beopen_visualeditor_pages_values[$i] = $newpage;
				}

				$i += 1;
			}

			$beopen_visualeditor_pages = array_combine($beopen_visualeditor_pages_keys, $beopen_visualeditor_pages_values);


			if (get_option(FIELD_PREFIX . 'homepage_layout') == $page_slug) {
				update_option(FIELD_PREFIX . 'homepage_layout', $newpage_slug);
			}

			update_option('beopen_visualeditor_' . $newpage_slug, get_option('beopen_visualeditor_' . $page_slug));
			update_option('beopen_visualeditor_' . $page_slug, '');


			update_option('beopen_visualeditor_pages', $beopen_visualeditor_pages);


			// generate the response
			$response = json_encode(array(
				'slug' => $newpage_slug
			));

			// response output
			header("Content-Type: application/json");
			echo $response;
		}

		die(); // this is required to return a proper result
	}
	
	
	add_action('wp_ajax_duplicate-board', 'beopen_visualeditor_duplicate_board');

	function beopen_visualeditor_duplicate_board() {
		global $wpdb; // this is how you get access to the database



		$page = $_POST['page'];
		$page_slug = beopen_slug($_POST['page']);

		$newpage = $_POST['newpage'];
		$newpage_slug = beopen_slug($_POST['newpage']);

		if ($page_slug != $newpage_slug) {


			$beopen_visualeditor_pages = get_option('beopen_visualeditor_pages', array());

			$beopen_visualeditor_pages_keys = array_keys($beopen_visualeditor_pages);
			$beopen_visualeditor_pages_values = array_values($beopen_visualeditor_pages);

			$beopen_visualeditor_pages_keys[] = $newpage_slug;
			$beopen_visualeditor_pages_values[] = $newpage;

			$beopen_visualeditor_pages = array_combine($beopen_visualeditor_pages_keys, $beopen_visualeditor_pages_values);

			update_option('beopen_visualeditor_' . $newpage_slug, get_option('beopen_visualeditor_' . $page_slug));

			update_option('beopen_visualeditor_pages', $beopen_visualeditor_pages);

			// generate the response
			$response = json_encode(array(
				'slug' => $newpage_slug
			));

			// response output
			header("Content-Type: application/json");
			echo $response;
		}

		die(); // this is required to return a proper result
	}	
?>