<?php

	global $beopen_item_count;
	$maxcount = 4;
	if ($beopen_item_count > 0) {
		$maxcount = $beopen_item_count;
	}


	$args = array('post_type' => 'post', 'order' => 'DESC', 'posts_per_page' => 20);
	$posts = get_posts($args);

	foreach ($posts as $post) {

		$output .= '<div class="last-posts rs-carousel-item">';
		$output .= '<div class="beopen-grid-container clearfix">';
		$output .= '<article>';
		$show_preview_as = get_post_meta($post->ID, 'show_preview_as', true);

		switch ($show_preview_as) {
			case 0:
				

				if (has_post_thumbnail($post->ID)) {
					
					$output .= '<a href="' . get_permalink($post->ID) . '" class="fixedsize">';
					
					$output .= '<figure class="beopen">';

					$output .= '<div class="see-more">';
					$output .= '<div class="beopen-table-full">';
					$output .= '<div class="beopen-table-cell-middle">';
					$output .= '<div class="portfolio-info">';
					$output .= '<span class="alia-icon-zoom-lines"></span>';
					$output .= '</div>';
					$output .= '</div>';
					$output .= '</div>';
					$output .= '</div>';
					
					$output .= '<div class="solid-bg"></div>';
					
					$output .= get_the_post_thumbnail($post->ID, 'latest-posts-thumbnail');					
					$output .= '</figure>';

					$output .= '<span class="over-block">' . fontello('camera') . '</span>';
					
					$output .= '</a>';
				}

				

				break;

			case 1:
				$embedvideo = get_post_meta($post->ID, 'embedvideo', true);

				if ($embedvideo) {
					$output .= '<div class="video">';
					$output .= $embedvideo;
					$output .= '</div>';
				}

				break;
			case 2:


				$args = array('post_type' => 'attachment', 'orderby' => 'menu_order', 'order' => 'ASC', 'numberposts' => -1, 'post_status' => null, 'post_parent' => $post->ID);
				$attachments = get_posts($args);
				if (count($attachments) > 0) {

					$output .= '<div class="flex-container">';
					$output .= '<div class="flexslider"><ul class="slides">';

					foreach ($attachments as $attachment) {
						$output .= '<li>';

						$output .= '<a href="' . get_permalink($post->ID) . '">';
						$output .= wp_get_attachment_image($attachment->ID, 'latest-posts-thumbnail');
						$output .= '</a>';

						$output .= '</li>';
					}

					$output .= '</ul>';
					$output .= '</div>';
					$output .= '<span class="over-block">' . fontello('picture') . '</span>';
					
					$output .= '</div>';
					
					
				}

				

				break;

			case 3:

				$output .= '<div class="beopen-latest-posts-preview">' . fontello('music') . '</div>';
				break;

			case 4:

				$output .= '<div class="beopen-latest-posts-preview">' . fontello('video') . '</div>';
				break;

			case 5:

				$output .= '<div class="beopen-latest-posts-preview">' . fontello('quote') . '</div>';
				break;
		}

		$output .= '<div class="content">';
		$output .= '<div class="metainfo">' . beopen_entry_categories($post->ID) . '</div>';

		$output .= '<h3>';
		$output .= '<a href="' . get_permalink($post->ID) . '">';
		$output .= beopen_letter_trim(get_the_title($post->ID), 60, true);
		$output .= '</a>';
		$output .= '</h3>';



		if (isset($box['data']['display_excerpt']) && ($box['data']['display_excerpt'] == 'no')) {
			
		} else {
			$output .= beopen_get_excerpt_by_id($post->ID);
		}

		if (isset($box['data']['display_readmore']) && ($box['data']['display_readmore'] == 'no')) {
			
		} else {
			$output .= '<a href="' . get_permalink($post->ID) . '" class="button readmore">' . __('Read more', 'beopen') . '</a>';
		}


		$output .= '</div>';


		$output .= '</article>';
		$output .= '</div>';
		$output .= '</div>';
	}
?>