<?php
    $no_items = $box['no_items'];
    if ($no_items > 0) {
        $maxcount = $no_items;
    } else {
        $maxcount = 6;
    }

    $args = array('post_type' => 'service_item', 'order' => 'ASC', 'posts_per_page' => $maxcount);
    $items = new WP_Query($args);

    if ($items->have_posts()) {
        while ($items->have_posts()) {
            $items->the_post();

            echo '<div class="service">';
            echo '<div class="service-bg">';

            $service_item_icon = get_post_meta(get_the_ID(), 'service_item_icon', true);
            $service_item_size = get_post_meta(get_the_ID(), 'service_item_size', true);
            $service_item_line_height = get_post_meta(get_the_ID(), 'service_item_line_height', true);
            $service_item_color = get_post_meta(get_the_ID(), 'service_item_color', true);

            echo beopen_renderIcon($service_item_icon, $service_item_size, $service_item_line_height, $service_item_color);                   

            if (has_post_thumbnail(get_the_ID())) { // check if the post has a Post Thumbnail assigned to it.
                the_post_thumbnail('widget-services-thumbnail');
            }                

            echo '</div>';
            echo '<h3>' . get_the_title(get_the_ID()) . '</h3>';
            echo '<div class="service-text">';
            echo do_shortcode(get_the_content(get_the_ID()));
            echo '</div>';

            echo '<a href="' . get_permalink() . '">';
            echo '</a>';

            echo '</div>';
        }
    }


?>