<?php

	function beopen_header() {
		?>
		<!-- Favicon and Feed -->
		<?php
		if (beopen_get_option('favicon')) {
			echo '<link rel="shortcut icon" href="' . beopen_get_option('favicon') . '" />';
		} else {
			echo '<link rel="shortcut icon" type="image/png" href="' . get_template_directory_uri() . '/favicon.ico">';
		}

		if (beopen_get_option('google_analytics_position') == 'top') {
			echo beopen_get_option('google_analytics_code');
		}

		echo '<style type="text/css">' . beopen_get_option('general_css') . '</style>';
	}

	add_action('wp_head', 'beopen_header');

	function beopen_footer() {

		if (beopen_get_option('google_analytics_position') == 'bottom') {
			echo beopen_get_option('google_analytics_code');
		}

		if (beopen_get_option('scroll_up_button') != '2') {
			echo '<a href="#" id="beopen-scroll-up-button" class="beopen-icon-slide_arrow_up active"></a>';
		}
	}

	add_action('wp_footer', 'beopen_footer');

	function beopen_sidebar_class() {
		if (beopen_get_option('sidebar_position') == 'left') {
			return ' sidebar-left';
		} else {
			return '';
		}
	}

	function beopen_with_without_sidebar_class() {
		if (beopen_get_option('show_sidebar') == '2') {
			return 'nine';
		} else {
			return 'twelve';
		}
	}

	function beopen_show_sidebar_left($force_show = false) {
		if (($force_show) || (beopen_get_option('show_sidebar') == '2')) {
			if (beopen_get_option('sidebar_position') == 'left') {
				get_sidebar();
			}
		}
	}

	function beopen_show_sidebar_right($force_show = false) {
		if (($force_show) || (beopen_get_option('show_sidebar') == '2')) {
			if (beopen_get_option('sidebar_position') == 'right') {
				get_sidebar();
			}
		}
	}

	function beopen_show_telephone() {
		echo '<span class="beopen-header-telephone">' . beopen_get_option('header_telephone') . '</span>';
	}

	function beopen_show_email() {
		echo '<span class="beopen-header-email">' . beopen_get_option('header_email') . '</span>';
	}

	function beopen_show_social_icons($center = false) {
		$output = '';
		$i = 0;

		if (beopen_get_option('show_social_facebook') == '2') {
			$output .= '<a href="' . beopen_get_option('social_facebook_url') . '" class="socialicon-facebook">' . fontello('facebook') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_twitter') == '2') {
			$output .= '<a href="' . beopen_get_option('social_twitter_url') . '" class="socialicon-twitter">' . fontello('twitter') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_linkedin') == '2') {
			$output .= '<a href="' . beopen_get_option('social_linkedin_url') . '" class="socialicon-linkedin">' . fontello('linkedin') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_googleplus') == '2') {
			$output .= '<a href="' . beopen_get_option('social_googleplus_url') . '" class="socialicon-googleplus">' . fontello('gplus') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_pinterest') == '2') {
			$output .= '<a href="' . beopen_get_option('social_pinterest_url') . '" class="socialicon-pinterest">' . fontello('pinterest') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_dribbble') == '2') {
			$output .= '<a href="' . beopen_get_option('social_dribbble_url') . '" class="socialicon-dribbble">' . fontello('dribbble') . '</a>';
			$i += 1;
		}

		if (beopen_get_option('show_social_rss') == '2') {
			$output .= '<a href="' . beopen_get_option('social_rss_url') . '" class="socialicon-rss">' . fontello('rss') . '</a>';
			$i += 1;
		}




		if ($center) {
			$width = $i * 25 + 1;
			$output = '<div class="hcenter" style="width: ' . $width . 'px;">' . $output . '</div>';
		}

		echo $output;
	}

	function beopen_main_title() {

		if (!is_front_page()) {

			$frontpage_id = get_option('page_for_posts');

			if (is_home()) {
				echo '<h1>' . get_the_title($frontpage_id) . '</h1>';
			} else
			if (!is_single())
				if (is_category() || !is_singular('beopen_portfolio')) {

					$category = get_category(get_query_var('cat'));

					if (isset($category->cat_ID)) {
						$ID = $category->cat_ID;
						if ($ID) {
							echo '<h1>' . $category->name . '</h1>';
						}
					}
				}
		} else
		if (is_category() || is_single() || !is_singular('beopen_portfolio')) {

			$category = get_the_category();
			if (isset($category[0])) {
				$ID = $category[0]->cat_ID;
				if ($ID) {
					echo '<h1>' . get_category_parents($ID, FALSE, '', FALSE) . '</h1>';
				}
			}
		}

		if (is_singular('beopen_portfolio')) {
			echo get_the_term_list($post->ID, 'portfolio_category', '', '', '');
		}

		if (is_home()) {
			
		}

		if (is_singular('portfolio_item')) {
			echo '<h1>' . get_the_title() . '</h1>';
		} else
		if (is_single()) { // if from blog
			echo '<h1>' . __('Blog', 'beopen') . '</h1>';
		} else
		if (is_page()) {
			echo '<h1>' . get_the_title() . '</h1>';
		}

		if (is_tag()) {
			echo '<h1>' . "Tag: " . single_tag_title('', FALSE) . '</h1>';
		}

		if (is_author()) {
			global $wp_query;
			$curauth = $wp_query->get_queried_object();
			echo '<h1>' . $curauth->nickname . '</h1>';
		}

		if (is_404()) {
			echo '<h1>' . __("404 - Page not Found", 'beopen') . '</h1>';
		}

		if (is_search()) {
			echo '<h1>' . __('Search Results for', 'beopen') . ' "' . get_search_query() . '"</h1>';
		}

		if (is_year()) {
			echo '<h1>' . get_the_time('Y') . '</h1>';
		}

		if (is_archive()) {
			echo '<h1>' . __("Archive", 'beopen') . '</h1>';
		}
	}

	function beopen_breadcrumb() {
		echo '<ul class="breadcrumbs">';

		if (!is_front_page()) {
			echo '<li><a href="';
			echo home_url();
			echo '" class="home">' . fontello('home'); // . __('Home', 'beopen');
			echo "</a></li>";
		}

		if (!is_front_page()) {

			$frontpage_id = get_option('page_for_posts');

			if (is_home()) {
				echo '<li>' . get_the_title($frontpage_id) . '</li>';
			} else
			if (!is_single())
				if (is_category() || !is_singular('beopen_portfolio')) {

					$category = get_category(get_query_var('cat'));
					if (isset($category->cat_ID)) {
						$ID = $category->cat_ID;
						if ($ID) {
							echo '<li>' . $category->name . '</li>';
						}
					}
				}
		} else
		if (is_category() || is_single() || !is_singular('beopen_portfolio')) {
			$category = get_the_category();
			if (isset($category[0])) {
				$ID = $category[0]->cat_ID;
				if ($ID) {
					echo '<li>' . get_category_parents($ID, TRUE, '', FALSE) . '</li>';
				}
			}
		}

		if (is_singular('beopen_portfolio')) {
			echo get_the_term_list($post->ID, 'portfolio_category', '<li>', ' - ', '</li>');
		}

		if (isset($post)) {
			echo get_the_term_list($post->ID, 'portfolio_tag', '<li>', ' - ', '</li>');
		}

		if (is_single() || is_page()) {
			echo '<li>' . get_the_title() . '</li>';
		}

		if (is_tag()) {
			echo '<li>' . __("Tag: ", 'beopen') . single_tag_title('', FALSE) . '</li>';
		}

		if (is_author()) {
			echo '<li>' . __("Author ", 'beopen') . '</li>';
		}

		if (is_404()) {
			echo '<li>' . __("404 - Page not Found", 'beopen') . '</li>';
		}

		if (is_search()) {
			echo '<li>' . __("Search", 'beopen') . '</li>';
		}

		if (is_year()) {
			echo '<li>' . get_the_time('Y') . '</li>';
		}

		echo "</ul>";
	}

	function beopen_portfolio_navigate() {
		echo '<div class="portfolio-navigation">';



		$templates = wp_get_theme()->get_page_templates();
		$templates = array_reverse($templates);

		$url_portfolio_all = '';

		foreach ($templates as $template_filename => $template_name) {

			if (!$url_portfolio_all) {

				if (strpos($template_filename, 'portfolio') !== false) {

					$pages = get_posts(array(
						'post_type' => 'page',
						'meta_key' => '_wp_page_template',
						'meta_value' => $template_filename
					));

					foreach ($pages as $page) {
						$url_portfolio_all = get_permalink($page->ID);
					}
				}
			}
		}

		if ($url_portfolio_all) {
			echo '<a href="' . $url_portfolio_all . '" class="portfolio-all"></a>';
		}


		previous_post_link('%link', '<span></span>');
		next_post_link('%link', '<span></span>');

		echo '</div>';
	}

	function beopen_portfolio_entry_meta($showing = null) {

		if ($showing == null) {
			$showing = array('date', 'likes');
		}

		echo '<div class="metainfo">';

		echo '</div>';
	}

	function beopen_footer_portfolio_entry_meta() {

		echo '<div class="portfolio-details">';

		// PORTFOLIO DATE
		echo '<div class="date">';

		echo get_the_date();

		echo '</div>';

		// PORTFOLIO AUTHOR
		$portfolioclient = get_post_meta(get_the_ID(), 'portfolioclient', true);

		if ($portfolioclient) {
			echo '<div class="author">';

			echo $portfolioclient;

			echo '</div>';
		}

		// PORTFOLIO TAGS
		$aterms = get_the_terms(get_the_ID(), 'portfolio_tag');
		$aclassterms = array();

		if ($aterms) {

			echo '<div class="tags">';

			$_terms = array();

			foreach ($aterms as $term) {
				$_terms[] = $term->name;
			}

			echo implode(', ', $_terms);

			echo '</div>';
		}



		// PORTFOLIO LIKES
		echo '<div class="likes">';

		echo '<span class="counter">';
		if (function_exists('getBeopenLove')) {
			echo getBeopenLove('count');
		}

		echo '</span>';
		echo ' likes';
		if (function_exists('getBeopenLove')) {
			echo getBeopenLove('plus');
		}

		echo '</div>';


		echo '</div>';




		$urllink = get_post_meta(get_the_ID(), 'urllink', true);


		if ($urllink) {
			echo '<a class="button" target="_blank" href="' . $urllink . '">Visit site</a>';
		}
	}

	function beopen_footer_entry_meta() {

		$post_tags = wp_get_post_tags(get_the_ID());

		if ($post_tags) {

			if (beopen_get_option('show_post_tags') == 2) {

				echo '<div class="tags">';

				$_tags = array();

				foreach ($post_tags as $tag) {
					$_tags[] = '<a class="button" href="' . get_tag_link($tag->term_id) . '">' . $tag->name . '</a>';
				}

				echo implode('', $_tags);

				echo '</div>';
			}
		}
	}

	// return entry meta information for posts, used by multiple loops.
	function beopen_entry_meta($showing = null) {

		if ($showing == null) {
			$showing = array('media', 'date', 'author', 'comments', 'tags');
		}

		echo '<div class="metainfo">';

		$show_preview_as = get_post_meta(get_the_ID(), 'show_preview_as', true);

		foreach ($showing as $item) {

			switch ($item) {

				case 'media':

					switch ($show_preview_as) {
						case 0: // featured image
							if (has_post_thumbnail(get_the_ID())) {
								echo '<div class="media">';
								echo '<i class="beopen-icon">' . fontello('camera') . '</i>';
								echo '</div>';
							}
							break;
						case 2: // gallery
							echo '<div class="media">';
							echo '<i class="beopen-icon">' . fontello('picture') . '</i>';
							echo '</div>';
							break;
						case 3: // audio
							echo '<div class="media">';
							echo '<i class="beopen-icon">' . fontello('music') . '</i>';
							echo '</div>';
							break;
						case 4: // video
							echo '<div class="media">';
							echo '<i class="beopen-icon">' . fontello('video') . '</i>';
							echo '</div>';
							break;
						case 5: // quote
							echo '<div class="media">';
							echo '<i class="beopen-icon">' . fontello('quote') . '</i>';
							echo '</div>';
							break;
					}


					break;
				case 'date':
					if (beopen_get_option('show_post_date') == 2) {
						echo '<div class="date">';
						echo '<span class="meta-icon">' . fontello('calendar') . '</span>';
						echo '<span class="meta-title">' . __('Date:', 'beopen') . '</span>';
						echo '<span class="meta-value date-all">' . get_the_date() . '</span>';
						echo '</div>';
					}
					break;
				case 'author':
					if (($show_preview_as <= 2) || (is_single()))
						if (beopen_get_option('show_post_author') == 2) {
							echo '<div class="author">';
							echo '<span class="meta-icon">' . fontello('user') . '</span>';
							echo '<span class="meta-title">' . __('Author:', 'beopen') . '</span>';
							echo '<a href="' . get_author_posts_url(get_the_author_meta('ID')) . '" rel="author" class="meta-value fn">' . get_the_author() . '</a>';
							echo '</div>';
						}
					break;
				case 'comments':
					if (($show_preview_as <= 2) || (is_single())) {
						echo '<div class="comments">';
						echo '<span class="meta-icon">' . fontello('comment') . '</span>';
						echo '<span class="meta-title">' . __('Comments:', 'beopen') . '</span>';
						echo '<a href="' . get_comments_link() . '" class="meta-value">';
						comments_number(__('0', 'beopen'), __('1', 'beopen'), __('%', 'beopen'));
						echo '</a>';
						echo '</div>';
					}
					break;
				case 'tags':
					if (beopen_get_option('show_post_tags') == 2)
						if (($show_preview_as <= 2) || (is_single())) {
							echo '<div class="tags">';
							echo '<span class="meta-icon">' . fontello('tag') . '</span>';
							echo '<span class="meta-title">' . __('Tags:', 'beopen') . '</span>';

							$post_tags = wp_get_post_tags(get_the_ID());

							if ($post_tags) {
								$_tags = array();

								foreach ($post_tags as $tag) {
									$_tags[] = '<a href="' . get_tag_link($tag->term_id) . '">' . $tag->name . '</a>';
								}

								echo implode('', $_tags);
							}


							echo '</a>';
							echo '</div>';
						}
					break;
			}
		}



		echo '</div>';
	}

	function beopen_entry_categories($ID = null) {

		if (!$ID) {
			$ID = get_the_ID();
		}

		$output = '';
		if (beopen_get_option('show_post_categories') == 2) {

			$post_categories = wp_get_post_categories($ID);
			if ($post_categories) {
				$output .= '<div class="cats">';

				$_categories = array();

				foreach ($post_categories as $c) {
					$cat = get_category($c);
					$_categories[] = '<a href="' . get_category_link($cat->term_id) . '">' . $cat->name . '</a>';
				}

				$output .= implode(', ', $_categories);

				$output .= '</div>';
			}
		}

		return $output;
	}

	function beopen_display_logo_image() {
		
		if (beopen_get_option('site_logo_retina')) {
			echo '<img src="' . beopen_get_option('site_logo_retina') . '" alt="' . esc_attr(get_bloginfo('name')) . '" class="beopen-logo-retina">';
		}
		else
		{
			echo '<img src="' . beopen_get_option('site_logo') . '" alt="' . esc_attr(get_bloginfo('name')) . '">';
		}
	}

	function beopen_display_slogan() {

		$left = intval(beopen_get_option('slogan_position_left'));
		$top = intval(beopen_get_option('slogan_position_top'));

		if ($left || $top) {
			echo '<span class="slogan" ';
			echo 'style="padding-left:' . $left . 'px; padding-top:' . $top . 'px; display: block;"';
			echo '>';
		}

		echo beopen_get_option('slogan');

		if ($left || $top) {
			echo '</span>';
		}
	}

	function beopen_show_pagetitlebar() {

		$show = true;
		
		if (is_page_template('template-start-page.php')) {
			$show = false;			
		}
		else
		if (is_page_template('template-custom-template.php')) {

			$show = false;
			if (get_post_meta(get_the_ID(), 'beopen_show_pagetitlebar', true) == 'yes') {
				$show = true;
			}
		}


		if ($show) {
			echo '<div class="topbar"><div class="row">';

			echo beopen_main_title();
			if (beopen_get_option('show_breadcrumbs') == '2') {
				echo beopen_breadcrumb();
			} else {
				echo '<div class="breadcrumbs-placeholder"></div>';
			}
			echo '</div></div>';
		}
	}

	function beopen_get_current_page_content() {

		while (have_posts()) {
			the_post();
			if (get_the_content()) {
				?>
				<div class="row beopen-start-content">
					<div class="twelve columns">
						<?php echo wpautop(get_the_content()); ?>
					</div>
				</div>        
				<?php
			}
		}
	}

	function beopen_include_visualeditor_layout($location) {
		global $template_visualeditor_before;
		global $template_visualeditor_after;

		if ($location == 'header') {
			if ($template_visualeditor_before) {
				beopen_visual_render::render($template_visualeditor_before);
			}
		}

		if ($location == 'footer') {
			if ($template_visualeditor_after) {
				beopen_visual_render::render($template_visualeditor_after);
			}
		}
	}

	function beopen_footer_links() {
		$addedlink = false;
		if (beopen_get_option('show_privacy_policy') == 2) {
			$addedlink = true;
			echo '<a href="' . beopen_get_option('privacy_policy_url') . '">' . __('Privacy Policy', 'beopen') . '</a>';
		}

		if ($addedlink) {
			$addedlink = false;
			echo '<span class="separator"></span>';
		}

		if (beopen_get_option('show_terms_and_conditions') == 2) {
			$addedlink = true;
			echo '<a href="' . beopen_get_option('terms_and_conditions_url') . '">' . __('Terms &amp; Conditions', 'beopen') . '</a>';
		}

		if ($addedlink) {
			$addedlink = false;
			echo '<br />';
		}

		if (beopen_get_option('show_sitemap') == 2) {
			$addedlink = true;
			echo '<a href="' . beopen_get_option('sitemap_url') . '">' . __('Sitemap', 'beopen') . '</a>';
		}
	}

	function beopen_portfolio_tag_filter() {
		global $beopen_post;

		$beopen_filter_portfolio_category = get_post_meta($beopen_post->ID, 'beopen_portfolio_category', true);

		$args = array('taxonomy' => 'portfolio_tag');

		$terms = get_terms('portfolio_tag', $args);


		$count = count($terms);
		$i = 0;
		if ($count > 0) {
			$term_list = '<div id="portfolio-filter">';

			$args = array(
				'post_type' => 'portfolio_item',
				'post_status' => 'publish',
				'posts_per_page' => -1
			);

			if ($beopen_filter_portfolio_category) {
				$args['portfolio_category'] = $beopen_filter_portfolio_category;
			}

			$count = count(get_posts($args));
			$portfolio_count = ' (' . $count . ')';

			$term_list .= '<a href="" class="portfolio_tag portfolio_tag_selected" id="portfolio_all" data-filter="*"><span class="portfolio_tag_inner">All<span class="portfolio_count">' . $portfolio_count . '</span></span></a>';

			foreach ($terms as $term) {

				$args = array(
					'post_type' => 'portfolio_item',
					'portfolio_tag' => $term->slug,
					'post_type' => 'portfolio_item',
					'post_status' => 'publish',
					'posts_per_page' => -1
				);

				if ($beopen_filter_portfolio_category) {
					$args['portfolio_category'] = $beopen_filter_portfolio_category;
				}

				$count = count(get_posts($args));
				$portfolio_count = ' (' . $count . ')';

				$i++;

				if ($count > 0) {
					$term_list .= '<a href="#" class="portfolio_tag" id="' . $term->slug . '" data-filter=".' . $term->slug . '"><span class="portfolio_tag_inner">' . $term->name . '<span class="portfolio_count">' . $portfolio_count . '</span></span></a>';
				}
			}

			$term_list .= '</div>';

			echo $term_list;
		}
	}

	function beopen_portfolio_size_filter() {
		echo '<div id="portfolio-sizes">';

		$portfolio_columns = array('2' => '2 Columns', '3' => '3 Columns', '4' => '4 Columns');
		foreach ($portfolio_columns as $slug => $column) {
			echo '<a href="#" class="portfolio_tag" id="portfolio-size' . $slug . '" data-filter="' . $slug . '"><span class="portfolio_tag_inner">' . $column . '</span></a>';
		}

		echo '</div>';
	}

	/* HOOKS */

	add_action('wp_head', 'beopen_globals');

	function beopen_globals() {
		global $beopen_post;
		if (is_page()) {
			$beopen_post = get_post(get_the_ID());
		}
	}

	add_action('wp_head', 'css_visualeditor');

	function css_visualeditor() {
		global $template_visualeditor_before;
		global $template_visualeditor_after;

		if (is_page()) {

			$template_visualeditor_before = get_post_meta(get_the_ID(), 'template_visualeditor_before', true);

			if ($template_visualeditor_before) {
				beopen_visual_render::render($template_visualeditor_before, true);
			}

			$template_visualeditor_after = get_post_meta(get_the_ID(), 'template_visualeditor_after', true);

			if ($template_visualeditor_after) {
				beopen_visual_render::render($template_visualeditor_after, true);
			}
		}

		global $template_visualeditor;
		if ($template_visualeditor) {
			beopen_visual_render::render($template_visualeditor, true);
		}
	}

	function beopen_get_map_array() {

		$lat = 40.69847032728747;
		$long = -73.9514422416687;

		$map_coordinates = beopen_get_option('map_coordinates');

		if (beopen_get_option('map_zoom')) {
			$zoom = beopen_get_option('map_zoom');
		} else {
			$zoom = 14;
		}

		if (strpos($map_coordinates, ',') !== false) {
			$s = $map_coordinates;
			$coord = explode(',', $s);

			$lat = $coord[0];
			$long = $coord[1];
		}

		return array('lat' => $lat, 'long' => $long, 'zoom' => $zoom);
	}
?>