<?php function beopen_comments($comment, $args, $depth) {
    $GLOBALS['comment_counter'] += 1;
	$GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(); ?>>
		<article id="comment-<?php comment_ID(); ?>">
		
			<?php echo get_avatar( $comment->comment_ID, $size='51' ); ?>
		
			<header class="comment-author vcard">
				<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>			
				
				<?php edit_comment_link(__('Edit', 'beopen'), '', '') ?>
                
                <cite class="fn"><?php printf(__('%s says', 'beopen'), get_comment_author_link()) ?></cite>
                
                <time datetime="<?php echo comment_date('c') ?>"><?php printf(__('%1$s', 'beopen'), get_comment_date(),  get_comment_time()) ?></time>
			</header>
			
			<?php if ($comment->comment_approved == '0') : ?>
       			<div class="notice">
					<p class="bottom"><?php _e('Your comment is awaiting moderation.', 'beopen') ?></p>
          		</div>
			<?php endif; ?>
			
			<section class="comment">
				<?php comment_text() ?>
			</section>
			
		</article>
<?php } ?>

<?php
// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die (__('Please do not load this page directly. Thanks!', 'beopen'));

	if ( post_password_required() ) { ?>
	<section id="comments">
		<div class="notice">
			<p class="bottom"><?php _e('This post is password protected. Enter the password to view comments.', 'beopen'); ?></p>
		</div>
	</section>
	<?php
		return;
	}
?>
<?php // You can start editing here. Customize the respond form below ?>
<?php 
    $GLOBALS['comment_counter'] = 0;
?>    
    

<?php if ( have_comments() ) : ?>
	<section id="comments">
		<h3><?php _e('Comments', 'beopen'); ?></h3>
		<p><a href="<?php echo get_comments_link(); ?>"><?php _e('Leave a comment', 'beopen'); ?></a></p>
		
		<ol class="commentlist">
		<?php wp_list_comments('type=all&callback=beopen_comments'); ?>
		</ol>

		<nav id="comments-nav">
			<div class="comments-previous"><?php previous_comments_link( __( '&larr; Older comments', 'beopen' ) ); ?></div>
			<div class="comments-next"><?php next_comments_link( __( 'Newer comments &rarr;', 'beopen' ) ); ?></div>
		</nav>
	</section>
<?php else : // this is displayed if there are no comments so far ?>
	<?php if ( comments_open() ) : ?>
	<?php else : // comments are closed ?>
	<?php endif; ?>
<?php endif; ?>
      
<?php comment_form(array(
        'comment_notes_after' => ''
    )); 
?>