<?php

	global $visual_editor_elements;
	global $fontello;
	global $beopen_row_animations;
	

	$fontello_options = array();
	foreach ($fontello as $font_name => $font_code) {
		$fontello_options[$font_code] = $font_name;
	}
	

	
	
	
	$beopen_row_animations = array(
		'' => __('Disabled', 'beopen'),
		'slideUp' => __('Slide Up', 'beopen'),
		'slideDown' => __('Slide Down', 'beopen'),
		'slideLeft' => __('Slide Left', 'beopen'),
		'slideRight' => __('Slide Right', 'beopen'),
		'slideExpandUp' => __('Slide Expand Up', 'beopen'),
		'expandUp' => __('Expand Up', 'beopen'),
		'fadeIn' => __('Fade In', 'beopen'),
		'expandOpen' => __('Expand Open', 'beopen'),
		'bigEntrance' => __('Big Entrance', 'beopen'),
		'hatch' => __('Hatch', 'beopen')
	);

	
	

	$visual_editor_elements = array(
		'slideshow' => array(
			'title' => 'Slideshow',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Revolution Slider Alias',
					'name' => 'alias',
					'type' => 'text',
					'default' => '',
					'description' => 'Leave empty for "homepage_revolution_slider".'
				),
			)
		),
		'call_to_action' => array(
			'title' => 'Call To Action',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),			
				array(
					'label' => 'Call To Action Text',
					'name' => 'call_to_action_text',
					'type' => 'text',
					'default' => '',
					'description' => '(overwrites general settings)'
				),
				array(
					'label' => 'Call To Action Button Text',
					'name' => 'call_to_action_button_text',
					'type' => 'text',
					'default' => '',
					'description' => '(overwrites general settings)'
				),
				array(
					'label' => 'Call To Action Button Link',
					'name' => 'call_to_action_button_link',
					'type' => 'text',
					'default' => '',
					'description' => '(overwrites general settings)'
				)
			)
		),
		'motto' => array(
			'title' => 'Motto',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Motto Text',
					'name' => 'motto_text',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'services' => array(
			'title' => 'Services',
			'columns' => array(1, 2, 3, 4),
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'processes' => array(
			'title' => 'Processes',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'portfolio' => array(
			'title' => 'Portfolio',
			'columns' => array(1, 2, 3, 4),
			'carousel' => true,
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Filter by category',
					'name' => 'filter_by_category',
					'type' => 'filter_by_category',
					'default' => '',
					'description' => ''
				),				
				array(
					'label' => 'Limit To',
					'name' => 'limit_to',
					'type' => 'text',
					'default' => '',
					'description' => 'Leave empty to default to 8. Depends on the number of created Portfolio Items.'
				),
				array(
					'label' => 'Button Text',
					'name' => 'url_portfolio_text',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Button URL',
					'name' => 'url_portfolio',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'wide_portfolio_grid' => array(
			'title' => 'Wide Portfolio Grid',
			'columns' => array(4),
			'carousel' => false,
			'wide' => true,
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Filter by category',
					'name' => 'filter_by_category',
					'type' => 'filter_by_category',
					'default' => '',
					'description' => ''
				),								
				array(
					'label' => 'Limit To',
					'name' => 'limit_to',
					'type' => 'text',
					'default' => '',
					'description' => 'Leave empty to default to 8. Depends on the number of created Portfolio Items.'
				),
				array(
					'label' => 'URL Portfolio Text',
					'name' => 'url_portfolio_text',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'URL Portfolio',
					'name' => 'url_portfolio',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'latest_posts' => array(
			'title' => 'Latest Posts',
			'columns' => array(1, 2, 3, 4),
			'carousel' => true,
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Display Date?',
					'name' => 'display_date',
					'type' => array('' => 'Yes', 'no' => 'No'),
					'default' => 'yes',
					'description' => ''
				),
				array(
					'label' => 'Display Excerpt?',
					'name' => 'display_excerpt',
					'type' => array('' => 'Yes', 'no' => 'No'),
					'default' => 'yes',
					'description' => ''
				),
				array(
					'label' => 'Display \'Read more\' button ?',
					'name' => 'display_readmore',
					'type' => array('' => 'Yes', 'no' => 'No'),
					'default' => 'yes',
					'description' => ''
				)
			)
		),
		'testimonials' => array(
			'title' => 'Testimonials',
			'columns' => array(2, 3, 4),
			'carousel' => true,
			'options' => array(
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Display pagination (bullets)?',
					'name' => 'display_pagination',
					'type' => array('' => 'Yes', 'no' => 'No'),
					'default' => 'yes',
					'description' => ''
				)
			)
		),
		'clients' => array(
			'title' => 'Clients',
			'columns' => array(1, 2, 3, 4),
			'carousel' => true,
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'html_box' => array(
			'title' => 'HTML Box',
			'columns' => array(1, 2, 3, 4),
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Content',
					'name' => 'content',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'widget_bar_1' => array(
			'title' => 'Widget Bar 1',
			'columns' => array(1, 2, 3, 4),
		),
		'widget_bar_2' => array(
			'title' => 'Widget Bar 2',
			'columns' => array(1, 2, 3, 4),
		),
		'widget_bar_3' => array(
			'title' => 'Widget Bar 3',
			'columns' => array(1, 2, 3, 4),
		),
		'featurebox' => array(
			'title' => 'FeatureBox',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Headline',
					'name' => 'headline',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Description',
					'name' => 'description',
					'type' => 'textarea',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Description Extra',
					'name' => 'descriptionExtra',
					'type' => 'textarea',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Attached Image',
					'name' => 'attachedImage',
					'type' => 'fileupload',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Attached Image Placement',
					'name' => 'attachedImagePlacement',
					'type' => array(
						'' => 'Headline + Description Left to LEFT | Image to RIGHT',
						'image-left' => 'Headline + Description Right to RIGHT | Image to LEFT',
						'two-description-main-left' => 'Headline + Description Left to Left | Extra Description to RIGHT',
						'two-description-main-right' => 'Headline + Description Right to Right | Extra Description to Left',
						'image-center' => 'Headline + Description + Image to CENTER'
					),
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Attached Image Frame',
					'name' => 'attachedImageFrame',
					'type' => array(
						'' => 'None',
						'website' => 'Website',
						'phone' => 'Phone'
					),
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Link',
					'name' => 'link',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Button Text',
					'name' => 'buttonText',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'options_box' => array(
			'title' => 'Options Box',
			'columns' => array(4),
			'options' => array(
				array(
					'label' => 'Headline',
					'name' => 'headline',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Description',
					'name' => 'description',
					'type' => 'textarea',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 1 - Icon',
					'name' => 'option1Icon',
					'type' => $fontello_options,
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 1 - URL',
					'name' => 'option1Url',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 2 - Icon',
					'name' => 'option2Icon',
					'type' => $fontello_options,
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 2 - URL',
					'name' => 'option2Url',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 3 - Icon',
					'name' => 'option3Icon',
					'type' => $fontello_options,
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Options 3 - URL',
					'name' => 'option3Url',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		),
		'wide_html_box' => array(
			'title' => 'Wide HTML Box',
			'columns' => array(4),
			'wide' => true,
			'options' => array(
				array(
					'label' => 'Subtitle',
					'name' => 'subtitle',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Title',
					'name' => 'title',
					'type' => 'text',
					'default' => '',
					'description' => ''
				),
				array(
					'label' => 'Content',
					'name' => 'content',
					'type' => 'text',
					'default' => '',
					'description' => ''
				)
			)
		)
	);
?>
