<?php
    if (!isset($content_width))
        $content_width = 1170;



    // Required BEOPEN Framework - do not edit
    require_once(TEMPLATEPATH . '/beopen_framework/init.php');


/**********************************
   WORDPRESS AFTER SETUP
**********************************/        
    
    function beopen_ie_conditional($tag, $handle) {
        if ('beopen-ie-only' == $handle)
            $tag = '<!--[if lt IE 9]>' . "\n" . $tag . '<![endif]-->' . "\n";
        return $tag;
    }

    
    function beopen_setup() {

        load_theme_textdomain('beopen', get_template_directory() . '/language');

        // Add post thumbnail supports. http://codex.wordpress.org/Post_Thumbnails
		add_theme_support('post-thumbnails' ); 		
		
        add_image_size('portfolio-thumbnail', 600, 600, true);
        add_image_size('portfolio-round-thumbnail', 600, 340, true);

        add_image_size('latest-posts-thumbnail', 255, 155, true);


        add_image_size('featurebox-website', 364, 336, true);
        add_image_size('featurebox-phone', 316, 277, true);

        add_image_size('portfolio-thumbnail-2-columns', 565, 565, true);

        add_image_size('full-portfolio-thumbnail', 590, 400, true);

        add_image_size('widget-post-thumbnail', 50, 50, true);

        add_image_size('widget-services-thumbnail', 40, 40, true);

        add_image_size('widget-portfolio-thumbnail', 110, 110, true);

        add_image_size('services-thumbnail', 170, 170, true);
        add_image_size('processes-thumbnail', 35, 35, true);

        add_image_size('client-thumbnail', 300, 120, false);

        add_image_size('member-thumbnail-big', 360, 360, true);
        add_image_size('member-thumbnail', 360, 360, true);


        add_image_size('blog-thumbnail', 825, 424, true);
        add_image_size('full-width-blog-thumbnail', 1150, 600, true);


        add_image_size('testimonial-thumbnail', 60, 60, true);


        add_theme_support('automatic-feed-links');
		

        add_theme_support('menus');
        register_nav_menus(array(
            'primary_navigation' => __('Primary Navigation', 'beopen')
        ));

        // ie conditional wrapper
        add_filter('style_loader_tag', 'beopen_ie_conditional', 10, 2);
    }

    add_action('after_setup_theme', 'beopen_setup');

    
/**********************************
   JAVASCRIPT AND CSS FOR FRONTEND
**********************************/

    function beopen_enqueue_css() {
        // Disable Styling from WP Better Attachments plugin
        wp_deregister_style('wpba_front_end_styles');
        wp_dequeue_style('wpba_front_end_styles');

        wp_register_style('prettyPhoto', get_template_directory_uri() . '/css/prettyPhoto.css', false);
        wp_enqueue_style('prettyPhoto');

        wp_register_style('font-awesome', ADMIN_CSS . '/font-awesome.css', false);
        wp_enqueue_style('font-awesome');

        wp_register_style('beopen-font', get_template_directory_uri() . '/css/beopen-font.css', false);
        wp_enqueue_style('beopen-font');

        wp_register_style('fontello', get_template_directory_uri() . '/css/fontello.css', false);
        wp_enqueue_style('fontello');

        wp_register_style('beopen-foundation', get_template_directory_uri() . '/css/foundation.css');
        wp_enqueue_style('beopen-foundation');

        wp_register_style('beopen-general', get_template_directory_uri() . '/css/general.css', array('beopen-foundation'));
        wp_enqueue_style('beopen-general');

        $skin_selector = get_option(FIELD_PREFIX . 'skin_selector');
        if (!$skin_selector) {
            $skin_selector = 'default';
        }
        
        if ((get_stylesheet_directory_uri() != get_template_directory_uri()) && (file_exists(CHILD_THEME_DIR . '/css/skins/' . $skin_selector))) {
            wp_register_style('beopen-skin_selector', CHILD_THEME_CSS . '/skins/' . $skin_selector . '.css', array('beopen-general'));
        } else {
            wp_register_style('beopen-skin_selector', THEME_CSS . '/skins/' . $skin_selector . '.css', array('beopen-general'));
        }
        wp_enqueue_style('beopen-skin_selector');

        wp_register_style('beopen-style', get_stylesheet_directory_uri() . '/style.css');
        wp_enqueue_style('beopen-style');

        wp_register_style('beopen-custom', get_template_directory_uri() . '/css/custom.css');
        wp_enqueue_style('beopen-custom');

        wp_register_style('google_font_standard_1', "http://fonts.googleapis.com/css?family=Open+Sans:300,300italic,400,600,700,800", null);
        wp_enqueue_style('google_font_standard_1');

        wp_register_style('revolution.slider', get_stylesheet_directory_uri() . '/css/revolution.slider.css', false);
        wp_enqueue_style('revolution.slider');

        // ie-only style sheet
        wp_register_style('beopen-ie-only', get_template_directory_uri() . '/css/ie.css', array(), '');
        wp_enqueue_style('beopen-ie-only');
		
		wp_register_style('beopen-animations', get_template_directory_uri() . '/css/animations.css', false);
        wp_enqueue_style('beopen-animations');
    }

    add_action('wp_enqueue_scripts', 'beopen_enqueue_css');
    
   
    // Enqueue js files
    function beopen_enqueue_scripts() {

        global $is_IE;

        // Enqueue to header
        wp_enqueue_script('jquery');
        wp_enqueue_script('jquery-ui-core');

        wp_register_script('modernizr', get_template_directory_uri() . '/js/modernizr.foundation.js', array('jquery'));
        wp_enqueue_script('modernizr');

        wp_register_script('superfish', get_template_directory_uri() . '/js/superfish.js', array('hoverIntent'), array(), false, true);
        wp_enqueue_script('superfish');

        wp_register_script('beopen-nicescroll', get_template_directory_uri() . '/js/jquery.nicescroll.min.js', array(), false, false);
        wp_enqueue_script('beopen-nicescroll');

        wp_register_script('waitForImages', get_template_directory_uri() . '/js/jquery.waitforimages.min.js', array(), false, true);
        wp_enqueue_script('waitForImages');

        wp_register_script('beopen-sticky', get_template_directory_uri() . '/js/jquery.sticky.js', array(), false, true);
        wp_enqueue_script('beopen-sticky');
        
        wp_register_script('roundabout', get_template_directory_uri() . '/js/jquery.roundabout.min.js', array(), false, true);
        wp_enqueue_script('roundabout');        

        // Enqueue to footer
        wp_register_script('reveal', get_template_directory_uri() . '/js/jquery.reveal.js', array('jquery'), false, true);
        wp_enqueue_script('reveal');

        wp_register_script('custom_forms', get_template_directory_uri() . '/js/jquery.customforms.js', array('jquery'), false, true);
        wp_enqueue_script('custom_forms');

        wp_register_script('placeholder', get_template_directory_uri() . '/js/jquery.placeholder.min.js', array('jquery'), false, true);
        wp_enqueue_script('placeholder');

        wp_register_script('tooltips', get_template_directory_uri() . '/js/jquery.tooltips.js', array('jquery'), false, true);
        wp_enqueue_script('tooltips');

        wp_register_script('easing', get_template_directory_uri() . '/js/jquery.easing.1.3.js', array('jquery'), false, true);
        wp_enqueue_script('easing');

        wp_register_script('pretty_photo', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array(), false, true);
        wp_enqueue_script('pretty_photo');

        wp_register_script('fitvids', get_template_directory_uri() . '/js/jquery.fitvids.js', array(), false, true);
        wp_enqueue_script('fitvids');

        wp_register_script('tipsy', get_template_directory_uri() . '/js/jquery.tipsy.js', array(), false, true);
        wp_enqueue_script('tipsy');

        wp_register_script('eventdrag', get_template_directory_uri() . '/js/jquery.event.drag.js', array(), false, true);
        wp_enqueue_script('eventdrag');

        wp_register_script('transit', get_template_directory_uri() . '/js/jquery.transit.min.js', array(), false, true);
        wp_enqueue_script('transit');

        wp_register_script('fred.debounce', get_template_directory_uri() . '/js/jquery.ba-throttle-debounce.min.js', array(), false, true);
        wp_enqueue_script('fred.debounce');

        wp_register_script('fred.mousewheel', get_template_directory_uri() . '/js/jquery.mousewheel.min.js', array(), false, true);
        wp_enqueue_script('fred.mousewheel');

        wp_register_script('fred.touchSwipe', get_template_directory_uri() . '/js/jquery.touchSwipe.min.js', array(), false, true);
        wp_enqueue_script('fred.touchSwipe');

        wp_register_script('fred', get_template_directory_uri() . '/js/jquery.carouFredSel-6.2.1.js', array(), false, true);
        wp_enqueue_script('fred');
        
        wp_register_script('hoverdir', get_template_directory_uri() . '/js/jquery.hoverdir.js', array(), false, true);
        wp_enqueue_script('hoverdir'); 
        
        wp_register_script('dropkick', get_template_directory_uri() . '/js/jquery.dropkick-1.0.3.js', array(), false, true);
        wp_enqueue_script('dropkick');           

        wp_register_script('isotope', get_template_directory_uri() . '/js/jquery.isotope.min.js', array(), false, true);
        wp_enqueue_script('isotope');

        wp_register_script('debouncedresize', get_template_directory_uri() . '/js/jquery.debouncedresize.js', array(), false, true);
        wp_enqueue_script('debouncedresize');

        wp_register_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array(), false, true);
        wp_enqueue_script('flexslider');

        wp_register_script('klass', get_template_directory_uri() . '/js/klass.min.js', array(), false, true);
        wp_enqueue_script('klass');

        wp_register_script('photoswipe', get_template_directory_uri() . '/js/jquery.photoswipe-3.0.5.min.js', array(), false, true);
        wp_enqueue_script('photoswipe');

        wp_register_script('jq.player', get_template_directory_uri() . '/js/jquery.jplayer.min.js', array('jquery'), false, true);
        wp_enqueue_script('jq.player');        
        
        wp_enqueue_script('wp-mediaelement');

        wp_register_script('mmenu', get_template_directory_uri() . '/js/jquery.mmenu.min.js', array(), false, true);
        wp_enqueue_script('mmenu');
        
        wp_register_script('beopen.grid', get_template_directory_uri() . '/js/jquery.beopen.grid.js', array(), false, true);
        wp_enqueue_script('beopen.grid');        

        if (is_page_template('template-contact.php')) {
            wp_register_script('googlemaps', 'https://maps.googleapis.com/maps/api/js?sensor=false');
            $beopen_data_array = beopen_get_map_array();
            wp_localize_script('googlemaps', 'beopen_map_data', $beopen_data_array);
            
            wp_enqueue_script('googlemaps');
            
            if (beopen_get_option('show_recaptcha') == 2) {
                
                wp_register_script('beopen-recaptcha', 'http://www.google.com/recaptcha/api/js/recaptcha_ajax.js');
                wp_enqueue_script('beopen-recaptcha');
                
                wp_register_script( 'beopen-recaptcha-init', get_template_directory_uri() . '/js/beopen.recaptcha.js', array(), false, true);
                $beopen_data_array = array('public_key' => beopen_get_option('recaptcha_public_key'));
                wp_localize_script( 'beopen-recaptcha-init', 'beopen_recaptcha_data', $beopen_data_array);
                wp_enqueue_script('beopen-recaptcha-init');

            }            
        }
        
        if ($is_IE) {
            wp_register_script('html5shiv', "http://html5shiv.googlecode.com/svn/trunk/html5.js", false, true);
            wp_enqueue_script('html5shiv');
        }        

        if (file_exists(get_stylesheet_directory() . '/js/app.js')) {
            wp_register_script('app', get_stylesheet_directory_uri() . '/js/app.js', array('jquery'), false, true);
        } else {
            wp_register_script('app', get_template_directory_uri() . '/js/app.js', array('jquery'), false, true);
        }
        wp_enqueue_script('app');
    
        
        
        // Enable threaded comments
        if ((!is_admin()) && is_singular() && comments_open() && get_option('thread_comments'))
            wp_enqueue_script('comment-reply');
        
    }

    add_action('wp_enqueue_scripts', 'beopen_enqueue_scripts');
    
/**********************************
   JAVASCRIPT AND CSS FOR ADMIN
**********************************/    
    
    function beopen_admin_enqueue_css() {

        wp_register_style('jquery-ui', ADMIN_CSS . '/ui-lightness/jquery-ui-1.8.22.custom.css', false);
        wp_enqueue_style('jquery-ui');

        if ((isset($_GET['page'])) && ($_GET['page'] == 'beopen-visual-editor')) {
            wp_register_style('beopen-visual-editor', ADMIN_CSS . '/visual-editor.css?1', false);
            wp_enqueue_style('beopen-visual-editor');
        }

        wp_register_style('beopen-pages', ADMIN_CSS . '/pages.css', false);
        wp_enqueue_style('beopen-pages');

        wp_register_style('beopen-tipsy', ADMIN_CSS . '/tipsy.css', false);
        wp_enqueue_style('beopen-tipsy');

        wp_register_style('beopen-revolution-slider', THEME_CSS . '/revolution.slider.css', false);
        wp_enqueue_style('beopen-revolution-slider');

        wp_enqueue_style( 'farbtastic' );

        wp_enqueue_style('thickbox');
    }
    
    add_action('admin_enqueue_scripts', 'beopen_admin_enqueue_css');
    

    function beopen_admin_enqueue_scripts() {
        global $include_js;

        wp_register_script('jquery.overlaps', ADMIN_JS . '/jquery.overlaps.js', array('jquery'));


        wp_register_script('jquery.overlaps', ADMIN_JS . '/jquery.overlaps.js', array('jquery'));
        wp_enqueue_script('jquery.overlaps');

        wp_register_script('beopen-tipsy', THEME_JS . '/jquery.tipsy.js', array('jquery'));
        wp_enqueue_script('beopen-tipsy');

        wp_register_script('beopen-visual-editor', ADMIN_JS . '/visual-editor.js', array('jquery'), '1.1');
        wp_enqueue_script('beopen-visual-editor');

        wp_register_script('beopen-pages', ADMIN_JS . '/pages.js', array('jquery'));
        wp_enqueue_script('beopen-pages');

        wp_enqueue_script('jquery-ui');
        wp_enqueue_script('jquery-ui-tabs');
        wp_enqueue_script('jquery-ui-dialog');
        wp_enqueue_script('jquery-ui-sortable');
        wp_enqueue_script('jquery-ui-draggable');
        wp_enqueue_script('jquery-ui-droppable');
        wp_enqueue_script('jquery-ui-position');
        wp_enqueue_script('jquery-ui-button');
        wp_enqueue_script('jquery-ui-widget');
        wp_enqueue_script('jquery-ui-slider');
        wp_enqueue_script('farbtastic');


        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');

        wp_register_script('beopen-media-uploader-functions', ADMIN_JS . '/media.uploader.functions.js');

        wp_register_script('beopen-media-uploader-script', ADMIN_JS . '/media.uploader.js', array('jquery', 'media-upload', 'thickbox', 'beopen-media-uploader-functions'));
        wp_enqueue_script('beopen-media-uploader-script');    

    }

    
    add_action('admin_enqueue_scripts', 'beopen_admin_enqueue_scripts');    
    

/**********************************
   SIDEBARS
**********************************/    
     

    // create widget areas: sidebar, footer
    $sidebars = array('Sidebar');
    foreach ($sidebars as $sidebar) {
        register_sidebar(array('name' => $sidebar,
            'before_widget' => '<article id="%1$s" class="widget %2$s"><div class="sidebar-section">',
            'after_widget' => '</div></article>',
            'before_title' => '<h6><strong>',
            'after_title' => '</strong></h6>'
        ));
    }
    $sidebars = array('Footer');
    foreach ($sidebars as $sidebar) {
        register_sidebar(array('name' => $sidebar,
            'before_widget' => '<article id="%1$s" class="three columns widget %2$s"><div class="footer-section">',
            'after_widget' => '</div></article>',
            'before_title' => '<h6><strong>',
            'after_title' => '</strong></h6>'
        ));
    }

    if (function_exists('register_sidebars')) {
        for ($i = 1; $i <= 3; $i++) {
            register_sidebar(array(
                'name' => 'Widget Bar ' . $i,
                'id' => 'widget-bar-' . $i,
                'class' => 'beopen-widget-bar',
                'before_widget' => '<div class="three columns end %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h6><strong>',
                'after_title' => '</strong></h6>'
            ));
        }
    } 


/**********************************
    MENUS
**********************************/        
    
    // Customize output for menu
    class beopen_walker extends Walker_Nav_Menu {
    }

    // Add Foundation 'active' class for the current menu item
    function beopen_active_nav_class($classes, $item) {
        if ($item->current == 1) {
            $classes[] = 'active';
        }
        return $classes;
    }

    add_filter('nav_menu_css_class', 'beopen_active_nav_class', 10, 2);

    
    
/**********************************
    MISCELLANEOUS
**********************************/    
    

    /* Customized the output of caption, you can remove the filter to restore back to the WP default output. Courtesy of DevPress. http://devpress.com/blog/captions-in-wordpress/ */
    add_filter('img_caption_shortcode', 'cleaner_caption', 10, 3);

    function cleaner_caption($output, $attr, $content) {

        /* We're not worried abut captions in feeds, so just return the output here. */
        if (is_feed())
            return $output;

        /* Set up the default arguments. */
        $defaults = array(
            'id' => '',
            'align' => 'alignnone',
            'width' => '',
            'caption' => ''
        );

        /* Merge the defaults with user input. */
        $attr = shortcode_atts($defaults, $attr);

        /* If the width is less than 1 or there is no caption, return the content wrapped between the [caption]< tags. */
        if (1 > $attr['width'] || empty($attr['caption']))
            return $content;

        /* Set up the attributes for the caption <div>. */
        $attributes = ' class="figure ' . esc_attr($attr['align']) . '"';

        /* Open the caption <div>. */
        $output = '<figure' . $attributes . '>';

        /* Allow shortcodes for the content the caption was created for. */
        $output .= do_shortcode($content);

        /* Append the caption text. */
        $output .= '<figcaption>' . $attr['caption'] . '</figcaption>';

        /* Close the caption </div>. */
        $output .= '</figure>';

        /* Return the formatted, clean caption. */
        return $output;
    }

    // Clean the output of attributes of images in editor. Courtesy of SitePoint. http://www.sitepoint.com/wordpress-change-img-tag-html/
    
    function image_tag_class($class, $id, $align, $size) {
        $align = 'align' . esc_attr($align);
        return $align;
    }

    add_filter('get_image_tag_class', 'image_tag_class', 0, 4);

    function image_tag($html, $id, $alt, $title) {
        return preg_replace(array(
            '/\s+width="\d+"/i',
            '/\s+height="\d+"/i',
            '/alt=""/i'
                ), array(
            '',
            '',
            '',
            'alt="' . $title . '"'
                ), $html);
    }

    add_filter('get_image_tag', 'image_tag', 0, 4);

    if (!is_admin()) {
        add_filter('widget_text', 'do_shortcode', 11);
    }


    //
    // Pagination
    function beopen_pagination() {
        global $wp_query;

        $big = 999999999; // This needs to be an unlikely integer
        // For more options and info view the docs for paginate_links()
        // http://codex.wordpress.org/Function_Reference/paginate_links
        $paginate_links = paginate_links(array(
            'base' => str_replace($big, '%#%', get_pagenum_link($big)),
            'current' => max(1, get_query_var('paged')),
            'total' => $wp_query->max_num_pages,
            'mid_size' => 2,
            'prev_next' => True,
            'prev_text' => __('&lsaquo;', 'beopen'),
            'next_text' => __('&rsaquo;', 'beopen'),
            'type' => 'list'
        ));

        // Display the pagination if more than one page is found
        if ($paginate_links) {
            echo '<div class="beopen-pagination">';
            echo '<div class="row">';
            echo '<div class="twelve columns">';
            echo $paginate_links;
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
    }

    if (beopen_get_option('excerpt_length') > 0) {

        function beopen_custom_excerpt_length($length) {
            return beopen_get_option('excerpt_length');
        }

        add_filter('excerpt_length', 'beopen_custom_excerpt_length', 999);
    }

    function beopen_new_excerpt_more($more) {
        global $post;

        return '...<div class="beopen-clear-both;"><a class="button readmore" href="' . get_permalink($post->ID) . '">' . __('Read more', 'beopen') . ' &rsaquo;</a></div>';
    }

    add_filter('excerpt_more', 'beopen_new_excerpt_more');

    function beopen_get_excerpt_by_id($post_id) {
        $the_post = get_post($post_id); //Gets post ID
        $the_excerpt = $the_post->post_content; //Gets post_content to be used as a basis for the excerpt
        $excerpt_length = 15; //Sets excerpt length by word count
        $the_excerpt = strip_tags(strip_shortcodes($the_excerpt)); //Strips tags and images
        $words = explode(' ', $the_excerpt, $excerpt_length + 1);

        if (count($words) > $excerpt_length) :
            array_pop($words);
            array_push($words, '&hellip;');
            $the_excerpt = implode(' ', $words);
        endif;

        $the_excerpt = '<p>' . $the_excerpt . '</p>';

        return $the_excerpt;
    }

    function beopen_get_post_categories($post_id) {
        $post_categories = wp_get_post_categories($post_id);
        if ($post_categories) {

            $_categories = array();

            foreach ($post_categories as $c) {
                $cat = get_category($c);
                $_categories[] = $cat->name;
            }

            return implode(', ', $_categories);
        }
    }

    function beopen_get_portfolio_tags($post_id) {

        $aterms = get_the_terms($post_id, 'portfolio_tag');
        $aclassterms = array();

        if ($aterms) {

            $_terms = array();

            foreach ($aterms as $term) {
                $_terms[] = $term->name;
            }

            return implode(', ', $_terms);
        }
    }

    

    // Customize the look of the comment form
    
    add_filter('comment_form_field_author', 'beopen_comment_form_field_author_responsive');
    add_filter('comment_form_field_email', 'beopen_comment_form_field_email_responsive');
    add_filter('comment_form_field_url', 'beopen_comment_form_field_url_responsive');

    add_filter('comment_form_before_fields', 'beopen_comment_form_before_fields');
    add_filter('comment_form_after_fields', 'beopen_comment_form_after_fields');

    add_filter('comment_form_default_fields', 'beopen_comment_form_default_fields');

    function beopen_comment_form_default_fields($fields) {

        $commenter = wp_get_current_commenter();
        $user = wp_get_current_user();
        $user_identity = $user->exists() ? $user->display_name : '';

        $req = get_option('require_name_email');
        $aria_req = ( $req ? " aria-required='true'" : '' );
        $fields = array(
            'author' => '<p class="comment-form-author">' .
            '<input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' placeholder="' . __('Name', 'beopen') . ( $req ? ' *' : '' ) . '" /></p>',
            'email' => '<p class="comment-form-email">' .
            '<input id="email" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' placeholder="' . __('Email', 'beopen') . ( $req ? ' *' : '' ) . '" /></p>',
            'url' => '<p class="comment-form-url">' .
            '<input id="url" name="url" type="text" value="' . esc_attr($commenter['comment_author_url']) . '" size="30" placeholder="' . __('Website', 'beopen') . ( $req ? ' *' : '' ) . '" /></p>',
        );

        return $fields;
    }

    function beopen_comment_form_field_author_responsive($s) {
        return '<div class="row"><div class="four columns"><div class="beopen-wrap author-icon">' . $s . '</div></div>';
    }

    function beopen_comment_form_field_email_responsive($s) {
        return '<div class="four columns"><div class="beopen-wrap email-icon">' . $s . '</div></div>';
    }

    function beopen_comment_form_field_url_responsive($s) {
        return '<div class="four columns"><div class="beopen-wrap url-icon">' . $s . '</div></div></div>';
    }

    function beopen_comment_form_field_responsive($s) {
        return '<div class="row"><div class="four columns">' . $s . '</div></div>';
    }

    function beopen_comment_form_before_fields() {
    }

    function beopen_comment_form_after_fields() {
    }

        
    
    // Add rel attribute to links for prettyPhoto gallery
    
    function beopen_prettyPhoto_gallery($content) {
        $content = preg_replace("/<a/", "<a rel=\"prettyPhoto[slides]\"", $content, 1);
        return $content;
    }
    
    add_filter('wp_get_attachment_link', 'beopen_prettyPhoto_gallery');
    

    
    // Add specific classes to BODY tag
    
    function beopen_body_class($classes) {

        if (is_page_template('template-custom-template.php')) {
            if (get_post_meta(get_the_ID(), 'beopen_show_pagetitlebar', true) != 'yes') {
                $classes[] = 'no-pagetitlebar';
            }
        }
        
        if (beopen_get_option('smooth_scroll') != 1) {
            $classes[] = 'beopen-smooth-scroll';
        }
        
        if (beopen_get_option('fixed_header') != 1) {
            $classes[] = 'beopen-fixed-header';
        }
        
        if (beopen_get_option('force_full_width_video') != 1) {
            $classes[] = 'beopen-force-full-width-video';
        }
		
		
		if ((!empty($_SESSION['beopen-layout']) && ($_SESSION['beopen-layout'] == 'boxed')) || (beopen_get_option('layout_type') == 'boxed')) {
            $classes[] = 'layout-type-boxed';
        }

        return $classes;
       
    }
    add_filter('body_class', 'beopen_body_class');    
	
	

?>