<!doctype html>
<!--[if lt IE 7]> <html class="no-js ie6 oldie" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js ie7 oldie" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js ie8 oldie" <?php language_attributes(); ?>> <![endif]-->
<!-- Consider adding an manifest.appcache: h5bp.com/d/Offline -->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
    <meta charset="<?php bloginfo('charset'); ?>">

    <title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>

    <!-- Mobile viewport optimized: j.mp/bplateviewport -->
    <meta name="viewport" content="width=device-width" />


    <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> Feed" href="<?php echo home_url(); ?>/feed/">

    <?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

    <!-- Start the main container -->
    <div id="container" class="container" role="document">

        <?php 
            
        global $beopen_post;

        if ((!isset($beopen_post)) || (!get_post_meta($beopen_post->ID, 'beopen_show_header', true))) {
        ?>
        <div id="header" class="header-zone">

            <div id="header-fixed">
            <?php
                if (beopen_get_option('show_header_action') == 2) {
            ?>
            <div class="header-extra beopen-limited-width" >
                <div class="row">

                    <div class="twelve columns">
						<div class="header-columns">
						<?php
						if (beopen_get_option('show_header_telephone') == 2) {
							echo '<div class="beopen-mini-column">';
                            beopen_show_telephone();
                            echo '</div>';
						}
						
						if (beopen_get_option('show_header_email') == 2) {
							echo '<div class="beopen-mini-column">';
                            beopen_show_email();
                            echo '</div>';
						}
						
                        if (beopen_get_option('show_header_action_social_icons') == 2) {
                            echo '<div class="beopen-mini-column">';
                            beopen_show_social_icons();
                            echo '</div>';
                        }
						?>
						</div>
						
                        <div class="header-action"><?php echo do_shortcode(beopen_get_option('header_action_text')); ?></div>	
						
                    </div>
                </div>
            </div>
            <?php
                }
            ?>                      

            <!-- Row for blog navigation -->
			<div class="beopen-limited-width">
            <div class="row">
                <header class="three columns" role="banner">
					<a href="#beopen-responsive" id="responsive-trigger" class="beopen-icon-menu"></a>					
					
                    <div id="inner-header">

                        <div id="header-logo-stuff">
                            <div id="logo" class="h1">
                                <a href="<?php echo home_url(); ?>" rel="nofollow"><?php
									if ((beopen_get_option('site_logo')) || (beopen_get_option('site_logo_retina'))) {
                                        beopen_display_logo_image();
                                    } else {
                                        bloginfo('name');
                                        if (beopen_get_option('show_logo_decoration') == 2) {
                                            echo '<span></span>';
                                        }
                                    }
                                ?></a>
                            </div>

							<?php
							if ((beopen_get_option('slogan')) || (get_bloginfo('name')))  {
							?><span class="slogan"><?php
                                if (beopen_get_option('slogan')) {
                                    beopen_display_slogan();
                                } else {
                                    bloginfo('description');
                                }
							?></span><?php 
							}
							?>
                        </div>
                        <div style="clear:both;"></div>
                    </div>
                </header>	


                <nav id="standard" class="nine columns" role="navigation" data-goto="<?php _e('Go to...', 'beopen'); ?>">
					<div id="beopen-quick-search"><?php echo fontello('search'); ?></div>
                    <?php
                    if ( has_nav_menu( 'primary_navigation') ) {
                        wp_nav_menu(array(
                            'theme_location' => 'primary_navigation',
                            'container' => false,
                            'menu_class' => '',
                            'echo' => true,
                            'before' => '',
                            'after' => '',
                            'link_before' => '',
                            'link_after' => '<span></span>',
                            'depth' => 0,
                            'items_wrap' => '<ul class="sf-menu" id="beopen-nav-bar">%3$s</ul>',
                            'walker' => new beopen_walker())                                
                        );
                    }
                    ?>
                </nav>
				
			</div>

            </div>

			<div id="beopen-quick-search-container">
				<div class="row">
					<div class="twelve columns">
						<form role="search" method="get" id="searchform" action="<?php echo home_url('/'); ?>">
							<input id="beopen-quick-search-box" name="s" type="text" placeholder="<?php _e('Type here to search...', 'beopen'); ?>" />
						</form>
					</div>
				</div>
			</div>
			
            </div>

        </div>
        <?php
           }
        ?>

        <!-- Row for main content area -->
        <div id="main" <?php if (is_home()) { echo 'class="homepage"'; } ?>>
        <?php

        if ((is_page_template('template-contact.php'))) {
        } 
        else
        if (is_page_template('template-custom-template.php')) {
            beopen_show_pagetitlebar();  
        }                    
        else
        if (is_page_template('template-homepage.php')) {

        } 
        else 
        {
            beopen_show_pagetitlebar();                    
        }


        beopen_include_visualeditor_layout('header');

        ?>