<?php
/*
  Template Name: Contact
 */
?>

<?php get_header(); ?>



<div class="wider_blog">
    <div class="_blog">

        <div class="topbar"><div class="row">                
                <?php
                echo beopen_main_title();
                if (beopen_get_option('show_breadcrumbs') == '2') {
                    echo beopen_breadcrumb();
                }
                ?>                        
        </div></div>

        <?php
        if (beopen_get_option('show_map') != 1) {
        ?>
            <div id="map_canvas_shadow"></div>
            <div id="map_canvas"></div>
        <?php
        }
        ?>	        

        <div class="row">

            <!-- Row for main content area -->
            <div id="content" class="eight columns rightfade" role="main">

                <div class="post-box">
                    <article class="contact">
                        <?php while (have_posts()) : the_post(); ?> 

                            <?php the_content(); ?>
                        <?php endwhile; ?>

                        <?php if (beopen_get_option('show_contact_form') == 2) { ?>				
                            <?php echo beopen_get_option('contact_form_text'); ?>					
                            <form class="beopen-contact-form" action="<?php echo get_permalink(); ?>" method="post">
                                <?php
                                require_once(THEME_LIBRARY . '/recaptchalib.php');

                                $error_contact_name = '';
                                $error_contact_email = '';
                                $error_contact_phone = '';
                                $error_contact_company = '';
                                $error_contact_message = '';

                                $contact_name = '';
                                $contact_email = '';
                                $contact_company = '';
                                $contact_phone = '';
                                $contact_message = '';

                                $publickey = beopen_get_option('recaptcha_public_key');
                                $privatekey = beopen_get_option('recaptcha_private_key');

                                if (isset($_POST['beopen_form'])) {

                                    foreach ($_POST as $key => $val) {
                                        $GLOBALS[$key] = wp_filter_kses($val);
                                    }


                                    $send = 0;

                                    if (beopen_get_option('show_recaptcha') == 2) {

                                        $recaptcha_challenge_field = '';
                                        if (isset($_POST["recaptcha_challenge_field"])) {
                                            $recaptcha_challenge_field = $_POST["recaptcha_challenge_field"];
                                        }

                                        $recaptcha_response_field = '';
                                        if (isset($_POST["recaptcha_response_field"])) {
                                            $recaptcha_response_field = $_POST["recaptcha_response_field"];
                                        }

                                        $resp = recaptcha_check_answer($privatekey, $_SERVER["REMOTE_ADDR"], $recaptcha_challenge_field, $recaptcha_response_field);

                                        if (!$resp->is_valid) {
                                            // What happens when the CAPTCHA was entered incorrectly
                                            echo '<div class="alert-box alert">';
                                            echo (__("The reCAPTCHA wasn't entered correctly. Go back and try it again.", 'beopen') .
                                            "(" . __('reCAPTCHA said:', 'beopen') . " " . $resp->error . ")");
                                            echo '</div>';
                                        } else {
                                            // Your code here to handle a successful verification
                                            $send = 1;
                                        }
                                    } else {
                                        $send = 1;
                                    }




                                    if (!(isset($_POST['contact_name']) && ($_POST['contact_name']) != '')) {
                                        $error_contact_name = 'error';
                                        $send = 2;
                                    }

                                    if (!(isset($_POST['contact_message']) && ($_POST['contact_message']) != '')) {
                                        $error_contact_message = 'error';
                                        $send = 2;
                                    }

                                    if ($send == 2) {
                                        echo '<div class="alert-box alert">';
                                        _e('You forgot to complete some fields !', 'beopen');
                                        echo '</div>';
                                    } else
                                    if ($send == 1) {
                                        $mail_content = __('Name:', 'beopen') . PHP_EOL . $_POST['contact_name'] . PHP_EOL . PHP_EOL .
                                                __('E-mail:', 'beopen') . PHP_EOL . $_POST['contact_email'] . PHP_EOL . PHP_EOL .
                                                __('Company:', 'beopen') . PHP_EOL . $_POST['contact_company'] . PHP_EOL . PHP_EOL .
                                                __('Phone:', 'beopen') . PHP_EOL . $_POST['contact_phone'] . PHP_EOL . PHP_EOL .
                                                __('Message:', 'beopen') . PHP_EOL . $_POST['contact_message'] . PHP_EOL;

                                        if ($_POST['contact_email'] == '') {
                                            $mail_headers = 'From: ' . beopen_get_option('contact_email_from') . PHP_EOL .
                                                    'Reply-To: ' . beopen_get_option('contact_email_from');
                                        } else {
                                            $mail_headers = 'From: ' . $_POST['contact_email'] . PHP_EOL .
                                                    'Reply-To: ' . $_POST['contact_email'];
                                        }


                                        if (mail(beopen_get_option('contact_email_to'), beopen_get_option('contact_email_subject'), $mail_content, $mail_headers)) {

                                            echo '<div class="alert-box success">';
                                            _e('Message sent !', 'beopen');
                                            echo '</div>';
                                        } else {
                                            echo '<div class="alert-box alert">';
                                            _e('Something went wrong !', 'beopen');
                                            echo '</div>';
                                        }
                                    }
                                }
                                ?>
                                <div class="row">					
                                    <div class="six columns">					
                                        <div class="beopen-wrap author-icon <?php echo $error_contact_name; ?>">
                                            <input type="text" name="contact_name" value="<?php echo $contact_name; ?>" placeholder="<?php _e('Your name', 'beopen'); ?>" />
                                        </div>
                                    </div>

                                    <div class="six columns">
                                        <div class="beopen-wrap email-icon <?php echo $error_contact_email; ?>">
                                            <input type="text" name="contact_email" value="<?php echo $contact_email; ?>" placeholder="<?php _e('Your e-mail', 'beopen'); ?>" />
                                        </div>
                                    </div>
                                </div>

                                <div class="row">					
                                    <div class="six columns">					
                                        <div class="beopen-wrap company-icon <?php echo $error_contact_company; ?>">
                                            <input type="text" name="contact_company" value="<?php echo $contact_company; ?>" placeholder="<?php _e('Your company', 'beopen'); ?>" />
                                        </div>
                                    </div>

                                    <div class="six columns">
                                        <div class="beopen-wrap phone-icon <?php echo $error_contact_phone; ?>">
                                            <input type="text" name="contact_phone" value="<?php echo $contact_phone; ?>" placeholder="<?php _e('Your phone', 'beopen'); ?>" />
                                        </div>
                                    </div>
                                </div>					


                                <textarea name="contact_message" placeholder="<?php _e('Your message', 'beopen'); ?>" <?php if ($error_contact_message) { echo 'class="' . $error_contact_message . '"'; } ?>><?php echo $contact_message; ?></textarea>

                                <div id="recaptcha_div"></div>
                                <input type="hidden" name="beopen_form" value="1" />
                                <button class="button send-message" type="submit"><span class="send-message"></span><?php _e('Send Message', 'beopen'); ?></button>


                            </form>
<?php } ?>
                    </article>
                </div> 			

            </div><!-- End Content row -->

            <div class="four columns">
                <div class="contact-sidebar">
                    <?php echo wpautop(beopen_get_option('map_address')); ?>
                </div>
            </div>
            
            
        </div>
    </div>            
</div>            
<?php get_footer(); ?>

