var browserify = require('browserify');
var buffer     = require('vinyl-buffer');
var compass    = require('gulp-compass');
var concat     = require('gulp-concat');
var es         = require('event-stream');
var gulp       = require('gulp');
var cleanCSS   = require('gulp-clean-css');
var source     = require('vinyl-source-stream');
var uglify     = require('gulp-uglify');
var gutil      = require('gulp-util');

var onError = function(err) {
  gutil.beep();
  gutil.log(gutil.colors.white.bgRed.bold(err.toString()));
  this.emit('end');
}

gulp.task('watch', function() {
  gulp.watch('./sass/**/*.scss', ['compass']); 
  gulp.watch('./js/script.js', ['browserify']);
})

gulp.task('compass', function() {
  gulp.src('./sass/*.scss')
    .on('error', onError)
    .pipe(compass({
      project: __dirname,
      style: 'compressed',
      environment: 'development',
      css: './',
      image: '/img'
    }))
    .pipe(gulp.dest('./'));
});

gulp.task('vendor-css', function() {  
  return gulp.src([
    './node_modules/bootstrap/dist/css/bootstrap.css', 
    './node_modules/awesome-bootstrap-checkbox/awesome-bootstrap-checkbox.css',
    './css/font-awesome/font-awesome.css'])
    .pipe(concat('vendors.min.css'))
    .pipe(cleanCSS({compatibility: 'ie8'}))
    .pipe(gulp.dest('./css'))
  }); 

gulp.task('browserify', function(){  
  return browserify({
    entries: ['./js/script.js']
  })
  .bundle()
  .on('error', onError)
  //Pass desired output filename to vinyl-source-stream
  .pipe(source('script.min.js'))       
  // .pipe(buffer())
  // .pipe(uglify()) 
  // Start piping stream to tasks
  .pipe(gulp.dest('./js/min'));
});

gulp.task('default', ['watch', 'vendor-css', 'browserify'], function(){
 // do nothing else
});