<?php	
add_action( 'after_setup_theme', 'inbound_remove_edit_post_link', 15 ); 
add_action( 'genesis_before_header', 'inbound_remove_title_on_homepage', 16);
add_action( 'after_setup_theme', 'inbound_remove_entry_footer', 17 );

function inbound_remove_edit_post_link() {
	add_filter( 'edit_post_link', '__return_false' );
}

function inbound_remove_title_on_homepage() {	
    if ( is_front_page() ) {
        remove_action( 'genesis_entry_header', 'genesis_do_post_title' );
    }
}

function inbound_remove_entry_footer() {
	remove_action( 'genesis_entry_footer', 'genesis_entry_footer_markup_open', 5 );
	remove_action( 'genesis_entry_footer', 'genesis_post_meta' );
	remove_action( 'genesis_entry_footer', 'genesis_entry_footer_markup_close', 15 );
}

function inbound_do_archive_title() {
	printf('<h1 class="entry-title">%s</h1>', get_the_title( get_option( 'page_for_posts' ) ));
}

function do_blog_title() {
	$post_type = get_post_type(get_the_ID());
	switch($post_type) {
		case "post" : 
		default: get_the_title( get_option('page_for_posts', true) );break;
	}
    if (is_category()) {
        $title .= ': ' . single_cat_title( '', false );
    }
    if (is_author()) {
        $title .= ' ' . __('by', 'inbound'). ' ' . get_the_author();
    }

    //* Wrap in H1 on singular pages
    $wrap = 'h1';

    //* Build the output
    $output = genesis_markup( array(
        'html5'   => "<{$wrap} %s>",
        'xhtml'   => sprintf( '<%s class="page-title">%s</%s>', $wrap, $title, $wrap ),
        'context' => 'page-title',
        'echo'    => false,
    ) );

    $output .= genesis_html5() ? "{$title}</{$wrap}>" : '';

    echo apply_filters( 'genesis_post_title_output', "$output \n" );
}