<?php
add_action( 'after_setup_theme', 'inbound_enable_html5', 15 );
add_action( 'after_setup_theme', 'inbound_setup_bootstrap_markup', 16 );
add_action( 'after_setup_theme', 'inbound_remove_unused_layout_options', 17 );
add_filter( 'inbound-classes-to-add', 'inbound_modify_classes_based_on_template', 10, 3 );

// move sidebar before content
// remove_action( 'genesis_after_content', 'genesis_get_sidebar' );
// add_action( 'genesis_before_content', 'genesis_get_sidebar' );


function inbound_enable_html5() {
    add_theme_support('html5');
    add_theme_support('genesis-structural-wraps', array()); 
}

function inbound_setup_bootstrap_markup() {
    // add bootstrap classes
    add_filter( 'genesis_attr_site-header',         'inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_site-inner',          'inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_content-sidebar-wrap','inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_content',             'inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_sidebar-primary',     'inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_archive-pagination',  'inbound_add_markup_class', 10, 2 );
    add_filter( 'genesis_attr_site-footer',         'inbound_add_markup_class', 10, 2 );
}

function inbound_add_markup_class( $attr, $context ) {
    // default classes to add
    $classes_to_add = apply_filters ('inbound-classes-to-add',
        array(
            'site-header'           => '',
            'site-inner'            => 'container',
            'site-footer'           => '',
            'content-sidebar-wrap'  => 'row',
            'content'               => 'col-md-8',
            'sidebar-primary'       => 'col-md-4',
            'archive-pagination'    => 'clearfix',
        ),
        $context,
        $attr
    );

    // populate $classes_array based on $classes_to_add
    $value = isset( $classes_to_add[ $context ] ) ? $classes_to_add[ $context ] : array();

    if ( is_array( $value ) ) {
        $classes_array = $value;
    } else {
        $classes_array = explode( ' ', (string) $value );
    }

    // apply any filters to modify the class
    $classes_array = apply_filters( 'inbound-add-class', $classes_array, $context, $attr );
    $classes_array = array_map( 'sanitize_html_class', $classes_array );

    // append the class(es) string
    $attr['class'] .= ' ' . implode( ' ', $classes_array );
    return $attr;
}

function inbound_remove_unused_layout_options() {
    genesis_unregister_layout( 'content-sidebar-sidebar' );
    genesis_unregister_layout( 'sidebar-sidebar-content' );
    genesis_unregister_layout( 'sidebar-content-sidebar' );
}

function inbound_layout_options_modify_classes_to_add( $classes_to_add ) {
    $layout = genesis_site_layout();

    // content-sidebar      = default
    // full-width-content   = supported
    if ( 'full-width-content' === $layout ) {
        $classes_to_add['content'] = 'col-md-12';
    }

    // sidebar-content      = not yet supported
    // same markup as content-sidebar with css modifications rather than markup
    return $classes_to_add;
};

function inbound_modify_classes_based_on_template( $classes_to_add, $context, $attr ) {
    $classes_to_add = inbound_layout_options_modify_classes_to_add( $classes_to_add );
    return $classes_to_add;
}