<?php

add_filter( 'genesis_search_form', 'inbound_search_form', 10, 4);

function inbound_search_form( $form, $search_text, $button_text, $label ) {
    $value_or_placeholder = ( get_search_query() == '' ) ? 'placeholder' : 'value';
    $form = sprintf( '<form method="get" class="search-form" action="%s" role="search">%s<input type="search" class="search-query" name="s" %s="%s" /><button type="submit"><i class="fa fa-3x fa-search"></i></button></form>', home_url( '/' ), esc_html( $label ), $value_or_placeholder, esc_attr( $search_text ), esc_attr( $button_text ) );
    return $form;
}

add_action( 'wp_footer', 'search_overlay' );
function search_overlay() { ?>
<div class="overlay-search">
	<button type="button" class="overlay-close">Close</button>
		<?php echo genesis_search_form( '', '', '' );	?>
	</div>
<?php }
