<?php
	
global $fontello;

$fontello = array(
    '' => '',
    'plus' => '59427',
    'minus' => '59430',
    'info' => '59435',
    'left-thin' => '59545',
    'up-thin' => '59547',
    'right-thin' => '59546',
    'down-thin' => '59544',
    'level-up' => '59552',
    'level-down' => '59551',
    'switch' => '59555',
    'infinity' => '59599',
    'plus-squared' => '59429',
    'minus-squared' => '59432',
    'home' => '59438',
    'keyboard' => '59463',
    'erase' => '59600',
    'pause' => '59558',
    'fast-forward' => '59562',
    'fast-backward' => '59563',
    'to-end' => '59560',
    'to-start' => '59561',
    'hourglass' => '59504',
    'stop' => '59557',
    'up-dir' => '59539',
    'play' => '59556',
    'right-dir' => '59538',
    'down-dir' => '59536',
    'left-dir' => '59537',
    'adjust' => '59508',
    'cloud' => '59583',
    'star' => '59424',
    'star-empty' => '59416',
    'cup' => '59475',
    'menu' => '59395',
    'moon' => '59586',
    'heart-empty' => '59423',
    'heart' => '59422',
    'note' => '59392',
    'note-beamed' => '59417',
    'layout' => '59396',
    'flag' => '59447',
    'tools' => '59491',
    'cog' => '59490',
    'attention' => '59467',
    'flash' => '59585',
    'record' => '59559',
    'cloud-thunder' => '59584',
    'tape' => '59605',
    'flight' => '59587',
    'mail' => '59421',
    'pencil' => '59459',
    'feather' => '59460',
    'check' => '59394',
    'cancel' => '59393',
    'cancel-circled' => '59425',
    'cancel-squared' => '59426',
    'help' => '59433',
    'quote' => '59456',
    'plus-circled' => '59428',
    'minus-circled' => '59431',
    'right' => '59534',
    'direction' => '59473',
    'forward' => '59455',
    'ccw' => '59548',
    'cw' => '59549',
    'left' => '59533',
    'up' => '59535',
    'down' => '59532',
    'list-add' => '59571',
    'list' => '59570',
    'left-bold' => '59541',
    'right-bold' => '59542',
    'up-bold' => '59543',
    'down-bold' => '59540',
    'user-add' => '59400',
    'help-circled' => '59434',
    'info-circled' => '59436',
    'eye' => '59443',
    'tag' => '59444',
    'upload-cloud' => '59452',
    'reply' => '59453',
    'reply-all' => '59454',
    'code' => '59457',
    'export' => '59458',
    'print' => '59461',
    'retweet' => '59462',
    'comment' => '59464',
    'chat' => '59465',
    'vcard' => '59469',
    'address' => '59470',
    'location' => '59471',
    'map' => '59472',
    'compass' => '59474',
    'trash' => '59476',
    'doc' => '59477',
    'doc-text-inv' => '59481',
    'docs' => '59478',
    'doc-landscape' => '59479',
    'archive' => '59486',
    'rss' => '59488',
    'share' => '59492',
    'basket' => '59494',
    'shareable' => '59493',
    'login' => '59497',
    'logout' => '59498',
    'volume' => '59502',
    'resize-full' => '59510',
    'resize-small' => '59511',
    'popup' => '59512',
    'publish' => '59513',
    'window' => '59514',
    'arrow-combo' => '59515',
    'chart-pie' => '59601',
    'language' => '59607',
    'air' => '59611',
    'database' => '59616',
    'drive' => '59617',
    'bucket' => '59618',
    'thermometer' => '59619',
    'down-circled' => '59516',
    'left-circled' => '59517',
    'right-circled' => '59518',
    'up-circled' => '59519',
    'down-open' => '59520',
    'left-open' => '59521',
    'right-open' => '59522',
    'up-open' => '59523',
    'down-open-mini' => '59524',
    'left-open-mini' => '59525',
    'right-open-mini' => '59526',
    'up-open-mini' => '59527',
    'down-open-big' => '59528',
    'left-open-big' => '59529',
    'right-open-big' => '59530',
    'up-open-big' => '59531',
    'progress-0' => '59564',
    'progress-1' => '59565',
    'progress-2' => '59566',
    'progress-3' => '59567',
    'back-in-time' => '59575',
    'network' => '59578',
    'inbox' => '59580',
    'install' => '59581',
    'lifebuoy' => '59590',
    'mouse' => '59591',
    'dot' => '59594',
    'dot-2' => '59595',
    'dot-3' => '59596',
    'suitcase' => '59593',
    'flow-cascade' => '59621',
    'flow-branch' => '59622',
    'flow-tree' => '59623',
    'flow-line' => '59624',
    'flow-parallel' => '59625',
    'brush' => '59597',
    'paper-plane' => '59588',
    'magnet' => '59598',
    'gauge' => '59627',
    'traffic-cone' => '59628',
    'cc' => '59629',
    'cc-by' => '59630',
    'cc-nc' => '59631',
    'cc-nc-eu' => '59632',
    'cc-nc-jp' => '59633',
    'cc-sa' => '59634',
    'cc-nd' => '59635',
    'cc-pd' => '59636',
    'cc-zero' => '59637',
    'cc-share' => '59638',
    'cc-remix' => '59639',
    'github' => '59640',
    'github-circled' => '59641',
    'flickr' => '59642',
    'flickr-circled' => '59643',
    'vimeo' => '59644',
    'vimeo-circled' => '59645',
    'twitter' => '59646',
    'twitter-circled' => '59647',
    'facebook' => '59648',
    'facebook-circled' => '59649',
    'facebook-squared' => '59650',
    'gplus' => '59651',
    'gplus-circled' => '59652',
    'pinterest' => '59653',
    'pinterest-circled' => '59654',
    'tumblr' => '59655',
    'tumblr-circled' => '59656',
    'linkedin' => '59657',
    'linkedin-circled' => '59658',
    'dribbble' => '59659',
    'dribbble-circled' => '59660',
    'stumbleupon' => '59661',
    'stumbleupon-circled' => '59662',
    'lastfm' => '59663',
    'lastfm-circled' => '59674',
    'rdio' => '59664',
    'rdio-circled' => '59665',
    'spotify' => '59666',
    'spotify-circled' => '59667',
    'qq' => '59668',
    'instagram' => '59669',
    'dropbox' => '59670',
    'evernote' => '59671',
    'flattr' => '59675',
    'skype' => '59672',
    'skype-circled' => '59673',
    'renren' => '59413',
    'sina-weibo' => '59412',
    'paypal' => '59411',
    'picasa' => '59409',
    'soundcloud' => '59410',
    'mixi' => '59408',
    'behance' => '59407',
    'google-circles' => '59406',
    'vkontakte' => '59405',
    'smashing' => '59404',
    'db-shape' => '59401',
    'sweden' => '59402',
    'logo-db' => '59403',
    'picture' => '59398',
    'globe' => '59582',
    'leaf' => '59589',
    'graduation-cap' => '59606',
    'mic' => '59499',
    'palette' => '59569',
    'ticket' => '59608',
    'video' => '59399',
    'target' => '59568',
    'music' => '59418',
    'trophy' => '59573',
    'thumbs-up' => '59448',
    'thumbs-down' => '59449',
    'bag' => '59495',
    'user' => '59415',
    'users' => '59414',
    'lamp' => '59505',
    'alert' => '59468',
    'water' => '59609',
    'droplet' => '59610',
    'credit-card' => '59612',
    'monitor' => '59576',
    'briefcase' => '59592',
    'floppy' => '59613',
    'cd' => '59579',
    'folder' => '59485',
    'doc-text' => '59480',
    'calendar' => '59496',
    'chart-line' => '59602',
    'chart-bar' => '59603',
    'clipboard' => '59614',
    'attach' => '59440',
    'bookmarks' => '59446',
    'book' => '59484',
    'book-open' => '59483',
    'phone' => '59489',
    'megaphone' => '59615',
    'upload' => '59451',
    'download' => '59450',
    'box' => '59487',
    'newspaper' => '59482',
    'mobile' => '59577',
    'signal' => '59572',
    'camera' => '59397',
    'shuffle' => '59553',
    'loop' => '59554',
    'arrows-ccw' => '59550',
    'light-down' => '59506',
    'light-up' => '59507',
    'mute' => '59500',
    'sound' => '59501',
    'battery' => '59574',
    'search' => '59419',
    'key' => '59620',
    'lock' => '59441',
    'lock-open' => '59442',
    'bell' => '59466',
    'bookmark' => '59445',
    'link' => '59439',
    'back' => '59437',
    'flashlight' => '59420',
    'chart-area' => '59604',
    'clock' => '59503',
    'rocket' => '59626',
    'block' => '59509'
);

function beopen_get_attachment_id_from_src($image_src) {


    global $wpdb;
    $query = "SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_wp_attachment_metadata' AND meta_value LIKE '%$image_src%'";

    $post_id = $wpdb->get_var($query);
    return $post_id;
}

function beopen_getAttachedImageWithFrame($image_url, $image_frame) {

    $attachment_link = '';

    $frame = $image_frame;
    if ($frame != '') {
        $frame = 'featurebox-' . $frame;
    }

    if ($image_url) {

        $a = explode('uploads/', $image_url);

        $image = $a[1];


        $pos = strrpos($image, '-');
        $posx = strrpos($image, 'x');
        if (($pos > 0) && ($posx > $pos)) {
            $image = substr($image, 0, $pos - 1);
        }

        $attachment_id = beopen_get_attachment_id_from_src($image);

                
        if ($attachment_id > 0) {
            $attachment_link = wp_get_attachment_image($attachment_id, $frame);
        }
        else
        {
            $attachment_link = '<img src="'.$image_url.'" />';
        }
    }





    return '<div class="beopen-frame-' . $frame . '"><div class="beopen-frame-center-bottom">' . $attachment_link . '</div></div>';
}

function beopen_renderIcon($code, $size, $line_height, $color) {

    if ($code) {

        $iconcode = fontello($code);

        $astyle = array();
        if ($size) {
            $astyle[] = 'font-size: ' . $size;
        }

        if ($color) {
            $astyle[] = 'color: ' . $color;
        }

        if ($line_height) {
            $astyle[] = 'line_height: ' . $line_height;
        }



        $output = '<span class="entypo" ';
        if (count($astyle) > 0) {
            $output .= 'style="' . implode(';', $astyle) . '"';
        }

        $output .= '>' . $iconcode . '</span>';
        return $output;
    }
    return '';
}

function fontello($code) {
    global $fontello;

    return '&#' . $fontello[$code] . ';';
}

function beopen_slug($str) {
    $str = strtolower(trim($str));
    $str = preg_replace('/[^a-z0-9-]/', '_', $str);
    $str = preg_replace('/-+/', "_", $str);
    return $str;
}

function columnNumberToString($n) {
    if ($n == 1) {
        return 'one';
    } else
    if ($n == 2) {
        return 'two';
    } else
    if ($n == 3) {
        return 'three';
    } else
    if ($n == 4) {
        return 'four';
    } else
    if ($n == 5) {
        return 'five';
    } else
    if ($n == 6) {
        return 'six';
    } else
    if ($n == 7) {
        return 'seven';
    } else
    if ($n == 8) {
        return 'eight';
    } else
    if ($n == 9) {
        return 'nine';
    } else
    if ($n == 10) {
        return 'ten';
    } else
    if ($n == 11) {
        return 'eleven';
    } else
    if ($n == 12) {
        return 'twelve';
    }
}

/**
 * Trim a string to a given number of words
 *
 * @param $string
 *   the original string
 * @param $count
 *   the word count
 * @param $ellipsis
 *   TRUE to add "..."
 *   or use a string to define other character
 * @param $node
 *   provide the node and we'll set the $node->
 *
 * @return
 *   trimmed string with ellipsis added if it was truncated
 */

function beopen_word_trim($string, $count, $ellipsis = FALSE) {
    $words = explode(' ', $string);
    if (count($words) > $count) {
        array_splice($words, $count);
        $string = implode(' ', $words);

        if (is_string($ellipsis)) {
            $string .= $ellipsis;
        } elseif ($ellipsis) {
            $string .= '&hellip;';
        }
    }
    return $string;
}

function beopen_letter_trim($string, $count, $ellipsis = FALSE) {
    if (strlen($string) > $count) {
        $string = trim(substr($string, 0, $count - 1));

        if (is_string($ellipsis)) {
            $string .= $ellipsis;
        } elseif ($ellipsis) {
            $string .= '&hellip;';
        }
    }
    return $string;
}



// ----------------------

add_action('admin_menu', 'wpba_remove_menu_pages');

function wpba_remove_menu_pages() {
    remove_submenu_page(
            'options-general.php', 'wpba-settings'
    );
}



?>