<?php

function beopen_loadLayouts($deleteBefore = false) {
    $predefined_pages = get_option('beopen_visualeditor_pages', array());
	
	if ($deleteBefore) {
        update_option('beopen_visualeditor_pages', array());
    }
    
    if (count($predefined_pages) == 0)
	if (file_exists(THEME_ADMIN . '/predefined/layout-templates.json')) {
		$layout_templates = file_get_contents(THEME_ADMIN . '/predefined/layout-templates.json');
		
		$layouts = json_decode($layout_templates, true);
		
		update_option('beopen_visualeditor_pages', $layouts['pages']);
		
		foreach ($layouts['data'] as $slug => $page_data) {
			update_option('beopen_visualeditor_' . $slug, $page_data);		
		}
	}	
}

function beopen_theme_activation($oldname, $oldtheme = false) {
    beopen_loadLayouts();
}

add_action("after_switch_theme", "beopen_theme_activation", 10,  2);





?>