<?php

function beopen_get_option($fieldname, $default = null) {

    $option_value = get_option(FIELD_PREFIX . $fieldname);


    if ($option_value === false) {

        global $optionPages;
        foreach ($optionPages as $optionPage) {
            foreach ($optionPage['fields'] as $field) {
                if ($field['name'] == $fieldname) {
                    return $field['default'];
                }
            }
        }
        
        
    }

    
    if (is_string($option_value)) {
        return stripslashes($option_value);    
    }
       
    return $option_value;
    
}

function beopen_reorder($a) {
    asort($a);
    return $a;
}

// ALLOW UPLOAD OF JSON FILES TO WP ADMIN
add_filter('upload_mimes', 'beopen_custom_upload_mimes');

function beopen_custom_upload_mimes($existing_mimes = array()) {

    $existing_mimes['json'] = 'application/json';

    return $existing_mimes;
}

function beopen_process_form() {


    if (isset($_POST['beopen_export_settings_now'])) {

        //must check that the user has the required capability 
        if (!current_user_can('manage_options')) {
            wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
        }

        $all_options = wp_load_alloptions();
        $beopen_options = array();
        $prefix_length = strlen(FIELD_PREFIX);
        foreach ($all_options as $key => $value) {
            if (strpos($key, FIELD_PREFIX) !== false)
                if (strpos($key, 'webfonts') === false) {
                    $key = substr($key, $prefix_length);
                    $beopen_options[$key] = $value;
                }
        }

        header('Content-type: application/json');
        header('Content-Disposition: attachment; filename="' . FIELD_PREFIX . 'settings.json"');

        echo json_encode($beopen_options);
        exit;
    }



    if (isset($_POST['beopen_import_settings_now']))
        if (isset($_FILES['beopen_import_settings_file'])) {


            //must check that the user has the required capability 
            if (!current_user_can('manage_options')) {
                wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
            }

            if (!function_exists('wp_handle_upload'))
                require_once( ABSPATH . 'wp-admin/includes/file.php' );

            $uploadedfile = $_FILES['beopen_import_settings_file'];
            $upload_overrides = array('test_form' => false);
            $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
            if ($movefile) {

                $beopen_import_content = file_get_contents($movefile['file']);
                $beopen_import_array = json_decode($beopen_import_content);

                foreach ($beopen_import_array as $key => $value) {
                    update_option(FIELD_PREFIX . $key, $value);
                }
            } else {
                echo "Possible file upload attack!\n";
            }
        }


    $skin_selector = get_option(FIELD_PREFIX . 'skin_selector');

    $isBeopen = false;

    foreach ($_POST as $key => $value) {
        if (strpos($key, FIELD_PREFIX) !== false) {
            $isBeopen = true;
            update_option($key, $value);
        }
    }

    $predefined_pages = get_option('beopen_visualeditor_pages', array());

    $layouts = array(
        'pages' => $predefined_pages,
        'data' => array()
    );

    foreach ($predefined_pages as $predefined_slug_page => $predefined_title_page) {
        $layouts['data'][$predefined_slug_page] = get_option('beopen_visualeditor_' . $predefined_slug_page);
    }

    if (!file_exists(THEME_ADMIN . '/predefined/layout-templates.json')) {
        $fp = fopen(THEME_ADMIN . '/predefined/layout-templates.json', 'w');
        fwrite($fp, json_encode($layouts));
        fclose($fp);
    }


    global $optionPages;

    if (isset($_POST['reset-options'])) {
        //
        delete_option(FIELD_PREFIX . 'webfonts');

        foreach ($optionPages as $optionPage) {
            foreach ($optionPage['fields'] as $field) {
                if (isset($field['name'])) {
                    delete_option(FIELD_PREFIX . $field['name']);
                }
            }
        }
    }




    if (get_option(FIELD_PREFIX . 'skin_selector_reset') != $skin_selector) {

        foreach ($optionPages as $page_slug => $optionPage) {

            $fields = $optionPage['fields'];

            foreach ($fields as $field) {

                if (isset($field['skin']) && ($field['skin'])) {
                    delete_option(FIELD_PREFIX . $field['name']);
                }
            }
        }

        update_option(FIELD_PREFIX . 'skin_selector_reset', $skin_selector);
    }
}

function beopen_show_field($params, $wp_customize = null, $ajax_form = false) {
	
	
	
    $fieldLabel = '';
    if (isset($params['label'])) {
        $fieldLabel = $params['label'];
    }

    $fieldName = '';
    if (isset($params['name'])) {
        $fieldName = $params['name'];
    }

    $fieldValue = '';
    if (isset($params['value'])) {
        $fieldValue = $params['value'];
    }

    $fieldAlert = '';
    if (isset($params['alert'])) {
        $fieldAlert = $params['alert'];
    }

    $fieldType = '';
    if (isset($params['type'])) {
        $fieldType = $params['type'];
    }


    $fieldDefaultValue = '';
    if (isset($params['default'])) {
        $fieldDefaultValue = $params['default'];
    }

    $fieldDescription = '';
    if (isset($params['description'])) {
        $fieldDescription = $params['description'];
    }

    $prefix_if_customizer = '';
    if (!$wp_customize) {
        echo '<tr valign="top">';
        echo '<th scope="row"><label for="' . $fieldName . '">' . $fieldLabel . '</label>';

        if ($fieldDescription) {
            echo '<span class="tooltip" title="' . $fieldDescription . '"></span>';
        }

        echo '</th>';
        echo '<td>';
        $prefix_if_customizer = FIELD_PREFIX;
    }
	
	if ($ajax_form) {
		$prefix_if_customizer = '';	
	}


    $fieldValue = get_option($prefix_if_customizer . $fieldName, $fieldDefaultValue);
    if (!is_array($fieldValue)) {
        $fieldValue = stripslashes($fieldValue);
    }

	
	


    if (is_array($fieldType)) {
        $options = $fieldType;

        echo '<select name="' . $prefix_if_customizer . $fieldName . '" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '">';

        foreach ($options as $optionFieldValue => $optionFieldLabel) {
            echo '<option value="' . $optionFieldValue . '"';
            if ($fieldValue == $optionFieldValue) {
                echo ' selected="selected"';
            }
            echo '>' . $optionFieldLabel . '</option>';
        }
        echo '</select>';
    } else
    if ($fieldType == 'number_hundred') {

        echo '<input name="' . $prefix_if_customizer . $fieldName . '" type="text" id="' . $fieldName . '" value="' . $fieldValue . '" class="regular-text" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '" data-max="300" />';
        echo '<div id="' . $fieldName . '_slider" class="number beopen-form-slider" style="width: 300px;"></div>';
        
    } else
    if ($fieldType == 'number') {

        echo '<input name="' . $prefix_if_customizer . $fieldName . '" type="text" id="' . $fieldName . '" value="' . $fieldValue . '" class="regular-text" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '" data-max="500" />';
        echo '<div id="' . $fieldName . '_slider" class="number beopen-form-slider" style="width: 500px;"></div>';
        
    } else
    if ($fieldType == 'fileupload') {

        if ($fieldValue) {
            echo '<div class="beopen_admin_picture_frame"><div class="beopen_admin_picture"><img src="' . $fieldValue . '" /></div></div>';
        }

        echo '<input class="beopen_upload_input" name="' . $prefix_if_customizer . $fieldName . '" type="text" id="' . $fieldName . '" value="' . $fieldValue . '" class="regular-text" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '" />';
        echo '<input class="beopen_no_picture" type="button" value="" />';
    } else
    if ($fieldType == 'text') {
        echo '<input name="' . $prefix_if_customizer . $fieldName . '" type="text" id="' . $fieldName . '" value="' . htmlspecialchars($fieldValue) . '" class="regular-text" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '" />';
    } else
    if ($fieldType == 'textarea') {
        echo '<textarea name="' . $prefix_if_customizer . $fieldName . '" class="large-text">';
        echo $fieldValue;
        echo '</textarea>';
    } else
    if ($fieldType == 'largetextarea') {
        echo '<textarea name="' . $prefix_if_customizer . $fieldName . '" class="large-text" style="height: 300px;">';
        echo $fieldValue;
        echo '</textarea>';
    } else
    if ($fieldType == 'tinymce') {

        wp_editor($fieldValue, $prefix_if_customizer . $fieldName);
    } else
    if ($fieldType == 'onoff') {

        if (!$wp_customize) {
            
        }

        $options = array(1 => 'Off', 2 => 'On');

        echo '<select name="' . $prefix_if_customizer . $fieldName . '" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '">';

        foreach ($options as $key => $value) {
            echo '<option value="' . $key . '"';
            if ($fieldValue == $key) {
                echo ' selected="selected"';
            }
            echo '>' . $value . '</option>';
        }
        echo '</select>';
    } else
    if ($fieldType == 'color') {
       
        echo '<div id="' . $fieldName . '" class="colorSelector"><div style="background-color: #ff0000;"></div></div>';
    } else
    if ($fieldType == 'font') {

        $beopen_fonts = get_font_list();

        echo '<select name="' . $prefix_if_customizer . $fieldName . '_name" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '_name">';

        $fieldValue = get_option($prefix_if_customizer . $fieldName . '_name');
        if ($fieldValue) {
            $fieldValue = stripslashes($fieldValue);
        }

        echo '<option value="" ';
        if (!$fieldValue) {
            echo 'selected="selected"';
        }
        echo '>Default Font</option>';

        foreach ($beopen_fonts as $key => $value) {
            echo '<option value="' . $key . '"';

            if (!isset($value['standard'])) {
                echo ' style="background-color: #eee;"';
            }

            if ($fieldValue == $key) {
                echo ' selected="selected"';
            }

            echo '>' . $value['name'] . '</option>';
        }
        echo '</select>';

        $beopen_fonts_size = range('7', '100');

        echo '<select name="' . $prefix_if_customizer . $fieldName . '_size" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '_size">';

        $fieldValue = get_option($prefix_if_customizer . $fieldName . '_size');

        if ($fieldValue) {
            $fieldValue = stripslashes($fieldValue);
        }

        echo '<option value="" ';
        if (!$fieldValue) {
            echo 'selected="selected"';
        }
        echo '>Default Size</option>';

        foreach ($beopen_fonts_size as $value) {
            echo '<option value="' . $value . '"';
            if ($fieldValue == $value) {
                echo ' selected="selected"';
            }
            echo '>' . $value . 'px</option>';
        }
        echo '</select>';

        $beopen_fonts_style = array('normal' => 'Normal', 'bold' => 'Bold', 'italic' => 'Italic', 'italic bold' => 'Italic Bold');

        echo '<select name="' . $prefix_if_customizer . $fieldName . '_style" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '_style">';

        $fieldValue = get_option($prefix_if_customizer . $fieldName . '_style');
        if ($fieldValue) {
            $fieldValue = stripslashes($fieldValue);
        }

        echo '<option value="" ';
        if (!$fieldValue) {
            echo 'selected="selected"';
        }
        echo '>Default Style</option>';

        foreach ($beopen_fonts_style as $key => $value) {
            echo '<option value="' . $key . '"';
            if ($fieldValue == $key) {
                echo ' selected="selected"';
            }
            echo '>' . $value . '</option>';
        }
        echo '</select>';
    }
	else
	{
		global $$fieldType;
			
		$options = $$fieldType;

        echo '<select name="' . $prefix_if_customizer . $fieldName . '" data-customize-setting-link="' . $prefix_if_customizer . $fieldName . '">';

        foreach ($options as $optionFieldValue => $optionFieldLabel) {
            echo '<option value="' . $optionFieldValue . '"';
            if ($fieldValue == $optionFieldValue) {
                echo ' selected="selected"';
            }
            echo '>' . $optionFieldLabel . '</option>';
        }
        echo '</select>';
		
		
	}	

	if ($ajax_form) {
		echo '<p class="description">' . $fieldDescription . '</p>';
	}
	else
    if ($fieldAlert) {
        echo '<p class="description">' . $fieldAlert . '</p>';
    }

    if (!$wp_customize) {
        echo '</td>';
        echo '</tr>';
    }
}

function beopen_add_field($fieldName, $fieldLabel, $fieldType = 'text', $fieldDefaultValue = '', $fieldDescription = '') {

    beopen_show_field(array(
        'label' => $fieldLabel,
        'name' => $fieldName,
        'default' => $fieldDefaultValue,
        'type' => $fieldType,
        'description' => $fieldDescription
            ), false);
}

?>