<?php

	/* -------------------------------------- */
	/*    Clean up Shortcodes
	  /*-------------------------------------- */

// Actual processing of the shortcode happens here
	function beopen_run_shortcode($content) {

		global $shortcode_tags;

		// Backup current registered shortcodes and clear them all out
		$orig_shortcode_tags = $shortcode_tags;
		remove_all_shortcodes();

		add_shortcode('shortcode', 'escapeHTML');

		add_shortcode('slider', 'beopen_slider');

		add_shortcode('one_half', 'beopen_one_half');
		add_shortcode('two_third', 'beopen_two_third');
		add_shortcode('one_third', 'beopen_one_third');
		add_shortcode('one_fourth', 'beopen_one_fourth');

		add_shortcode('button', 'beopen_button');


		add_shortcode('tab', 'beopen_tab');
		add_shortcode('tabs', 'beopen_tabs');
		add_shortcode('accordion_toggle', 'beopen_accordion_toggle');
		add_shortcode('accordion', 'beopen_accordion');

		add_shortcode('toggle', 'beopen_toggle');
		add_shortcode('code_toggle', 'beopen_toggle');

		add_shortcode('message', 'beopen_message');

		add_shortcode('tooltip', 'beopen_tooltip');

		add_shortcode('highlight', 'beopen_highlight');
		add_shortcode('divider', 'beopen_divider');
		add_shortcode('listitem', 'beopen_listitem');
		add_shortcode('list', 'beopen_list');
		add_shortcode('dropcap', 'beopen_dropcap');
		add_shortcode('vid', 'vid_sc');
		add_shortcode('soundcloud', 'beopen_soundcloud');
		add_shortcode('pricing_table', 'beopen_pricing_table');
		add_shortcode('plan', 'beopen_plan');

		add_shortcode('latest_posts', 'beopen_latest_posts');


		// Do the shortcode (only the one above is registered)
		$content = do_shortcode($content);

		// Put the original shortcodes back
		$shortcode_tags = $orig_shortcode_tags;


		return $content;
	}

	add_filter('the_content', 'beopen_run_shortcode', 7);



	add_shortcode('slider', 'beopen_slider');

	add_shortcode('one_half', 'beopen_one_half');
	add_shortcode('two_third', 'beopen_two_third');
	add_shortcode('one_third', 'beopen_one_third');
	add_shortcode('one_fourth', 'beopen_one_fourth');

	add_shortcode('button', 'beopen_button');


	add_shortcode('tab', 'beopen_tab');
	add_shortcode('tabs', 'beopen_tabs');
	add_shortcode('accordion_toggle', 'beopen_accordion_toggle');
	add_shortcode('accordion', 'beopen_accordion');

	add_shortcode('toggle', 'beopen_toggle');
	add_shortcode('code_toggle', 'beopen_toggle');

	add_shortcode('message', 'beopen_message');

	add_shortcode('tooltip', 'beopen_tooltip');

	add_shortcode('highlight', 'beopen_highlight');
	add_shortcode('divider', 'beopen_divider');
	add_shortcode('listitem', 'beopen_listitem');
	add_shortcode('list', 'beopen_list');
	add_shortcode('dropcap', 'beopen_dropcap');
	add_shortcode('vid', 'vid_sc');
	add_shortcode('soundcloud', 'beopen_soundcloud');
	add_shortcode('pricing_table', 'beopen_pricing_table');
	add_shortcode('plan', 'beopen_plan');

	add_shortcode('latest_posts', 'beopen_latest_posts');
	add_shortcode('esc', 'escapeHTML');

	/* SLIDER */

	function beopen_slider($atts, $content = null) {
		extract(shortcode_atts(array(
						), $atts));

		$ahtml = array();

		$slidephotos = explode("\n", $content);
		foreach ($slidephotos as $photourl) {
			if (trim($photourl)) {
				$ahtml[] = '<img src="' . $photourl . '"></img>';
			}
		}


		return '<script type="text/javascript">jQuery(document).ready(function() { $(\'.slider\').orbit(); });</script>' .
				'<div class="slider">' . implode('', $ahtml) . '</div>';
	}

	/* COLUMNS */

	function beopen_one_half($atts, $content = null) {
		return '<div class="six columns"><p>' . do_shortcode($content) . '</p></div>';
	}

	function beopen_two_third($atts, $content = null) {
		return '<div class="eight columns"><p>' . do_shortcode($content) . '</p></div>';
	}

	function beopen_one_third($atts, $content = null) {
		return '<div class="four columns"><p>' . do_shortcode($content) . '</p></div>';
	}

	function beopen_one_fourth($atts, $content = null) {
		return '<div class="three columns"><p>' . do_shortcode($content) . '</p></div>';
	}

	/* BUTTONS */

	function beopen_button($atts, $content = null) {
		extract(shortcode_atts(array('target' => '_self', 'type' => '', 'align' => '', 'color' => '', 'size' => '', 'link' => '#'), $atts));


		$htmlstart = '';
		$htmlend = '';

		$aclass = array();

		if (in_array($size, array('tiny', 'small', 'medium', 'large', 'full_width'))) {
			$aclass[] = $size;
		}

		if (in_array($color, array('blue', 'green', 'red', 'grey', 'white'))) {
			$aclass[] = $color;
		}

		if (in_array($target, array('_blank', '_self'))) {
			$target = $target;
		}

		if (in_array($align, array('left', 'right'))) {
			$aclass[] = $align;
		}

		if (in_array($type, array('square', 'radius', 'wireframe'))) {
			$aclass[] = $type;
		}

		if (in_array($align, array('center'))) {
			$htmlstart = '<p class="text-center">';
			$htmlend = '</p>';
		}

		$aclass[] = 'shortcode';
		$class = implode(' ', $aclass);




		return $htmlstart . '<a class="' . $class . ' button" href="' . $link . '" target="' . $target . '">' . do_shortcode($content) . '</a>' . $htmlend;
	}

	/* TABS, ACCORDION, TOGGLE */

	function beopen_tab($atts, $content = null) {
		extract(shortcode_atts(array(
			'title' => '',
						), $atts));
		global $single_tab_array;
		$single_tab_array[] = array('title' => esc_attr($title), 'content' => trim(do_shortcode($content)));

		return $single_tab_array;
	}

	function beopen_tabs($atts, $content = null) {
		extract(shortcode_atts(array('type' => ''
						), $atts));

		global $single_tab_array;
		$single_tab_array = array(); // clear the array


		$tabs_nav = '<dl class="tabs ' . $type . '">';
		$tabs_content = '';
		$tabs_output = '';

		do_shortcode($content); // execute the '[tab]' shortcode first to get the title and content
		foreach ($single_tab_array as $tab => $tab_attr_array) {
			$random_id = rand(1000, 2000);
			$default = ( $tab == 0 ) ? ' class="active"' : '';
			$tabs_nav .= '<dd' . $default . '><a href="#tab' . $random_id . '">' . $tab_attr_array['title'] . '</a></dd>';
			$tabs_content .= '<li' . $default . ' id="tab' . $random_id . 'Tab">' . $tab_attr_array['content'] . '</li>';
		}
		$tabs_nav .= '</dl>';
		$tabs_output .= $tabs_nav . '<ul class="tabs-content">' . $tabs_content . '</ul>';

		return $tabs_output;
	}

	function beopen_accordion_toggle($atts, $content = null) {
		extract(shortcode_atts(array(
			'title' => '',
			'active' => false
						), $atts));

		$single_tab_array[] = array('title' => $title, 'content' => trim(do_shortcode($content)));

		$class = '';
		if ($active) {
			$class = 'class="active"';
		}

		return '<li ' . $class . '><div class="title"><h5>' . $title . '</h5></div><div class="content">' . trim(do_shortcode($content)) . '</div></li>';
	}

	function beopen_accordion($atts, $content = null) {

		return '<ul class="accordion">' . do_shortcode($content) . '</ul>';
	}

	function beopen_toggle($atts, $content = null) {
		extract(shortcode_atts(array(
			'title' => '',
			'active' => false
						), $atts));

		$class = '';
		if ($active) {
			$class = 'active';
		}

		return '<div class="toggle ' . $class . '"><div class="title"><h5>' . $title . '</h5></div><div class="content">' . trim(do_shortcode($content)) . '</div></div>';
	}

	/* BOXES */

//[message type="info"]Your message goes here... [/message]

	function beopen_message($atts, $content = null) {
		extract(shortcode_atts(array('type' => 'info'), $atts));

		$class = '';
		if (in_array($type, array('info', 'success', 'warning', 'error'))) {
			$class = $type;
		}

		return '<div class="alert-message ' . $class . '"><div class="box-icon"><i class="beopen-icon"></i></div>' . do_shortcode($content) . '<a href="" class="close"><span>&times;</span></a></div>';
	}

	/* Tooltips, Highlight, Dividers */

	function beopen_tooltip($atts, $content = null) {
		extract(shortcode_atts(array('title' => ''), $atts));

		return '<span class="has-tip" data-width="210" title="' . $title . '">' . do_shortcode($content) . '</span>';
	}

	function beopen_highlight($atts, $content = null) {
		extract(shortcode_atts(array('title' => ''), $atts));

		return '<span class="label">' . do_shortcode($content) . '</span>';
	}

	function beopen_divider($atts) {
		extract(shortcode_atts(array('type' => ''), $atts));

		return '<div class="divider"></div>';
	}

	/* Lists */

	function beopen_listitem($atts, $content = null) {
		extract(shortcode_atts(array('title' => ''), $atts));

		return '<li><i class="icon-ok"></i>' . do_shortcode($content) . '</li>';
	}

	function beopen_list($atts, $content = null) {
		extract(shortcode_atts(array('type' => ''), $atts));



		return '<ul class="icons">' . do_shortcode($content) . '</ul>';
	}

	/* Tables */

	/* Blockquotes, Dropcaps */

	function beopen_dropcap($atts, $content = null) {
		return '<span class="dropcap">' . do_shortcode($content) . '</span>';
	}

	/* Images, Video, Audio */



	wp_oembed_add_provider('http://www.slideshare.net/*/*', 'http://www.slideshare.net/api/oembed/2');

	wp_oembed_add_provider('http://instagr.am/*/*', 'http://api.instagram.com/oembed');
	wp_oembed_add_provider('http://www.instagram.com/*/*', 'http://api.instagram.com/oembed');
	wp_oembed_add_provider('http://instagram.com/*/*', 'http://api.instagram.com/oembed');

	function vid_sc($atts, $content = null) {
		extract(
				shortcode_atts(array(
			'site' => 'youtube',
			'id' => '',
			'w' => '600',
			'h' => '370'
						), $atts)
		);
		if ($site == "youtube") {
			$src = 'http://www.youtube-nocookie.com/embed/' . $id;
		} else if ($site == "vimeo") {
			$src = 'http://player.vimeo.com/video/' . $id;
		} else if ($site == "dailymotion") {
			$src = 'http://www.dailymotion.com/embed/video/' . $id;
		} else if ($site == "yahoo") {
			$src = 'http://d.yimg.com/nl/vyc/site/player.html#vid=' . $id;
		} else if ($site == "bliptv") {
			$src = 'http://a.blip.tv/scripts/shoggplayer.html#file=http://blip.tv/rss/flash/' . $id;
		} else if ($site == "veoh") {
			$src = 'http://www.veoh.com/static/swf/veoh/SPL.swf?videoAutoPlay=0&permalinkId=' . $id;
		} else if ($site == "viddler") {
			$src = 'http://www.viddler.com/simple/' . $id;
		}
		if ($id != '') {
			return '<iframe width="' . $w . '" height="' . $h . '" src="' . $src . '" class="vid iframe-' . $site . '"></iframe>';
		}
	}

	function beopen_soundcloud($atts, $content) {
		extract(
				shortcode_atts(array(
			'url' => $content,
			'width' => '100%',
			'height' => '81',
			'comments' => 'true',
			'auto_play' => 'false',
			'color' => 'ff7700',
						), $atts)
		);

		return '<object class="notfluid" height="' . $height . '" width="' . $width . '"><param name="movie" value="http://player.soundcloud.com/player.swf?url=' . urlencode($url) . '&amp;show_comments=' . $comments . '&amp;auto_play=' . $auto_play . '&amp;color=' . $color . '"></param><param name="allowscriptaccess" value="always"></param><embed class="notfluid" allowscriptaccess="always" height="' . $height . '" src="http://player.soundcloud.com/player.swf?url=' . urlencode($url) . '&amp;show_comments=' . $comments . '&amp;auto_play=' . $auto_play . '&amp;color=' . $color . '" type="application/x-shockwave-flash" width="' . $width . '"></embed></object>';
	}

	/* PRICING TABLES */

	global $pricing_table_columns;
	$pricing_table_columns = 0;

	function beopen_pricing_table($atts, $content = null) {
		extract(shortcode_atts(array(
			'columns' => '4'
						), $atts));

		global $pricing_table_columns;

		$pricing_table_columns = $columns;

		return '<div class="pricing_table">' . do_shortcode($content) . '<div class="clear"></div></div>';
	}

	function beopen_plan($atts, $content = null) {

		extract(shortcode_atts(array(
			'featured' => false,
			'color' => '#46bed8',
			'linkname' => '',
			'link' => '',
			'name' => '',
			'price' => '',
			'period' => ''
						), $atts));

		global $pricing_table_columns;

		$wwidth = floor(12 / $pricing_table_columns);
		$class = columnNumberToString($wwidth);

		if ($featured == 'true') {
			$class .= ' featured';
		}

		$style = '';
		if ($color) {
			$style = ' style="color: ' . $color . ';" ';
		}

		//$link = '';
		if (($linkname) && ($link)) {
			$extraclass = '';
			if ($featured != 'true') {
				$extraclass .= ' green';
			}
			$link = '<div class="plan_bottom"><a class="button ' . $extraclass . '" href="' . $link . '">' . $linkname . '</a></div>';
		}


		return '<div class="' . $class . ' columns plan"><div class="plan-inner">' .
				'<div class="plan_top"><h3 ' . $style . '>' . $name . '</h3>' .
				'<div class="plan_price" ' . $style . '>' . $price . '</div>' .
				'<div class="plan_period">' . $period . '</div>' .
				'</div>' .
				do_shortcode($content) . $link .
				'</div></div>';
	}

	/* Progress Bar */

	function beopen_progressbar($atts, $content = null) {
		extract(shortcode_atts(array(
			'maxwidth' => '300',
			'description' => '',
			'text_color' => '',
			'background_color' => ''
						), $atts));

		if ($text_color) {
			$astyle[] = 'color: ' . $text_color;
		}

		if ($background_color) {
			$astyle[] = 'background-color: ' . $background_color;
		}

		$icontent = intval($content);

		if ($maxwidth) {
			$maxwidth = trim(str_replace('px', '', $maxwidth));

			if ($icontent > 0) {
				$maxwidth = round($icontent / 100 * $maxwidth, 0);
			}

			$astyle[] = 'display: block; width: ' . $maxwidth . 'px';
		}

		$style = '';
		if (count($astyle) > 0) {
			$style = ' style="' . implode(';', $astyle) . '"';
		}

		return '<span class="beopen-progressbar"' . $style . '><span>' . $content . '</span></span><span class="beopen-progressbar-description">' . $description . '</span>';
	}

	add_shortcode('progressbar', 'beopen_progressbar');

	/* Special */

	function beopen_shortcode($atts, $content = null) {

		return htmlspecialchars($content);
	}

//add_shortcode('shortcode', 'beopen_shortcode');


	function beopen_latest_posts($atts) {

		extract(shortcode_atts(array(
			'title' => 'Latest Posts'
						), $atts));

		return '<div class="beopen-sc">' . beopen_visual_render::sdisplay('latestposts', array('data' => array('title' => $title)), '') . '</div>';
	}

	function escapeHTML($atts, $content = null) {

		$escaped_content = str_replace(']', '&#93;', str_replace('[', '&#91;', htmlspecialchars($content)));

		return $escaped_content;
	}

	/* Twitter */

	/* Twitter */

	function beopen_twitter($atts) {

		global $optionPages;

		extract(shortcode_atts(array(
			'username' => '',
			'count' => 3,
			'query' => 'null',
			'avatarsize' => 'null',
						), $atts));

		$twitter_response = get_transient(FIELD_PREFIX . 'twitter_response');

		if (!$twitter_response) {
			$token = beopen_get_option('twitter_access_token');
			$token_secret = beopen_get_option('twitter_access_token_secret');

			$consumer_key = 'kpl90OBfhx2SLNgNK9OzA';
			$consumer_secret = 'cFa5Tc0OpqaqGVVivh5vkwLT9Pj8uWb4RIFFdUCHo';

			$host = 'api.twitter.com';
			$method = 'GET';
			$path = '/1.1/statuses/user_timeline.json'; // api call path

			$query = array(// query parameters
				'screen_name' => $username,
				'count' => $count
			);

			$oauth = array(
				'oauth_consumer_key' => $consumer_key,
				'oauth_token' => $token,
				'oauth_nonce' => (string) mt_rand(), // a stronger nonce is recommended
				'oauth_timestamp' => time(),
				'oauth_signature_method' => 'HMAC-SHA1',
				'oauth_version' => '1.0'
			);

			$oauth = array_map("rawurlencode", $oauth); // must be encoded before sorting
			$query = array_map("rawurlencode", $query);

			$arr = array_merge($oauth, $query); // combine the values THEN sort

			asort($arr); // secondary sort (value)
			ksort($arr); // primary sort (key)
			// http_build_query automatically encodes, but our parameters
			// are already encoded, and must be by this point, so we undo
			// the encoding step
			$querystring = urldecode(http_build_query($arr, '', '&'));

			$url = "https://$host$path";

			// mash everything together for the text to hash
			$base_string = $method . "&" . rawurlencode($url) . "&" . rawurlencode($querystring);

			// same with the key
			$key = rawurlencode($consumer_secret) . "&" . rawurlencode($token_secret);

			// generate the hash
			$signature = rawurlencode(base64_encode(hash_hmac('sha1', $base_string, $key, true)));

			// this time we're using a normal GET query, and we're only encoding the query params
			// (without the oauth params)
			$url .= "?" . http_build_query($query);
			$url = str_replace("&amp;", "&", $url); //Patch by @Frewuill

			$oauth['oauth_signature'] = $signature; // don't want to abandon all that work!
			ksort($oauth); // probably not necessary, but twitter's demo does it
			// also not necessary, but twitter's demo does this too
			if (!function_exists('add_quotes_twitter')) {

				function add_quotes_twitter($str) {
					return '"' . $str . '"';
				}

			}
			$oauth = array_map("add_quotes_twitter", $oauth);

			// this is the full value of the Authorization line
			$auth = "OAuth " . urldecode(http_build_query($oauth, '', ', '));

			$twitter_response = wp_remote_get($url, array('headers' => array('Authorization' => $auth, 'sslverify' => false)));
			set_transient(FIELD_PREFIX . 'twitter_response', $twitter_response, 60);
		}


		if ($twitter_response['response']['code'] != '200') {
			return 'Error code ' . $twitter_response['response']['code'] . '. Please verify the Twitter Access Token and Twitter Access Token Secret!';
		} else {

			$json = $twitter_response['body'];


			$twitter_data = json_decode($json);

			$output = '<ul class="tweet_list">';
			foreach ($twitter_data as $twitter) {

				$output .= '<li>';
				$tweet = $twitter->text;

				if (is_array($twitter->entities->urls))
					foreach ($twitter->entities->urls as $ourl) {

						$tweet = str_replace($ourl->url, '<a href="' . $ourl->url . '">' . $ourl->display_url . '</a>', $tweet);
					}


				$output .= $tweet;

				$output .= '</li>';
			}
			$output .= '</ul>';
		}
		return $output;
	}

	add_shortcode('twitter', 'beopen_twitter');



	/* Add Buttons to TinyMCE */


	add_action('init', 'add_button');

	function add_button() {
		if (current_user_can('edit_posts') && current_user_can('edit_pages')) {
			add_filter('mce_external_plugins', 'add_plugin');
			add_filter('mce_buttons_3', 'register_button');
		}
	}

	function register_button($buttons) {
		array_push($buttons, "beopen_shortcodes_columns_button");
		return $buttons;
	}

	function add_plugin($plugin_array) {
		$plugin_array['BeopenShortcodesColumns'] = get_template_directory_uri() . '/tinymce/customcodes.js';

		return $plugin_array;
	}

?>