<?php

include('flickr_footer_widget.php');
include('flickr_widget.php');
include('social_widget.php');

/**
 * Adds Portfolio_Widget widget.
 */
class Testimonials_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'testimonials_widget', // Base ID
			'BeOpen Testimonials', // Name
			array( 'description' => __( 'Testimonials', 'beopen' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$title = '';
		extract( $args );

		if ($class == 'beopen-widget-bar') {
		
			beopen_visual_render::display('testimonials', array('data' => array('title' => $title)), '', false);
		
		}
		else
		{


			$title = apply_filters( 'widget_title', $instance['title'] );


			echo $before_widget;
			
			if ( ! empty( $title ) )
				echo $before_title . $title . $after_title;
			
				
			echo beopen_visual_render::widget('testimonials');
			
			echo $after_widget;		
		
		}
		
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
	
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Testimonials', 'beopen' );
		}
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'beopen' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<?php 		
	}

} // class Foo_Widget

// register Foo_Widget widget
add_action( 'widgets_init', create_function( '', 'register_widget( "testimonials_widget" );' ) );





/**
 * Adds Portfolio_Widget widget.
 */
class Portfolio_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'portfolio_widget', // Base ID
			'BeOpen Portfolio', // Name
			array( 'description' => __( 'Portfolio', 'beopen' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$title = '';
		extract( $args );
		
		
		if ($class == 'beopen-widget-bar') {
			
			beopen_visual_render::display('portfolio', array('data' => array('title' => $title)), '');
		
		}
		else
		{

			$title = apply_filters( 'widget_title', $instance['title'] );

			echo $before_widget;
			
			if ( ! empty( $title ) )
				echo $before_title . $title . $after_title;
			
			
			echo beopen_visual_render::widget('portfolio', array('no_items' => $instance['no_items']) );

			
			echo $after_widget;
		
		}
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();

		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['no_items'] = $new_instance['no_items'];

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		if ( isset( $instance[ 'no_items' ] ) ) {
			$no_items = $instance[ 'no_items' ];
		}
		else {
			$no_items = 6;
		}

	
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Portfolio', 'beopen' );
		}
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'beopen' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'no_items' ); ?>"><?php _e( 'Number of items:', 'beopen' ); ?></label> 
		<select id="<?php echo $this->get_field_id( 'no_items' ); ?>" name="<?php echo $this->get_field_name( 'no_items' ); ?>">
<?php
			for ($i = 1; $i <= 8; $i++) {
				echo '<option value="'.$i.'" ';
				if ($no_items == $i) {
					echo ' selected="selected" ';
				}
				echo '>';
				echo $i;
				echo '</option>';
			}
?>			
		</select>
		</p>
		<?php 	
	
	}

} // class Foo_Widget

// register Foo_Widget widget
add_action( 'widgets_init', create_function( '', 'register_widget( "portfolio_widget" );' ) );


/**
 * Adds Services_Widget widget.
 */
class Services_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		parent::__construct(
	 		'services_widget', // Base ID
			'BeOpen Services', // Name
			array( 'description' => __( 'Services', 'beopen' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$title = '';
		extract( $args );

		if ($class == 'beopen-widget-bar') {
		
			beopen_visual_render::display('services', array('data' => array('title' => $title)), '', false);
		
		}
		else
		{


			$title = apply_filters( 'widget_title', $instance['title'] );


			echo $before_widget;
			
			if ( ! empty( $title ) )
				echo $before_title . $title . $after_title;
			
				
			echo beopen_visual_render::widget('services', array('no_items' => $instance['no_items']));
			
			echo $after_widget;
		
		}
		
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['no_items'] = $new_instance['no_items'];

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
	
		if ( isset( $instance[ 'no_items' ] ) ) {
			$no_items = $instance[ 'no_items' ];
		}
		else {
			$no_items = 6;
		}	
	
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Services', 'beopen' );
		}
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'beopen' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
		<label for="<?php echo $this->get_field_id( 'no_items' ); ?>"><?php _e( 'Number of items:', 'beopen' ); ?></label> 
		<select id="<?php echo $this->get_field_id( 'no_items' ); ?>" name="<?php echo $this->get_field_name( 'no_items' ); ?>">
<?php
			for ($i = 1; $i <= 8; $i++) {
				echo '<option value="'.$i.'" ';
				if ($no_items == $i) {
					echo ' selected="selected" ';
				}
				echo '>';
				echo $i;
				echo '</option>';
			}
?>			
		</select>
		</p>	
		
		<?php 	
	}

} // class Foo_Widget

// register Foo_Widget widget
add_action( 'widgets_init', create_function( '', 'register_widget( "services_widget" );' ) );





?>