(function($) {
    "use strict";

    var originalImages;

    var isWindowsPhone = (navigator.userAgent.match(/Windows Phone/i)) || (navigator.userAgent.match(/WPDesktop/i));

    /* ISOTOPE ADAPTATION */

    // modified Isotope methods for gutters in masonry
    $.Isotope.prototype._getMasonryGutterColumns = function() {
        var gutter = this.options.masonry && this.options.masonry.gutterWidth || 0;
        var containerWidth = this.element.width();

        this.masonry.columnWidth = this.options.masonry && this.options.masonry.columnWidth ||
                // or use the size of the first item
                this.$filteredAtoms.outerWidth(true) ||
                // if there's no items, use size of container
                containerWidth;

        this.masonry.columnWidth += gutter;

        this.masonry.cols = Math.floor((containerWidth + gutter) / this.masonry.columnWidth);
        this.masonry.cols = Math.max(this.masonry.cols, 1);
    };

    $.Isotope.prototype._masonryReset = function() {
        // layout-specific props
        this.masonry = {};
        // FIXME shouldn't have to call this again
        this._getMasonryGutterColumns();
        var i = this.masonry.cols;
        this.masonry.colYs = [];
        while (i--) {
            this.masonry.colYs.push(0);
        }
    };

    $.Isotope.prototype._masonryResizeChanged = function() {
        var prevSegments = this.masonry.cols;
        // update cols/rows
        this._getMasonryGutterColumns();
        // return if updated cols/rows is not equal to previous
        return (this.masonry.cols !== prevSegments);
    };

    /* OTHER UTILS */

    var Browser = {
        Version: function() {
            var version = 999; // we assume a sane browser
            if (navigator.appVersion.indexOf("MSIE") != -1)
                // bah, IE again, lets downgrade version number
                version = parseFloat(navigator.appVersion.split("MSIE")[1]);
            return version;
        }
    }

    function randArr(arr) {
        for (var j, x, i = arr.length; i; j = parseInt(Math.random() * i), x = arr[--i], arr[i] = arr[j], arr[j] = x)
            ;
        return arr;
    }

    function randsort(c) {
        var o = new Array();
        for (var i = 0; i < c; i++) {
            var n = Math.floor(Math.random() * c);
            if ($.inArray(n, o) > 0)
                --i;
            else
                o.push(n);
        }
        return o;
    }



    function onResize($) {

        if ($portfolios) {
            portfolioIsotope($);
        }

        if ($masonry) {
            masonryIsotope($);
        }


        $('.fred').each(function(i, e) {
            $(e).disableSelection();



            if ($(e).find('.beopen-client').length > 0) {

                $(e).carouFredSel({
                    items: {    
                    },
                    width: '100%',
                    prev: $(e).parent().find('.jc-previous'),
                    next: $(e).parent().find('.jc-next'),
                    auto: false,
                    scroll: {
                        items: 1,
                        duration: 300,
                        easing: 'swing'
                    },
                    mousewheel:
                            {
                                items: 1
                            },
                    swipe: {
                        onMouse: true,
                        onTouch: true
                    }
                }
                );
            }
            else
            if ($(e).find('.testimonial').length > 0) {

                $(e).wrap('<div class="beopen-grid-margin" />');

                $(e).carouFredSel({
                    responsive: true,
                    pagination: {
                        container: $(e).parent().parent().find('.pagination')
                    },
                    items: {
                        minimum: 2
                    },
                    width: '100%',
                    prev: $(e).parent().parent().find('.jc-previous'),
                    next: $(e).parent().parent().find('.jc-next'),
                    auto: false,
                    scroll: {
                        items: 1,
                        duration: 300,
                        easing: 'swing'
                    },
                    mousewheel:
                            {
                                items: 1
                            },
                    swipe: {
                        onMouse: true,
                        onTouch: true
                    }

                }
                );



            }
            else

            {

                $(e).parent().parent().find('.jc-previous, .jc-next').attr('style', 'display: none !important;');

                $(e).waitForImages(function() {

                    $(e).carouFredSel({
                        pagination: {
                            container: $(e).parent().find('.pagination')
                        },
                        items: {
                            minimum: 1,
                            width: $(e).find('.rs-carousel-item').width()
                        },
                        width: '100%',
                        auto: false,
                        scroll: {
                            items: 1,
                            duration: 300,
                            easing: 'swing'
                        },
                        mousewheel:
                                {
                                    items: 1
                                },
                        swipe: {
                            onMouse: true,
                            onTouch: true
                        }

                    },
                    {transition: true}
                    );

                });

            }

        });


    }



    function masonryIsotope($) {
        $masonry.isotope({
            resizable: false,
            gutterWidth: 20,
            masonry: {
            }
        });

    }

    function portfolioIsotope($, selector) {

        $portfolios.removeClass('beopen-grid-' + cols);

        cols = selector;

        var _size = Math.floor(($('.topbar .row').width() - 20 * (cols - 1)) / cols);




        $('article.portfolio_item').attr('style', 'width: ' + _size + 'px;');


        $portfolios.isotope({
            resizable: false,
            filter: $('#portfolio-filter').val(),
            masonry: {
                columnWidth: _size,
                gutterWidth: 20
            }
        });



        $portfolios.addClass('beopen-grid-' + cols);


    }


    var $portfolios = null;
    var $masonry = null;
    var cols = null;

    $(window).load(function() {

        $ = jQuery;

        // ENABLE AND DISABLE NICESCROLLING BASED ON OPTIONS
        if ((!isWindowsPhone) && ($('body').hasClass('beopen-smooth-scroll'))) {
            $("html").niceScroll({styler: "fb", cursorcolor: "#000", zindex: 100000, horizrailenabled: false});
        }
        else
        {
            $("html").addClass('beopen-overflow-scroll');
        }


        $('.fred').parents('.columns').addClass('carousels');

        $masonry = $('.masonry');

        if ($masonry.length > 0) {
            
            $('.masonry img').waitForImages(function() {
                masonryIsotope();
            });
        }

        var selector = '*';

        $portfolios = $('#portfolios');
        if ($portfolios.length > 0) {


            portfolioIsotope($, $('#portfolio-sizes a#beopen-portfolio-size-selected').data('filter'));

            $('#portfolio-sizes a').click(function() {
                $('#portfolio-sizes a').attr('id', '');

                selector = $(this).data('filter')
                portfolioIsotope($, selector);
                $(this).attr('id', 'beopen-portfolio-size-selected');
            });

            $('#portfolio-filter').dropkick({
                change: function(value, label) {

                    selector = value;


                    $portfolios.isotope({
                        filter: selector
                    });

                }
            });

            $('#main-content').removeClass('beopen-hidden');

        }
    });

    jQuery(document).ready(function($) {

        // FITVIDS
        $('body .video, body article').fitVids({
            customSelector: "iframe"
        });


        var header_extended = false;

        if (typeof initialize_map == 'function') {
            initialize_map();
        }

        if (typeof initialize_recaptcha == 'function') {
            initialize_recaptcha();
        }



        $('.beopen-home .flexslider').flexslider({
            animation: "slide",
            controlNav: false,
            slideshow: false,
            touch: true,
            prevText: '',
            nextText: ''
        });


        function fader() {
        }

        $('.portfolio-round').roundabout({
            autoplayPauseOnHover: true,
            autoplay: true,
            autoplayDuration: 5000,
            minScale: 0.005,
            maxScale: 1,
            tilt: 2.4,
            minOpacity: 1,
            duration: 400,
            enableDrag: true,
            dragFactor: 7,
            responsive: true
        });



        $('article .flexslider').flexslider({
            animation: "slide",
            touch: true,
            prevText: '',
            nextText: ''
        });

        onResize($);


        $(".feature, .process-bg").hover(function() {
            $(this).find('img').animate({
                opacity: 0.5
            }, 400, function() {
                $(this).animate({
                    opacity: 1
                }, 400);
            });
        },
                function() {

                });


        $("#extender").click(
                function(e) {
                    e.preventDefault();
                    if (!$(this).hasClass('invert')) {
                        $(this).addClass('invert');
                        $('#header-extension').show().animate({
                            height: 100,
                            'padding-top': 20,
                            'padding-bottom': 20
                        }, 300);
                    }
                    else
                    {
                        $(this).removeClass('invert');
                        $('#header-extension').animate({
                            height: 0,
                            'padding-top': 0,
                            'padding-bottom': 0
                        }, 200, function() {
                            $(this).hide();
                        });
                    }

                }
        );





        /* Use this js doc for all application specific JS */

        $(document).on('click.fndtn', '.accordion li', function() {
            var flyout = $(this).children('.content').first();
            $('.accordion .content').not(flyout).slideUp('fast').parent('li').removeClass('active');
            flyout.slideDown('fast', function() {
                flyout.parent('li').addClass('active');
            });
        });

        $(document).on('click.fndtn', '.toggle > .title', function() {
            var flyout = $(this).siblings('.content').first();

            if (flyout.parent('.toggle').hasClass('active')) {
                flyout.slideUp('fast', function() {
                    flyout.parent('.toggle').toggleClass('active');
                });
            }
            else
            {
                flyout.slideDown('fast', function() {
                    flyout.parent('.toggle').toggleClass('active');
                });
            }
        });


        /* TABS --------------------------------- */
        /* Remove if you don't need :) */

        function activateTab($tab) {

            var $activeTab = $tab.closest('dl').find('dd.active'),
                    contentLocation = $tab.children('a').attr("href") + 'Tab';

            // Strip off the current url that IE adds
            contentLocation = contentLocation.replace(/^.+#/, '#');

            // Strip off the current url that IE adds
            contentLocation = contentLocation.replace(/^.+#/, '#');

            //Make Tab Active
            $activeTab.removeClass('active');

            $tab.addClass('active');

            //Show Tab Content

            $(contentLocation).closest('.tabs-content').children('li').hide();

            $(contentLocation).css('display', 'block');
        }


        $('dl.tabs dd a').on('click.fndtn', function(event) {
            activateTab($(this).parent('dd'));
        });

        if (window.location.hash) {
            activateTab($('a[href="' + window.location.hash + '"]'));
            $.foundation.customForms.appendCustomMarkup();
        }

        /* ALERT BOXES ------------ */
        $(".alert-message").delegate("a.close", "click", function(event) {
            event.preventDefault();
            $(this).closest(".alert-message").fadeOut(function(event) {
                $(this).remove();
            });
        });

        /* PLACEHOLDER FOR FORMS ------------- */
        /* Remove this and jquery.placeholder.min.js if you don't need :) */
        $('input, textarea').placeholder();

        /* TOOLTIPS ------------ */
        $('.has-tip').tipsy({
            live: true,
            gravity: 's',
            opacity: 1,
            fade: true,
            html: true,
            offset: 40
        });

        /* UNCOMMENT THE LINE YOU WANT BELOW IF YOU WANT IE6/7/8 SUPPORT AND ARE USING .block-grids */
        //  $('.block-grid.two-up>li:nth-child(2n+1)').css({clear: 'left'});
        //  $('.block-grid.three-up>li:nth-child(3n+1)').css({clear: 'left'});
        //  $('.block-grid.four-up>li:nth-child(4n+1)').css({clear: 'left'});
        //  $('.block-grid.five-up>li:nth-child(5n+1)').css({clear: 'left'});



        /* DISABLED BUTTONS ------------- */
        /* Gives elements with a class of 'disabled' a return: false; */

        /* SPLIT BUTTONS/DROPDOWNS */
        $('.button.dropdown > ul').addClass('no-hover');

        $('.button.dropdown').on('click.fndtn touchstart.fndtn', function(e) {
            e.stopPropagation();
        });
        $('.button.dropdown.split span').on('click.fndtn touchstart.fndtn', function(e) {
            e.preventDefault();
            $('.button.dropdown').not($(this).parent()).children('ul').removeClass('show-dropdown');
            $(this).siblings('ul').toggleClass('show-dropdown');
        });

        $('.button.dropdown').not('.split').on('click.fndtn touchstart.fndtn', function(e) {
            e.preventDefault();
            $('.button.dropdown').not(this).children('ul').removeClass('show-dropdown');
            $(this).children('ul').toggleClass('show-dropdown');
        });

        $('body, html').on('click.fndtn touchstart.fndtn', function() {
            $('.button.dropdown ul').removeClass('show-dropdown');
        });

        // Positioning the Flyout List
        var normalButtonHeight = $('.button.dropdown:not(.large):not(.small):not(.tiny)').outerHeight() - 1,
                largeButtonHeight = $('.button.large.dropdown').outerHeight() - 1,
                smallButtonHeight = $('.button.small.dropdown').outerHeight() - 1,
                tinyButtonHeight = $('.button.tiny.dropdown').outerHeight() - 1;

        $('.button.dropdown:not(.large):not(.small):not(.tiny) > ul').css('top', normalButtonHeight);
        $('.button.dropdown.large > ul').css('top', largeButtonHeight);
        $('.button.dropdown.small > ul').css('top', smallButtonHeight);
        $('.button.dropdown.tiny > ul').css('top', tinyButtonHeight);

        String.prototype.repeat = function(num)
        {
            return new Array(num + 1).join(this);
        }



        $('nav#beopen-responsive').find('.flyout').removeClass('flyout');

        function setupSwipe() {
            $(".pp_hoverContainer").swipe({
                swipeLeft: function() {
                    $.prettyPhoto.changePage('next');
                },
                swipeRight: function() {
                    $.prettyPhoto.changePage('previous');
                },
                threshold: 20
            });

        }




        var browserWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;


        var lastResponsive = 0;
        var myPhotoSwipe;
        var responsive;
        var photos;


        function doResponsiveActions() {
            browserWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;


            if (browserWidth <= 767) {

                responsive = 1;

                if (lastResponsive != responsive) {
                    lastResponsive = responsive;


                    $("a[href$='.jpg'], a[href$='.jpeg'], a[href$='.gif'], a[href$='.png']").unbind('click');
                    $("a[rel^=prettyPhoto]").unbind('click');

                    photos = $("a[rel^=prettyPhoto], a[href$='.jpg'], a[href$='.jpeg'], a[href$='.gif'], a[href$='.png']");

                    if (photos.length > 0) {
                        myPhotoSwipe = photos.photoSwipe({enableMouseWheel: true, enableKeyboard: true});
                    }

                }

            }
            else
            {
                responsive = 2;

                if (lastResponsive != responsive) {


                    if (lastResponsive == 1) {
                        window.Code.PhotoSwipe.detatch(myPhotoSwipe);
                    }


                    $('li, article').not('.clone').find("a[href$='.jpg'], a[href$='.jpeg'], a[href$='.gif'], a[href$='.png']").prettyPhoto({
                        animationSpeed: 'normal', /* fast/slow/normal */
                        padding: 40, /* padding for each side of the picture */
                        opacity: 0.35, /* Value betwee 0 and 1 */
                        showTitle: true, /* true/false */
                        social_tools: '',
                        changepicturecallback: function() {
                            setupSwipe();
                        }
                    });

                    $('li').not('.clone').find("a[rel^=prettyPhoto]").prettyPhoto({
                        animationSpeed: 'normal', /* fast/slow/normal */
                        padding: 40, /* padding for each side of the picture */
                        opacity: 0.35, /* Value betwee 0 and 1 */
                        showTitle: true, /* true/false */
                        social_tools: '',
                        changepicturecallback: function() {
                            setupSwipe();
                        }
                    });

                    lastResponsive = responsive;
                }
            }

        }

        $(window).resize(function() {
            onResize($);
            doResponsiveActions();
        });
        doResponsiveActions();



        $('#beopen-nav-bar').superfish({
            speed: 'fast',
            delay: 600,
            disableHI: false,
            animation: {height: 'show'}, // an object equivalent to first parameter of jQuerys .animate() method. Used to animate the submenu open
            animationOut: {height: 'hide'}, // an object equivalent to first parameter of jQuerys .animate() method Used to animate the submenu closed
        });

        $('#responsive-trigger').click(function() {
            $('nav#standard').toggle("slow");
        });

        if (window.location.hash) {
            $('#beopen-nav-bar li.active > a').each(function(i, e) {

                var ahash = $(e).attr('href');
                ahash = ahash.substring(ahash.indexOf('#'));

                if (ahash != window.location.hash) {
                    $(e).parent().removeClass('active');
                }
            });
        }

        $('#beopen-nav-bar').find('.active').parents('li').addClass('active');




        $(".beopen-jp-jplayer").each(function(i, e) {
            var jpcontainer = $(e).attr('id');
            var i_jpcontainer = jpcontainer.replace('beopen-jplayer-', '');

            $('#' + $(e).attr('id')).jPlayer({
                ready: function() {

                    $(this).jPlayer("setMedia", {
                        mp3: $(this).attr('data-media')
                    });
                },
                cssSelectorAncestor: '#jp_container_' + i_jpcontainer

            });
        });

        // BEOPEN WIDE PORTFOLIO GRID
        $(' .beopen-wide-portfolio-grid > li ').each(function() {
            $(this).hoverdir({hoverElem: 'div.portfolio-grid-hover', speed: 200});
        });


        // HEADER MENU - QUICK SEARCH
        $('#beopen-quick-search').click(function() {
            $('#beopen-quick-search-container').toggleClass('beopen-open');

            $('#beopen-quick-search-box').focus();
        });


        function beopen_do_animations() {
            $('.beopen-row-animated').each(function() {
                var imagePos = $(this).offset().top;
                var topOfWindow = $(window).scrollTop();

                if (imagePos < topOfWindow + $(window).height() - 200) {
                    $(this).addClass($(this).data('beopen-animation'));
                }
            });
        }

        beopen_do_animations();
        $(window).scroll(function() {
            beopen_do_animations();
        });


        var header_fixed = $('body').hasClass('beopen-fixed-header');

        function beopen_timer() {

            if (header_fixed) {

                if (browserWidth >= 768) {

                    if ($(document).scrollTop() <= 10) {
                        $('#header').removeClass('is-sticky');

                        var new_height = $('#header-fixed').height();
                        if ($('#header').height() < new_height) {
                            $('#header').stop().animate({'height': new_height, 'min-height': new_height});
                        }

                    }
                    else {
                        $('#header').addClass('is-sticky');
                    }
                }
                else
                {
                    // REMOVE STICKY ON MOBILE VIEW
                    $('#header').removeClass('is-sticky');
                }
            }


            if ($('#header-fixed').css('background-color') != $('#header').css('background-color')) {
                $('#header-fixed').css('background-color', $('#header').css('background-color'));
            }

            if ($('#header-fixed').css('background') != $('#header').css('background')) {
                $('#header-fixed').css('background', $('#header').css('background'));
            }



            if ($(document).scrollTop() > 100) {
                $('#beopen-scroll-up-button').addClass('active');
            } else {
                $('#beopen-scroll-up-button').removeClass('active');
            }

            setTimeout(beopen_timer, 100);
        }

        beopen_timer();

        $('#beopen-scroll-up-button').click(function() {
            $("html, body").animate({scrollTop: 0}, 600);
            return false;
        });



        // FIX SCROLL ISSUE WHEN USING MOUSEWHEEL OVER CAROUSELS
        $(document).on('DOMMouseScroll mousewheel', '.fred', function(ev) {
            var $this = $(this),
                    scrollTop = this.scrollTop,
                    scrollHeight = this.scrollHeight,
                    height = $this.height(),
                    delta = (ev.type == 'DOMMouseScroll' ?
                            ev.originalEvent.detail * -40 :
                            ev.originalEvent.wheelDelta),
                    up = delta > 0;

            var prevent = function() {
                ev.stopPropagation();
                ev.preventDefault();
                ev.returnValue = false;
                return false;
            }

            if (!up && -delta > scrollHeight - height - scrollTop) {
                // Scrolling down, but this will take us past the bottom.
                $this.scrollTop(scrollHeight);
                return prevent();
            } else if (up && delta > scrollTop) {
                // Scrolling up, but this will take us past the top.
                $this.scrollTop(0);
                return prevent();
            }
        });



        $('#portfolio-items').dropkick({
            change: function(value, label) {

                window.location.href = value;

            }
        });




        if (typeof beopen_map_data == 'object') {

            var beopen_location = new google.maps.LatLng(parseFloat(beopen_map_data.lat), parseFloat(beopen_map_data.long));
            var mapOptions = {
                center: beopen_location,
                zoom: parseInt(beopen_map_data.zoom),
                scaleControl: false,
                scrollwheel: false,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };
            var map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);

            var beopen_center = new google.maps.LatLng(parseFloat(beopen_map_data.lat), parseFloat(beopen_map_data.long));
            var marker = new google.maps.Marker({
                position: beopen_center,
                map: map,
                title: ""
            });

        }

        if (typeof Recaptcha == 'object')
        {
            Recaptcha.create(beopen_recaptcha_data.public_key, "recaptcha_div", {
                theme: "clean",
                callback: Recaptcha.focus_response_field});
        }


    });

})(jQuery);