<?php /* Start loop */ ?>
<?php while (have_posts()) : the_post(); ?>
	<article <?php post_class() ?> id="post-<?php the_ID(); ?>">
		
        <header>
           
			<?php echo beopen_entry_categories(); ?>
            <h2><?php echo the_title(); ?></h2>
            
			<div class="post-meta">    
            <?php beopen_entry_meta(array('date', 'author', 'comments')); ?>
			</div>
        </header>
        
		<div class="entry-content">            
			<?php the_content(); ?>
			<?php wp_link_pages(array(
				'before' => '<nav id="page-nav" class="beopen-post-pagination">' . __('Pages:', 'beopen') , 
				'after' => '</nav>',
				'pagelink' => '<span class="beopen-post-pagination-page">%</span>'
			)); ?>
            <div class="beopen-clear-both"></div>
			<?php beopen_entry_meta(array('tags')); ?>
			<div class="beopen-clear-both"></div>
        </div>
        <div class="clearfix"></div>
        
        <div class="entry-content">
            <?php
            if (beopen_get_option('show_about_author_in_post') == 2) {
            ?>
			<div class="author-box">
				<div class="author-picture-box">	
					<?php echo '<a href="'.get_the_author_meta('user_url').'">'; ?>
					<?php echo get_avatar(get_the_author_meta('user_email'), 80); ?>
					<?php echo '</a>'; ?>
				</div>
				
                <h3 class="title"><?php _e('About the author', 'beopen'); ?></h3>
				<div class="author-description"><?php echo wpautop(get_the_author_meta('description')); ?></div>
                <div class="clearfix"></div>
			</div>
            <?php
            }
            ?>			
        </div>
        
        <div class="entry-content">
		<?php comments_template(); ?>
		</div>
        
		
	</article>
<?php endwhile; // End the loop ?>