<?php get_header(); ?>


<?php /* Start loop */ ?>
<?php while (have_posts()) : the_post(); ?>


<div id="main-content">

    <div class="row portfolio-header">            

        <div class="eight columns project-selector">
			
			<select id="portfolio-items">
			<?php
				$args = array('post_type' => 'portfolio_item', 'order' => 'DESC', 'posts_per_page' => $posts_per_page);
				$projects = new WP_Query($args);
				
				$portfolio_item_ID = get_the_ID(); 
					
				if ($projects->have_posts()) {
					while ($projects->have_posts()) {
						$projects->the_post();
						echo '<option value="' . get_permalink(). '"';
						
						if ($portfolio_item_ID == get_the_ID()) {
							echo 'selected="selected"';
						}
					
						echo '>'.get_the_title().'</option>';
					}
					wp_reset_query();
				}
			?>
			</select>
			
        </div>        
        <div class="four columns">
            <?php beopen_portfolio_navigate(); ?>
        </div>
        
    </div>
    <div class="row portfolio">              

        <article <?php post_class() ?> id="post-<?php the_ID(); ?>"> 
            <!-- Row for main content area -->
            <div id="content" class="eight columns" role="main">

                <div class="entry-content">

                    <?php

                    $show_preview_as = get_post_meta($post->ID, 'show_preview_as', true);


                    $embedvideo = get_post_meta($post->ID, 'embedvideo', true);

                    if ($embedvideo) {
                        echo '<div class="video">';
                        echo $embedvideo;
                        echo '</div>';
                        
                    }
                    else
                        switch ($show_preview_as) {
                            case 0:

                                if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                                    
                                    echo '<div class="entry-images">';

                                    $large_image_url = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                                    echo '<a href="' . $large_image_url[0] . '" title="' . the_title_attribute('echo=0') . '">';


                                    echo '<figure class="beopen">';
                                    if (isset($post_thumbnail_size)) {
                                        the_post_thumbnail($post_thumbnail_size);
                                    } else {
                                        the_post_thumbnail('full-portfolio-thumbnail');
                                    }
                                    echo '</figure>';

                                    echo '</a>';
                                    echo '</div>';
                                }

                                break;
                            case 2:
                                $args = array('post_type' => 'attachment', 'orderby' => 'menu_order', 'order' => 'ASC', 'numberposts' => -1, 'post_status' => null, 'post_parent' => get_the_ID());
                                
                                $attachments = get_posts($args);
                                if (count($attachments) > 0) {

                                    echo '<div class="flex-container">';
                                    echo '<div class="flexslider"><ul class="slides">';

                                    foreach ($attachments as $attachment) {
                                        echo '<li>';
                                        echo wp_get_attachment_link($attachment->ID, 'full-portfolio-thumbnail');

                                        echo '</li>';
                                    }

                                    echo '</ul>';
                                    echo '</div>';
                                    echo '</div>';
                                }

                                break;
                        }
                    ?>

                    <?php the_content(); ?>
                    
                </div>


            </div>

            <div class="four columns">
                <div class="project-sidebar">
                    <?php
                    $overview = get_post_meta($post->ID, 'overview', true);
                    if ($overview) {
                        echo '<h3>' . __('Overview', 'beopen') . '</h3>';
                        echo wpautop(do_shortcode(get_post_meta($post->ID, 'overview', true)));
                    }
                    
                    beopen_footer_portfolio_entry_meta();
					                
                    ?>
					<div class="post-meta">
                    <?php beopen_portfolio_entry_meta(); ?>
					</div>
                </div>
            </div>   

        </article>        
            
    </div>            






    <div class="row">
        <div class="twelve columns">
            <?php comments_template(); ?>
        </div>
    </div>

</div>


<?php endwhile; // End the loop  ?>
<?php get_footer(); ?>