<?php
    global $post_thumbnail_size;

    $show_preview_as = get_post_meta(get_the_ID(), 'show_preview_as', true);
	

    switch ($show_preview_as) {
        case 0:

            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                echo '<div class="entry-images">';
				
				if (is_single()) {
					$clicklink = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID())) ;
				}
				else
				{
					$clicklink = get_permalink();
				}				

				echo '<a href="' . $clicklink . '">';

                echo '<figure class="beopen">';

                if ($post_thumbnail_size) {
                    the_post_thumbnail($post_thumbnail_size);
                } else {
                    the_post_thumbnail('blog-thumbnail');
                }

                echo '</figure>';
				
				echo '</a>';
								
                echo '</div>';
            }

            break;

        case 2:

            $args = array('post_type' => 'attachment', 'orderby' => 'menu_order', 'order' => 'ASC', 'numberposts' => -1, 'post_parent' => get_the_ID());
            $attachments = get_posts($args);


            if (count($attachments) > 0) {
                echo '<div class="entry-images">';

                echo '<div class="flex-container">';
                echo '<div class="flexslider"><ul class="slides">';


                foreach ($attachments as $attachment) {
                    echo '<li>';

					if (is_single()) {
						$clicklink = wp_get_attachment_url($attachment->ID);
					}
					else
					{
						$clicklink = get_permalink();
					}					
					
					echo '<a href="' . $clicklink . '">';
					
                    if ($post_thumbnail_size) {
                        echo wp_get_attachment_image($attachment->ID, $post_thumbnail_size);
                    } else {
                        echo wp_get_attachment_image($attachment->ID, 'blog-thumbnail');
                    }

					echo '</a>';
					

                    echo '</li>';
                }

                echo '</ul>';
                echo '</div>';
                echo '</div>';

                echo '</div>';
            }


            break;

        case 3:

            $beopen_audio_file_source = get_post_meta($post->ID, 'beopen_audio_file_source', true);

            echo '<div class="entry-preview-multimedia">
                                <div id="beopen-jplayer-' . get_the_ID() . '" class="beopen-jp-jplayer jp-audio" data-media="' . $beopen_audio_file_source . '" data-swfpath="' . THEME_JS . '"></div>
      <div id="jp_container_' . get_the_ID() . '" class="jp-audio">
        <div class="jp-type-single">
          <div class="jp-gui jp-interface">
            <ul class="jp-controls">
              <li><a href="javascript:;" class="jp-play" tabindex="1">' . fontello('play') . '</a></li>
              <li><a href="javascript:;" class="jp-pause" tabindex="1">' . fontello('pause') . '</a></li>
              <li><a href="javascript:;" class="jp-stop" tabindex="1">' . fontello('stop') . '</a></li>
              <li><a href="javascript:;" class="jp-mute" tabindex="1" title="mute"></a></li>
              <li><a href="javascript:;" class="jp-unmute" tabindex="1" title="unmute"></a></li>
              <li><a href="javascript:;" class="jp-volume-max" tabindex="1" title="max volume"></a></li>
            </ul>
            <div class="jp-progress">
              <div class="jp-seek-bar">
                <div class="jp-play-bar"></div>
              </div>
            </div>
            <div class="jp-volume-bar">
              <div class="jp-volume-bar-icon">' . fontello('volume') . '</div>
              <div class="jp-volume-bar-value"></div>
            </div>
            <div class="jp-time-holder">
              <div class="jp-current-time"></div>/
              <div class="jp-duration"></div>
              <ul class="jp-toggles">
                <li><a href="javascript:;" class="jp-repeat" tabindex="1" title="repeat"></a></li>
                <li><a href="javascript:;" class="jp-repeat-off" tabindex="1" title="repeat off"></a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      </div>';

            break;

        case 4:

            $beopen_video_embed_code = get_post_meta($post->ID, 'beopen_video_embed_code', true);

            echo '<div class="entry-preview-multimedia">';
            echo $beopen_video_embed_code;
            echo '</div>';

            break;

        case 5:

            $beopen_quote_preview = get_post_meta($post->ID, 'beopen_quote_preview', true);

            echo '<blockquote>' . $beopen_quote_preview . '</blockquote>';

            break;
    }
?>