<?php
/*
  Template Name: About Us
 */
?>
<?php get_header(); ?>

<div id="main-content">

    <div class="row">

        <!-- Row for main content area -->
        <div id="content" class="twelve columns" role="main">

            <div class="post-box">
                <?php get_template_part('loop', 'page'); ?>
            </div>

        </div>
    </div>    


    <?php
    $member_sizes = array('big', '0');

    foreach ($member_sizes as $member_size) {

        global $query_string;
        query_posts('post_type=team_member&orderby=menu_order&order=ASC&posts_per_page=100&meta_key=member_size&meta_value=' . $member_size);

        $columns = 'four';
        if (!$member_size) {
            $member_size = '';
            $columns = 'three';
        }

        if (have_posts()) {
            echo '<div class="beopen-section"><div class="row"><div class="twelve columns">';
            echo '<h2 class="headline"><span class="beopen-extra-style"></span><span class="title">' . __('Our team', 'beopen') . '</span></h2>';
            echo '</div></div></div>';
        }
        ?>
        <div class="<?php if ($member_size) {
        echo "member-size-big";
    } else {
        echo "member-size";
    } ?>">
            <div class="row">
                <div class="twelve columns">
                    <div class="row">

                        <?php while (have_posts()) : the_post(); ?>



                            <div class="<?php echo $columns; ?> columns end">
                                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                                    <?php
                                    if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                                        echo '<div class="entry-images">';
                                        echo '<figure class="beopen">';

                                        if ($member_size == 'big') {
                                            the_post_thumbnail('member-thumbnail-big');
                                        } else {
                                            the_post_thumbnail('member-thumbnail');
                                        }
                                        echo '</figure>';
                                        echo '</div>';
                                    }
                                    ?>
                                    <div class="member-header">
                                        <h3 class="member-name"><?php the_title(); ?></h3>
                                        <span class="member-job"><?php echo get_post_meta($post->ID, 'member_job_title', true); ?></span>
                                    </div>

                                    <div class="member-social">
                                        <?php
                                        $dribbble = get_post_meta($post->ID, 'member_dribbble', true);
                                        if ($dribbble) {
                                            echo '<a href="' . $dribbble . '" class="socialicon-dribbble">' . fontello('dribbble') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $linkedin = get_post_meta($post->ID, 'member_linkedin', true);
                                        if ($linkedin) {
                                            echo '<a href="' . $linkedin . '" class="socialicon-linkedin">' . fontello('linkedin') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $twitter = get_post_meta($post->ID, 'member_twitter', true);
                                        if ($twitter) {
                                            echo '<a href="' . $twitter . '" class="socialicon-twitter">' . fontello('twitter') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $googleplus = get_post_meta($post->ID, 'member_googleplus', true);
                                        if ($googleplus) {
                                            echo '<a href="' . $googleplus . '" class="socialicon-googleplus">' . fontello('gplus') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $facebook = get_post_meta($post->ID, 'member_facebook', true);
                                        if ($facebook) {
                                            echo '<a href="' . $facebook . '" class="socialicon-facebook">' . fontello('facebook') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $url = get_post_meta($post->ID, 'member_url', true);
                                        if ($url) {
                                            echo '<a href="' . $url . '" class="socialicon-link">' . fontello('link') . '</a>';
                                        }
                                        ?>
                                        <?php
                                        $mail = get_post_meta($post->ID, 'member_mail', true);
                                        if ($mail) {
                                            echo '<a href="mailto:' . $mail . '" class="socialicon-mail">' . fontello('mail') . '</a>';
                                        }
                                        ?>                                
                                    </div>

                                    <?php the_content(); ?>


                                     <?php wp_link_pages(array('before' => '<nav id="page-nav"><p>' . __('Pages:', 'beopen'), 'after' => '</p></nav>')); ?>
                                </article>
                            </div>	
    <?php endwhile; ?>				
                    </div>
                </div>
            </div>
        </div>
    <?php
}
?>

</div>


<?php get_footer(); ?>