<?php

Class DLAjax
{
	public static $request = array();

	public static function init()
	{
		DLAjax::$request = json_decode(trim(file_get_contents('php://input')), true);

		add_action('wp_ajax_nopriv_dl_get_all_data', array('DLAjax', 'getAllData'));
		add_action('wp_ajax_dl_get_all_data', array('DLAjax', 'getAllData'));

		add_action('wp_ajax_nopriv_dl_get_items', array('DLAjax', 'getItems'));
		add_action('wp_ajax_dl_get_items', array('DLAjax', 'getItems'));

		add_action('wp_ajax_nopriv_dl_get_sections', array('DLAjax', 'getSections'));
		add_action('wp_ajax_dl_get_sections', array('DLAjax', 'getSections'));

		add_action('wp_ajax_nopriv_dl_get_icons', array('DLAjax', 'getIcons'));
		add_action('wp_ajax_dl_get_icons', array('DLAjax', 'getIcons'));

		add_action('wp_ajax_nopriv_dl_get_default_icons', array('DLAjax', 'getDefaultIcons'));
		add_action('wp_ajax_dl_get_default_icons', array('DLAjax', 'getDefaultIcons'));

		add_action('wp_ajax_dl_add_item', array('DLAjax', 'addItem'));

		add_action('wp_ajax_dl_add_section', array('DLAjax', 'addSection'));

		add_action('wp_ajax_dl_add_icon', array('DLAjax', 'addIcon'));

		add_action('wp_ajax_dl_update_item', array('DLAjax', 'updateItem'));

		add_action('wp_ajax_dl_update_section', array('DLAjax', 'updateSection'));

		add_action('wp_ajax_dl_update_icon', array('DLAjax', 'updateIcon'));

		add_action('wp_ajax_dl_delete_item', array('DLAjax', 'deleteItem'));

		add_action('wp_ajax_dl_delete_section', array('DLAjax', 'deleteSection'));

		add_action('wp_ajax_dl_delete_icon', array('DLAjax', 'deleteIcon'));

		add_action('wp_ajax_dl_upload_icon', array('DLAjax', 'uploadIcon'));

		add_action('wp_ajax_dl_upload_image', array('DLAjax', 'uploadImage'));

		add_action('wp_ajax_nopriv_dl_get_options', array('DLAjax', 'getOptions'));
		add_action('wp_ajax_dl_get_options', array('DLAjax', 'getOptions'));

		add_action('wp_ajax_dl_update_options', array('DLAjax', 'updateOptions'));

		add_action('wp_ajax_dl_upload_import_csv', array('DLAjax', 'uploadImportCSV'));
		add_action('wp_ajax_dl_import_csv', array('DLAjax', 'importCSV'));
	}

	public static function getAllData()
	{
		header('Content-Type: application/json');
		echo json_encode(DLStoreLocator::getAllData(true, true));
		exit;
	}

	public static function getItems()
	{
		echo json_encode(DLStoreLocator::getItems());
		exit;
	}

	public static function getSections()
	{
		$arSections = array();
        $sections = DLStoreLocator::getSections();
        foreach ($sections as $key => $val)
        {
            $arSections[$val['id']] = $val;
        }
        echo json_encode($arSections);
        exit;
	}

	public static function getIcons()
	{
		$arIcons = array();
        $icons = DLStoreLocator::getIcons();
        foreach ($icons as $key => $val)
        {
            $arIcons[$val['id']] = $val;
        }
        echo json_encode($arIcons);
        exit;
	}

	public static function getDefaultIcons()
	{
		echo json_encode(DLStoreLocator::getDefaultIcons());
		exit;
	}

	public static function addItem()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::addItem(DLAjax::$request['fields']);
        exit;
	}

	public static function addSection()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::addSection(DLAjax::$request['fields']);
        exit;
	}

	public static function addIcon()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::addIcon(DLAjax::$request['fields']);
        exit;
	}

	public static function updateItem()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::updateItem(DLAjax::$request['fields']['id'], DLAjax::$request['fields']);
        exit;
	}

	public static function updateSection()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::updateSection(DLAjax::$request['fields']['id'], DLAjax::$request['fields']);
        exit;
	}

	public static function updateIcon()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::updateIcon(DLAjax::$request['fields']['id'], DLAjax::$request['fields']);
        exit;
	}

	public static function deleteItem()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::deleteItem(DLAjax::$request['fields']);
        exit;
	}

	public static function deleteSection()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::deleteSection(DLAjax::$request['fields']);
        exit;
	}

	public static function deleteIcon()
	{
		DLStoreLocator::securityCheck();
        echo DLStoreLocator::deleteIcon(DLAjax::$request['fields']);
        exit;
	}

	public static function uploadIcon()
	{
		DLStoreLocator::securityCheck();
        echo json_encode(DLStoreLocator::uploadImage(62, 62));
        exit;
	}

	public static function uploadImage()
	{
		DLStoreLocator::securityCheck();
	    echo json_encode(DLStoreLocator::uploadImage(350, 1000));
	    exit;
	}

	public static function getOptions()
	{
		echo json_encode(DLStoreLocator::getOptions());
		exit;
	}

	public static function updateOptions()
	{
		DLStoreLocator::securityCheck();
		$requestData = DLAjax::$request['fields'];
		$templateData = array(
			'text_color'		=> $requestData['color_scheme']['text_color'],
			'link_color'		=> $requestData['color_scheme']['link_color'],
			'background_color'	=> $requestData['color_scheme']['background_color'],
			'header_color'		=> $requestData['color_scheme']['header_color'],
			'hover_color'		=> $requestData['color_scheme']['hover_color'],
			'scroll_color'		=> $requestData['color_scheme']['scroll_color']
		);
		DLStoreLocator::processTemplate($templateData);
        echo DLStoreLocator::updateOptions($requestData);
        exit;
	}

	public static function uploadImportCSV()
	{
		DLStoreLocator::securityCheck();

		$result = DLCSVImport::upload();

		echo json_encode($result);

		exit;
	}

	public static function importCSV() {

		DLStoreLocator::securityCheck();
		
		$fields = DLAjax::$request['fields'];
		$items = DLAjax::$request['items'];
		$filename = DLAjax::$request['file'];

		$result = DLCSVImport::import($fields, $items, $filename);

		if ($result) {
			echo json_encode(array(
				'message' => 'Successfully imported ' . $result . ' items'
			));
		} else {
			echo 0;
		}

		exit();
	}
}

?>