<?php

Class DLCSVImport
{
	public static $fields = array(
		"name" => 'Title',
		"url" => 'Website URL',
		"phone" => 'Phone number',
		"work_time_text" => 'Comment for opening time',
		"icon" => 'Type',
		"section" => 'Section',
		"address" => 'Display address',
		"latitude" => 'Latitude',
		"longitude" => 'Longitude',
		"active" => 'Active',
		"sort" => 'Sort',
		"description" => 'Description',
	);

	public static $required = array(
		'name', 'address', 'latitude', 'longitude'
	);

	public static function init() {

        add_filter('upload_mimes', array('DLCSVImport', 'allowCSVType'));

		foreach (self::$fields as &$field) {
			$field = __($field, 'dl-store-locator');
		}
	}

    public static function allowCSVType($mimes) {
        $mimes['csv'] = 'text/csv';
        return $mimes;
    }

	public static function upload() {

		$result = array();

		$movefile = wp_handle_upload($_FILES['file'], array('test_form' => false));

		if ($movefile && !isset( $movefile['error'])) {
			$file = fopen($movefile['file'], 'r');
			$data = array();
			while ($item = fgetcsv($file, 0, ';')) {
				$data[] = $item;
			}
			if (!empty($data)) {
				$result = array(
					'data' => $data,
					'file' => $movefile['file'],
					'fields' => self::$fields,
					'required' => self::$required
				);
			} else {
				$result = array(
					'error' => 'Empty data'
				);
			}
		} else {
			$result = array(
				'error' => $movefile['error']
			);
		}

		return $result;
	}

	public static function import($fields, $items, $filename) {

		$file = fopen($filename, 'r');

		$arCSV = array();
		while ($item = fgetcsv($file, 0, ';')) {
			$newItem = array();
			foreach ($fields as $key => $field) {
				$newItem[$field] = trim($item[$key]);
			}
			$arCSV[] = $newItem;
		}

		$sections = DLStoreLocator::getSections();
		$sectionNames = array();

		foreach ($sections as $section) {
			$sectionNames[$section['id']] = $section['name'];
		}

		$icons = DLStoreLocator::getIcons();
		$iconNames = array();

		foreach ($icons as $icon) {
			$iconNames[$icon['id']] = $icon['name'];
		}

		$arImportCSV = array();
		foreach ($items as $item) {

			if (!empty($arCSV[$item]['section'])) {
				if (!in_array($arCSV[$item]['section'], $sectionNames)) {
					$sectionID = DLStoreLocator::addSection(array(
						'name' => $arCSV[$item]['section']
					));
					$sectionNames[$sectionID] = $arCSV[$item]['section'];
					$arCSV[$item]['section_id'] = $sectionID;
				} else {
					$arCSV[$item]['section_id'] = array_search($arCSV[$item]['section'], $sectionNames);
				}
				unset($arCSV[$item]['section']);
			} else {
				$arCSV[$item]['section_id'] = $sections[0]['id'];
			}

			if (!empty($arCSV[$item]['icon'])) {
				if (!in_array($arCSV[$item]['icon'], $iconNames)) {
					$iconID = DLStoreLocator::addIcon(array(
						'name' => $arCSV[$item]['icon'],
						'src' => $icons[0]['src'],
						'infobox_color' => $icons[0]['infobox_color']
					));
					$iconNames[$iconID] = $arCSV[$item]['icon'];
					$arCSV[$item]['icon'] = $iconID;
				} else {
					$arCSV[$item]['icon'] = array_search($arCSV[$item]['icon'], $iconNames);
				}
			} else {
				$arCSV[$item]['icon'] = $icons[0]['id'];
			}

			if (!empty($arCSV[$item]['latitude']) && !empty($arCSV[$item]['longitude'])) {
				$arCSV[$item]['coordinates'] = $arCSV[$item]['latitude'] . ',' . $arCSV[$item]['longitude'];
				unset($arCSV[$item]['latitude']);
				unset($arCSV[$item]['longitude']);
			}

			$arImportCSV[] = DLStoreLocator::addItem($arCSV[$item]);
		}

		if (!empty($arImportCSV)) {
			return count($arImportCSV);
		} else {
			return false;
		}
	}
}

DLCSVImport::init();

?>