<div class="dl-togglable-panel" ng-class="options.infobox_hide_itemlist_help ? 'dl-togglable-panel__closed' : 'dl-togglable-panel__active'">
	<div class="dl-togglable-panel-toggler"  ng-click="togglePanel()">{{ options.infobox_hide_itemlist_help ? l10n.showHelp : l10n.hideHelp}}</div>
	<div class="dl-togglable-panel-content"  ng-bind-html="l10n.itemsHelp">
		{{l10n.itemsHelp}}
	</div>
</div>
<div ng-controller="PreviewCtrl" class="dl-itembox-container">
    <h3 ng-click="showPreview = !showPreview" style="cursor:pointer;">{{l10n.Preview}}</h3>
    <div ng-show="showPreview">
        <div class="inside" style="float:left;">
            {{l10n.Section}}:
            <select
                name="previewSection"
                id="previewSection"
                ng-options="section.id as section.name for (id, section) in sections"
                ng-model="preview.section_id"
            >
                <option value=""></option>
            </select>
        </div>
        <div class="inside" style="float:left;">
            {{l10n.Type}}:
            <select
                name="previewType"
                id="previewType"
                ng-options="icon.id as icon.name for (id, icon) in icons"
                ng-model="preview.icon"
            >
                <option value=""></option>
            </select>
        </div>
        <div class="inside" style="float:left;">
            {{l10n.Shortcode}}:
            <input type="text" ng-model="shortcode" style="width: 400px;" ng-disabled="1">
        </div>
        <div style="clear: both"></div>
        <div class="inside">
            <a ng-href="{{url}}" colorbox='{"iframe":true,"width":1000,"height":700}' class="button" ng-click="previewShow()">{{l10n.Preview}}</a>
        </div>
    </div>
</div>
<div class="dl-itembox-container">
    <h3>Search filter</h3>
	<div class="inside" style="float:left;">
        {{l10n.Title}}: <input type="text" style="width: 200px;" ng-model="filter.name" ng-keypress="search($event)">
	</div>
	<div class="inside" style="float:left;">
        {{l10n.Section}}:
		<select
			name="filterSection"
			id="filterSection"
			ng-options="section.id as section.name for (id, section) in sections"
			ng-model="filter.section_id"
		>
			<option value=""></option>
		</select>
	</div>
	<div class="inside" style="float:left;">
        {{l10n.Type}}:
		<select
			name="filterType"
			id="filterType"
			ng-options="icon.id as icon.name for (id, icon) in icons"
			ng-model="filter.icon"
		>
			<option value=""></option>
		</select>
	</div>
	<div style="clear: both"></div>
	<div class="inside">
		<input type="button" class="button button-primary" value="{{l10n.Search}}" ng-click="search()">
		<input type="button" class="button" value="{{l10n.Clear}}" ng-click="clear()">
	</div>
</div>
<table class="widefat">
	<thead>
		<tr>
			<th style="width: 30px;">{{l10n.ID}}</th>
			<th>{{l10n.Title}}</th>
			<th>{{l10n.Section}}</th>
			<th>{{l10n.Address}}</th>
			<th>{{l10n.Type}}</th>
			<th>{{l10n.Image}}</th>
		</tr>
	</thead>
	<tbody>
		<tr ng-repeat="item in filterItems | orderBy : 'sort' | page : pagination.cur : pagination.count as results">
			<td>{{item.id}}</td>
			<td class="post-title">
				<strong>{{item.name}}</strong>
				<div class="row-actions">
					<span class="edit"><a title="{{l10n.EditThisItem}}" ng-href="#/item/edit/{{item.id}}">{{l10n.Edit}}</a> | </span>
					<span class="trash"><a class="submitdelete" title="{{l10n.DeleteThisItem}}" ng-click="deleteItem(item.id)">{{l10n.Delete}}</a></span>
				</div>
			</td>
			<td>{{sections[item.section_id].name}}</td>
			<td>{{item.address}}</td>
			<td  class="dl-itemlist-icon-wrap"><img ng-src="{{icons[item.icon].showIcon}}" alt="" class="dl-itemlist-icon" /></td>
			<!-- <td>{{icons[item.icon].name}}</td> -->
			<td><img ng-show="item.showImage" ng-src="{{item.showImage}}" alt="" style="height: 60px;" /></td>
		</tr>
	</tbody>
</table>

<div class="tablenav bottom">
	<pagination cur="pagination.cur" total="pagination.total" display="10" count="items.length" l10n="l10n"></pagination>
</div>