(function($) {
    "use strict";

function checkOverlaping(destroyLast) {
		
    var res = jQuery('#drawingboard .element').overlaps();
			
    if (destroyLast)
        if (res.length > 0) {
            res.last().remove();
            alert('You are not allowed to place an element over other element !');
        }
			
    return (res.length > 0);
		
}	

jQuery.fn.sortElements = (function(){
 
    var sort = [].sort;
 
    return function(comparator, getSortable) {
 
        getSortable = getSortable || function(){
            return this;
        };
 
        var placements = this.map(function(){
 
            var sortElement = getSortable.call(this),
            parentNode = sortElement.parentNode,
 
            // Since the element itself will change position, we have
            // to have some way of storing its original position in
            // the DOM. The easiest way is to have a 'flag' node:
            nextSibling = parentNode.insertBefore(
                document.createTextNode(''),
                sortElement.nextSibling
                );
 
            return function() {
 
                if (parentNode === this) {
                    throw new Error(
                        "You can't sort elements if any one is a descendant of another."
                        );
                }
 
                // Insert before flag:
                parentNode.insertBefore(this, nextSibling);
                // Remove flag:
                parentNode.removeChild(nextSibling);
 
            };
 
        });
 
        return sort.call(this, comparator).each(function(i){
            placements[i].call(getSortable.call(this));
        });
 
    };
 
})();


jQuery.fn.allData = function() {
    var intID = jQuery.data(this.get(0));
    return(jQuery.cache[intID]);
};

// implement JSON.stringify serialization
JSON.stringify = JSON.stringify || function (obj) {
    var t = typeof (obj);
    if (t != "object" || obj === null) {
        // simple data type
        if (t == "string") obj = '"'+obj+'"';
        return String(obj);
    }
    else {
        // recurse array or object
        var n, v, json = [], arr = (obj && obj.constructor == Array);
        for (n in obj) {
            v = obj[n];
            t = typeof(v);
            if (t == "string") v = '"'+v+'"';
            else if (t == "object" && v !== null) v = JSON.stringify(v);
            json.push((arr ? "" : '"' + n + '":') + String(v));
        }
        return (arr ? "[" : "{") + String(json) + (arr ? "]" : "}");
    }
};

jQuery.fn.outerHTML = function(s) {
    return s
    ? this.before(s).remove()
    : jQuery("<p>").append(this.eq(0).clone()).html();
};	

function resetBoard() {
    jQuery('#drawingboard').empty();
    
    
    $('.row-settings').removeData();
    
}

function loadBoard() {
		
    $ = jQuery;
		
    $('#drawingbackground, #toolbox').animate({
        opacity: 0.25
    }, 100);
		
    resetBoard();
			
    var data = {
        action : 'load-board',
        page: jQuery('#currentpage').val()
    }


			
    jQuery.post(ajaxurl, data, function(response) {
				
        new_id = 1000;
				
        if (response.board)
				
               
                
            jQuery.each(response.board, function (index, element) {			

            
            
            if (element.rowSettings) {
                        var rowNo = element.row;
                        
                         jQuery.each(element.rowSettings, function (index1, element1) {
									
                            if (index1.indexOf('.') == -1)
                                if (index1 != 'draggable')
                                    if (index1 != 'resizable') {
                                        $('#row' + rowNo).data(index1, element1);
                                    }
                        });							
								
                    }		
            
            
            
						
                jQuery.each(element.elements, function (index2, element2) {			
							
                    var html = element2.html;
                    html = html.replace(/\\\"/g,"\"");
                    html = html.replace(/\\\'/g,"\'");
							
                    jQuery('#drawingboard').append(html);
							
                    var last = jQuery('#drawingboard .element').last();
				
	
                    new_id += 1;
							
                    if (element2.data) {
								
                        jQuery.each(element2.data, function (index3, element3) {
                            html = element3;
                            html = html.replace(/\\\"/g,"\"");
                            html = html.replace(/\\\'/g,"\'");
									
                            if (index3.indexOf('.') == -1)
                                if (index3 != 'draggable')
                                    if (index3 != 'resizable') {
                                        last.data(index3, html);
                                    }
                        });
								
								
								
                    }		

                });
                
						
            });	

        setupElements();
					
        $('#drawingbackground, #toolbox').animate({
            opacity: 1
        }, 100);
				
    });
	
}
		

function saveBoard( pagename, isPreview ) {
    $ = jQuery;

    $('#drawingbackground, #toolbox').animate({
        opacity: 0.25
    }, 100);
			
    var drawingboard = [];


			
    $('#drawingboard .element').sortElements(function(a, b){
				
        if ($(a).position().top > $(b).position().top) {
            if ($(a).position().left > $(b).position().left) {
                return 1;
            }
            else
                return -1;
        }
        else
        {
            if ($(a).position().left > $(b).position().left) {
                return 1;
            }
            else
            {
                return -1;
            }
			
        }
    });			
				
				
    var lastrow = -1;
				
    var c = 0;
				
    for (y = 0; y < 100; y++) {
				
        var s = [];
        var z = [];
				
        $('#drawingboard .element').each(function (index, element) {
					
            if (y == Math.round(jQuery(this).position().top / 40)) {
					
                jQuery(this).resizable("destroy");
                jQuery(this).draggable("destroy");
							
                c += 1;
			
                jQuery(this).attr('id', 'element' + c);
							
							
                var mydata = { };
                if (jQuery(this).data()) {
                    mydata = jQuery(this).data();
                    delete mydata.resizable;
                }
							
                z.push({
                    id: jQuery(this).attr('id'),
                    columnWidth: Math.round(jQuery(this).width() / 240) * 3,
                    columnStart: Math.round((jQuery(this).position().left) / 240) * 3,
                    row: Math.round((jQuery(this).position().top) / 40),
                    html: jQuery(this).outerHTML(),
                    typeName: jQuery(this).attr('rel'),					
                    data: mydata
                });
						
            }
						
        });
					
        if (z.length > 0) 
        {
            
            rowNo = y;
            
            var rowSettings = { };
            if ($('#row' + rowNo).data()) {
                rowSettings = $('#row' + rowNo).data();
            }
            
            drawingboard.push({
                row: y,
                elements: z,
                rowSettings: rowSettings
            });
        }

    }
			

            
    var data = {
        action: 'save-board',
        board: drawingboard,
        page: pagename
    };
			
    // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data: data,
        success: function(response) {

            $('#drawingbackground, #toolbox').animate({
                opacity: 1
            }, 100);
					
            if (isPreview) {
                window.open($('#beopen-homepage').attr('href'), '_blank');
            }
            else
            {
                if (!$("#currentpage option[value='" + response.slug + "']").length) {

                    $("#currentpage").append('<option value="'+response.slug+'">' + response.name + '</option>');
                    $("#currentpage").val(response.slug);
                }
               
            }
            
            setupElements();
            
        },
        async: false				
    });			
			
	

}
		

function renameBoard( oldpagename, newpagename ) {

    $ = jQuery;

    var data = {
        action: 'rename-board',
        page: oldpagename,
        newpage: newpagename
    };
			
    // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
    $.post(ajaxurl, data, function(response) {
        
        $("#currentpage option[value='" + jQuery('#currentpage').val() + "']").val(response.slug);
        $("#currentpage option[value='" + jQuery('#currentpage').val() + "']").text(newpagename);
				
    });			
			
}		

function duplicateBoard( oldpagename, newpagename ) {

    $ = jQuery;

    var data = {
        action: 'duplicate-board',
        page: oldpagename,
        newpage: newpagename
    };
			
    // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
    $.post(ajaxurl, data, function(response) {
        console.log(response);
        $("#currentpage").append('<option value="'+response.slug+'">' + newpagename + '</option>');
				
    });			
			
}		

		
function deleteBoard( pagename ) {
		
    $ = jQuery;

    var data = {
        action: 'delete-board',
        page: pagename
    };

			
    jQuery.post(ajaxurl, data, function(response) {
				
        $("#currentpage option[value='" + jQuery('#currentpage').val() + "']").remove();
				
        $("#currentpage").val(0);
    });			
			
}		


function checkOverlap() {
		
    jQuery('div.level1').each( function(index, element) {
        jQuery(element).removeClass('overlapped');
    });
		
    res = jQuery('div.level1').overlaps();
    if (res.length > 0) {
        res.each(function(index, element) {	
            jQuery(element).addClass('overlapped');
        });
    }
		
}
		
function setupElements() {
    $ = jQuery;
	var wide;	

    $('#drawingboard').disableSelection();
		
    $('#drawingboard .element').each(function (i, el) {
			
		
        var s = $(el).find('.element-title').text();			
        s = s.replace(/\s+/g, '_');
			
        s = s.toLowerCase();
			
			
        $(el).attr('rel', s);
			
        if ($(el).find('.element-text').length > 0) {
            
        }
        else
        {
            $('<div class="element-text"></div>').insertAfter($(el).find('.element-title'));
        }
            
            
        $(el).find('.element-text').text($(el).data('headline'));
            
        $(this).resizable({
            grid: [240, 40],
            containment: 'parent',
            handles: 'e, w',
            minWidth: 240,
            maxWidth: 960
            ,
					

            start: function(event, ui) {					
                $(this).data('original_classes', $(this).attr('class'));
                $(this).data('original_width', $(this).css('width'));
                $(this).data('original_left', $(this).css('left'));
						
                $(this).css('opacity', '0.5');
						
            },
            resize: function(event, ui) {
						
                if (checkOverlaping(false)) {
                }
                else
                {
                }
                
                if (ui.position.left >= 0) {
                    wide = Math.min(4 - Math.round(ui.position.left / 240), Math.round(ui.size.width / 240));
								
                    $(this).removeClass('wide1')
                    .removeClass('wide2').removeClass('wide3').
                    removeClass('wide4').addClass('wide' + wide);
                }
						
						
            },
            stop: function(event, ui) {
                $(this).css('opacity', '1');
						
                if (checkOverlaping(false)) {
                    $(this).attr('class', $(this).data('original_classes'));
                    $(this).css('width', $(this).data('original_width'));
                    $(this).css('left', $(this).data('original_left'));
                }
                else
                {
                    if (ui.position.left >= 0) {
                        wide = Math.min(4 - Math.round(ui.position.left / 240), Math.round(ui.size.width / 240));
							
							
                        $(this).removeClass('wide1')
                        .removeClass('wide2').removeClass('wide3').
                        removeClass('wide4').addClass('wide' + wide);
                    }
							
							
					
                }
						
            }
					
					
        });			
			
    });
		
		
    $('#drawingboard .element').draggable({ 
        containment: 'parent', 
        grid: [ 240, 40 ], 
        //snap: '#drawingboard',
        //snapMode: 'inner',
        //snapTolerance: 20,
        //helper: '',
        opacity: 0.5,
        cancel: ".element-settings,.element-close",
        start: function(event, ui) {
					
            $(this).data('original_left', $(this).css('left'));
            $(this).data('original_top', $(this).css('top'));
						
        },
					
					
        drag: function(event, ui) {

            ui.position.top = Math.floor(ui.position.top / 40) * 40;

        },
					
		
        stop: function(event, ui) {
						
            if (checkOverlaping(false)) {
                $(this).css('left', $(this).data('original_left'));
                $(this).css('top', $(this).data('original_top'));
            }
            else
            {
							
            }
        }

    });
								
		
				
				
    $('#drawingboard .element .element-close').off().click(function() {
        $(this).parent().remove();
    });
				
				
    $('#drawingboard .element .element-settings').off().click(function() {
						
        var rel = $(this).parent().attr('rel');
						
        var data = {
            action : 'load-'+rel+'-settings',            
            pageId: jQuery('#currentpage').val(),
            elementId: $(this).parent().attr('id'),
            elementType: rel
        }
							
        jQuery.post(ajaxurl, data, function(response) {
            

            
            jQuery( "#dialog-modal" )
            .dialog({
                title: 'Settings',
                zIndex: 20,
                width: 700,
                
                height: Math.round($(window).height() * 0.8),
                modal: true,
                autoOpen: false,
                buttons: [
                    
                    { text: "Apply", click: function() { 
                        $( this ).dialog( "close" ); 
                            
                        elementId = $('#form-settings #elementId').val();

                        $('form input:text').each(function(index, element) {
                            $('#' + elementId).data($(element).attr('name'), $(element).val());
                        });																

                        $('form select, form textarea').each(function(index, element) {
                            $('#' + elementId).data($(element).attr('name'), $(element).val());
                        });			

                        $('form input:radio:checked').each(function(index, element) {
                            $('#' + elementId).data($(element).attr('name'), $(element).val());
                        });			

                        $('#' + elementId).find('.element-text').text($('#' + elementId).data('headline'));
                            
                        jQuery( "#dialog-modal" ).dialog("close");
                        
                        
                                             
                        } 
                    },
                    { text: 'Cancel', click: function() { 
                        $( this ).dialog( "close" ); 
                        } 
                    }
                    
                    
                ]
								  
            });					
						
                        
                        
            jQuery( "#dialog-modal" ).html(response);
            jQuery( "#dialog-modal" ).dialog('open');
			
            jQuery( "#dialog-modal" ).dialog( "option", "title", $('#' + $('#form-settings #elementId').val()).find('.element-title').html() + ' Settings' );
                                
            
									
            $.each( $('#' + $('#form-settings #elementId').val()).data(),function(i, el) {

										
                if (i.indexOf('.') == -1)
                    if (typeof el != 'object') {									  
                        jQuery('*[name="'+i+'"]').val(el);
                    }  
									  
            });
									
			
			$('.beopen_no_picture').click(function() {
               $(this).parent().find('.beopen_upload_input').val('');
            });
            
			$('#form-settings input, #form-settings select').keypress(function(event) { return event.keyCode != 13; });
			


									
								

							
        });
						
    });				

}		
	
var canSomething = false;
var isDownSub = false;
var overSubDiv = false;
var isResizing = false;
var isAnimated = false;
var elementId = '';

var idDiv = 0;
var isDown = false;
		
var isBox = false;
		
var overDiv = false;
		
		
var downX = 0;
var downY = 0;		
	
var new_id = 0;
var currentpage = '';	
var y = 0;
var rowNo = '';

jQuery(document).ready(function($) {



	
    $('.delete-template').hide();
    $('.rename-template').hide();
	
    $ = jQuery;
		
    $( "#toolbox" ).tabs();
		
    $( "#toolbox .element" ).draggable({
        appendTo: "body",
        helper: "clone"
    });
	
		
		
    $( "#drawingboard" ).droppable({
            
        accept: ":not(.ui-dialog)",
			
        drop: function( event, ui ) {
			 
            if (ui.draggable.parent().attr('id') != 'drawingboard') {
                new_id += 1;
				
                $(ui.draggable.outerHTML())
                .attr('id', 'element' + new_id)
                .appendTo(this);
					
					
                var _left = ui.position.left - $(this).offset().left;
                var _top = ui.position.top - $(this).offset().top;
					
                _left = Math.round(_left / 240, 0) * 240;
                _top = Math.round(_top / 40, 0) * 40;
					
					
                $(this).children().last().css('left', _left + 'px');
                $(this).children().last().css('top', _top + 'px');
					
                checkOverlaping(true);
            }
            else
            {	
                ui.draggable.appendTo(this);
            }
				

            setupElements();

				
        }
    })		
		
			
    $('.save-changes').click(function () {
        
        if (jQuery('#currentpage').val() == '0') {
            currentpage=prompt("Enter a name for this template:","");
        }
        else
        {
            currentpage=$("#currentpage option[value='" + $('#currentpage').val() + "']").text();
        }
				
        if (currentpage) {
            saveBoard(currentpage, false);
            $('.delete-template').show();
            $('.rename-template').show();
        }
				
    });
			
			
    $('.rename-template').click(function() {
			
        currentpage = $("#currentpage option[value='" + $('#currentpage').val() + "']").text();
        var renamedPage=prompt("Enter a name for this template:",currentpage);
				
        if (renamedPage) {
            renameBoard(currentpage, renamedPage);
        }
				
    });
    
    $('.duplicate-template').click(function() {
			
        currentpage = $("#currentpage option[value='" + $('#currentpage').val() + "']").text();
        var duplicatePage=prompt("Enter the new name for template:",currentpage);
				
        if (duplicatePage) {
            duplicateBoard(currentpage, duplicatePage);
        }
				
    });    
			
    jQuery('.delete-template').click(function() {
        currentpage=$("#currentpage option[value='" + $('#currentpage').val() + "']").text();
        
        if (confirm('Are you sure you want to delete this template ?')) {
			deleteBoard(currentpage);
            $('#currentpage').val(0);
            $('#currentpage').trigger('change');
        }
        else
        {
            
        }
    });			
			
			
    $('#currentpage').change(function (obj) {
        if ($('#currentpage').val() != 0) {
            loadBoard();
            $('.delete-template').show();
            $('.rename-template').show();
            $('.duplicate-template').show();
        }
        else
        {
            resetBoard();
            $('.duplicate-template').hide();
            $('.delete-template').hide();
            $('.rename-template').hide();
        }
    });

    jQuery( "#dialog:ui-dialog" ).dialog( "close" );
			
    $('#toppanel .preview').click(function(e) {
			
        saveBoard('beopen-template-preview', true);
				
        e.preventDefault();
        return false;
			
				
				
				
    });
			
		
    // BUG FIX
    $('#toolbox .element').each(function (i, el) {
		
        var s = $(el).find('.element-title').text();			
        s = s.replace(/\s+/g, '_');
			
        s = s.toLowerCase();
			
        $(el).attr('rel', s);
    });			
    
    
    $('.tooltip').tipsy({
        gravity: 'nw', 
        opacity: '1', 
        html: true
    });
    
    var picker;
    
    $('.row-settings').off('click').click(function () {
 
       var rowId = $(this).attr('id');
       var rowNo = rowId.replace('row', '');
       rowNo = parseInt(rowNo) + 1;
                            
       
        
						
        var data = {
            action : 'load-row-settings',
            pageId: jQuery('#currentpage').val(),
            rowId: $(this).attr('id')
        }
        
							
        jQuery.post(ajaxurl, data, function(response) {
						
            jQuery( "#dialog-modal" )
            .dialog({
                title: 'Row ' + rowNo + ' Settings',
                zIndex: 20,
                width: 700,
                height: Math.round($(window).height() * 0.8),
                modal: true,
                autoOpen: false,
                buttons: [
                    
                    { text: "Apply", click: function() { 
                        $( this ).dialog( "close" ); 
                        
                        
                        $('form input:text').each(function(index, element) {
                            row.data($(element).attr('name'), $(element).val());
                        });																

                        $('form select, form textarea').each(function(index, element) {
                            row.data($(element).attr('name'), $(element).val());
                        });			

                        $('form input:radio:checked').each(function(index, element) {
                            row.data($(element).attr('name'), $(element).val());
                        });			
                      
                        } 
                    },
                    { text: 'Cancel', click: function() { 
                        $( this ).dialog( "close" ); 
                        } 
                    }
                    
                    
                ],                
                open: function (event, ui) {
                    
                }
                
            });	                        
                        
            
                        
            $( "#dialog-modal" ).html(response);

            
            $( "#dialog-modal").dialog('open');
            
            rowId = $('#form-settings #rowId').val();
            
            $('.beopen_no_picture').click(function() {
               $(this).parent().find('.beopen_upload_input').val('');
            });
            
	                        
           
           var row = $('#' + rowId);
           

           
           
            $.each( row.data(),function(i, el) {
										
                if (i.indexOf('.') == -1)
                    if (typeof el != 'object') {									  
                        jQuery('*[name="'+i+'"]').val(el);
                    }  
									  
            });           
            
            $('.beopen-color-picker').each(function (i, e) {
                
                var id_picker = '#' + $(e).attr('id');
                
                var id_field = id_picker.replace('Picker', '');
                
                

                $(id_picker).farbtastic(function() {
                   
                    id_field = $(this)[0].id_field;
                    id_picker = $(this)[0].id_picker;
                    
                    if (id_field) {
                        $(id_field).css("background-color",$.farbtastic(id_picker).color);
                        $(id_field).val($.farbtastic(id_picker).color);
                    }
                    
                });


                picker = $.farbtastic(id_picker);
                
                picker.id_field = id_field;
                picker.id_picker = id_picker;                
                
                picker.setColor($(id_field).val());

                
            });

							
        });

       
       
    });

    $('#mainboard').attr('style', '');

});


})(jQuery); 