<?php
require_once( ABSPATH . WPINC . '/class-wp-customize-control.php' );

class WP_Customize_BeOpen_Control extends WP_Customize_Control {

    public $type = 'beopen';
    public $statuses;

    public function __construct($manager, $id, $args = array()) {
        $this->statuses = array('' => __('Default', 'beopen'));
        parent::__construct($manager, $id, $args);
    }

    public function to_json() {
        parent::to_json();
        $this->json['statuses'] = $this->statuses;
    }

    public function render_content() {

        if (in_array($this->type, array('font'))) {
            ?>
            <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>

            <div class="customize-control-content">
                <?php beopen_show_field(array('name' => $this->id, 'type' => $this->type, 'value' => esc_attr($this->value())), true); ?>
            </div>
            <?php
        }
        else
            parent::render_content();
    }

}

class WP_Customize_BeOpen_Color_Control extends WP_Customize_Color_Control {

    public $type = 'color';
    public $statuses;

    public function render_content() {
        ?>
        <label>
            <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
            <div class="customize-control-content">
                <div class="dropdown">
                    <div class="dropdown-content">
                        <div class="dropdown-status"></div>
                    </div>
                    <div class="dropdown-arrow"></div>
                </div>
                <input class="color-picker-hex" type="text" maxlength="7" value="" />
            </div>
            <div class="farbtastic-placeholder"></div>
        </label>
        <?php
    }

}

class BeOpenCustomizerOptions {

    /**
     * Registers the settings with WordPress.
     * 
     * Used by hook: 'customize_register'
     * 
     * @see add_action('customize_register',$func)
     * @param WP_Customize_Manager $wp_customize
     */
    public static function register($wp_customize) {
        global $optionPages;



        if ($wp_customize->is_preview()) {

            require_once(ABSPATH . '/wp-admin/includes/file.php');
            WP_Filesystem();
            global $wp_filesystem;
            require_once THEME_DIR . '/beopen_framework/extra/lessc.inc.php';

            $predefined_less = $wp_filesystem->get_contents(THEME_DIR . '/css/skins/predefined.less');

            $predefined_a = explode(PHP_EOL, $predefined_less);
            foreach ($predefined_a as $bo_css_rule) {
                $bo_a_rule = explode(':', $bo_css_rule);
                $bo_variablename = substr($bo_a_rule[0], 1);

                if (trim($bo_variablename)) {
                    $less = new lessc;
                    $bo_to_process = $bo_css_rule . PHP_EOL;

                    $bo_to_process .= $bo_variablename . ' { value: @' . $bo_variablename . '; }' . PHP_EOL;

                    $bo_processed = $less->compile($predefined_less . PHP_EOL . $bo_to_process);

                    $bo_processed = explode(';', $bo_processed);
                    $bo_processed = explode('{', $bo_processed[0]);

                    if (trim(substr($bo_processed[1], 9))) {
                        $less_variables[trim($bo_processed[0])] = trim(substr($bo_processed[1], 9));
                    }

                    unset($less);
                }
            }
        }



        $priority = 0;
        $field_priority = 0;
        foreach ($optionPages as $page_slug => $optionPage) {
            $priority += 1;
            $wp_customize->add_section($page_slug, array(
                'title' => $optionPage['title'],
                'priority' => $priority,
            ));

            $fields = $optionPage['fields'];

            foreach ($fields as $field) {



                if (isset($field['customizer']) && ($field['customizer'])) {




                    $field_priority += 10;


					if (is_array($field['type'])) {
						
                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'type' => 'radio',
                                'label' => $field['label'],
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority,
                                'choices' => $field['type']
                            )));
							
					}
					else					
                    switch ($field['type']) {

                        case 'font':

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $default = '';
                            if (isset($field['default']['name'])) {
                                $default = '';
                            }

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_name', array(
                                'default' => $default,
                                'type' => 'option'
                            ));

                            $default = '';
                            if (isset($field['default']['size'])) {
                                $default = '';
                            }

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_size', array(
                                'default' => $default,
                                'type' => 'option'
                            ));

                            $default = '';
                            if (isset($field['default']['style'])) {
                                $default = '';
                            }

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_style', array(
                                'default' => $default,
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_BeOpen_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'label' => $field['label'],
                                'type' => $field['type'],
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority
                            )));

                            break;

                        case 'skin_selector':

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'label' => $field['label'],
                                'type' => 'radio',
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority,
                                'choices' => array(
                                    'blue_green' => __('Blue Green', 'beopen'),
                                    'orange_red' => __('Orange Red', 'beopen'),
                                    'dark_blue' => __('Dark Blue', 'beopen'),
                                ),
                            )));

                            break;


                        case 'color':

                            $beopen_default = $field['default'];
                            if (isset($less_variables[$field['name']])) {
                                $beopen_default = $less_variables[$field['name']];
                            }

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $beopen_default,
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'label' => $field['label'],
                                'type' => $field['type'],
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority
                            )));


                            break;

                        case 'background':



                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'label' => $field['label'],
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority
                            )));

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_position', array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'] . '_position', array(
                                'section' => $page_slug,
                                'label' => $field['label'] . ' Position',
                                'type' => 'radio',
                                'choices' => array(
                                    'left top' => __('Left Top', 'beopen'),
                                    'left center' => __('Left Center', 'beopen'),
                                    'left bottom' => __('Left Bottom', 'beopen'),
                                    'center top' => __('Center Top', 'beopen'),
                                    'center center' => __('Center Center', 'beopen'),
                                    'center bottom' => __('Center Bottom', 'beopen'),
                                    'right top' => __('Right Top', 'beopen'),
                                    'right center' => __('Right Center', 'beopen'),
                                    'right bottom' => __('Right Bottom', 'beopen')
                                ),
                                'settings' => FIELD_PREFIX . $field['name'] . '_position',
                                'priority' => $field_priority + 1
                            )));

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_repeat', array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'] . '_repeat', array(
                                'section' => $page_slug,
                                'label' => $field['label'] . ' Repeat',
                                'type' => 'radio',
                                'choices' => array(
                                    'no-repeat' => __('No Repeat', 'beopen'),
                                    'repeat' => __('Tile', 'beopen'),
                                    'repeat-x' => __('Tile Horizontally', 'beopen'),
                                    'repeat-y' => __('Tile Vertically', 'beopen')
                                ),
                                'settings' => FIELD_PREFIX . $field['name'] . '_repeat',
                                'priority' => $field_priority + 2
                            )));

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'] . '_attachment', array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'] . '_attachment', array(
                                'section' => $page_slug,
                                'label' => $field['label'] . ' Attachment',
                                'type' => 'radio',
                                'choices' => array(
                                    'scroll' => __('Scroll', 'beopen'),
                                    'fixed' => __('Fixed', 'beopen')
                                ),
                                'settings' => FIELD_PREFIX . $field['name'] . '_attachment',
                                'priority' => $field_priority + 3
                            )));


                            $field_priority += 2;

                            break;

                        case 'onoff':

                            $wp_customize->add_setting(FIELD_PREFIX . $field['name'], array(
                                'default' => $field['default'],
                                'type' => 'option'
                            ));

                            $wp_customize->add_control(new WP_Customize_Control($wp_customize, FIELD_PREFIX . $field['name'], array(
                                'section' => $page_slug,
                                'type' => 'radio',
                                'label' => $field['label'],
                                'settings' => FIELD_PREFIX . $field['name'],
                                'priority' => $field_priority,
                                'choices' => array(
                                    'off' => __('Off', 'beopen'),
                                    'on' => __('On', 'beopen')
                                ),
                            )));
							
                            break;
						
                    }
                }
            }
        }
    }

    /**
     * This will output the custom WordPress settings to the theme's WP head.
     * 
     * Used by hook: 'wp_head'
     * 
     * @see add_action('wp_head',$func)
     */
    public static function render() {

        global $beopen_option_update;
        global $wp_customize;

        $beopen_customizer_preview = (isset($wp_customize)) && ($wp_customize->is_preview());

        global $allfonts;
        global $optionPages;



        $includes = array(false => '', true => '');
        $css = array(false => '', true => '');





        $variables = array();


        foreach ($optionPages as $page_slug => $optionPage) {

            $fields = $optionPage['fields'];

            foreach ($fields as $field) {


                if (isset($field['customizer'])) {
                    $fieldCustomizer = $field['customizer'];
                }
                else
                    $fieldCustomizer = false;

                if ((isset($field['css'])) && $field['css']) {

                    if ($field['type'] == 'font') {
                        $value = get_option(FIELD_PREFIX . $field['name'] . '_name');

                        $css_line = '';

                        if ($value) {
                            if (!isset($allfonts[$value]['standard']) || ($allfonts[$value]['standard'] != 'yes')) {

                                $includes[$fieldCustomizer] .= '<link href="http://fonts.googleapis.com/css?family=' . $allfonts[$value]['include'] . '" rel="stylesheet" type="text/css" />' . PHP_EOL;

                                $css_line .= " font-family: '$value'; ";
                            } else {
                                $css_line .= " font-family: '$value'; ";
                            }
                        }

                        $value = get_option(FIELD_PREFIX . $field['name'] . '_size');

                        if ($value) {

                            $css_line .= " font-size: " . $value . "px; ";
                        }

                        $value = get_option(FIELD_PREFIX . $field['name'] . '_style');

                        if ($value == 'normal') {
                            $css_line .= " font-style: " . $value . "; ";
                            $css_line .= " font-weight: normal; ";
                        } else
                        if ($value == 'bold') {
                            $css_line .= " font-weight: " . $value . "; ";
                        } else
                        if ($value == 'italic') {
                            $css_line .= " font-style: " . $value . "; ";
                        } else
                        if ($value == 'italic bold') {
                            $css_line .= " font-style: italic; ";
                            $css_line .= " font-weight: bold; ";
                        }


                        if ($css_line) {
                            $css[$fieldCustomizer] .= $field['css'];
                            $css[$fieldCustomizer] .= " { " . $css_line . " } ";
                        }
                    } else
                    if (in_array($field['type'], array('color', 'number'))) {
                        $value = beopen_get_option($field['name']);

                        if ($value) {
                            $variables[] = '@' . $field['name'] . ': ' . $value . ';';
                        }

                        if ($field['type'] == 'number')
                            if ($value)
                                if (trim($field['css'])) {
                                    
                                    if (is_array($field['css'])) {
                                        foreach ($field['css'] as $field_css) {
                                            if (strpos($field_css, '%') !== false) {
                                                $css[$fieldCustomizer] .= str_replace('%', $value, $field_css) . PHP_EOL;
                                            } else {
                                                $css[$fieldCustomizer] .= $field_css . $value . ' !important; }' . PHP_EOL;
                                            }
                                        }
                                    } else {
                                        $field_css = $field['css'];
                                        if (strpos($field_css, '%') !== false) {
                                            $css[$fieldCustomizer] .= str_replace('%', $value, $field_css) . PHP_EOL;
                                        } else {
                                            $css[$fieldCustomizer] .= $field_css . $value . ' !important; }' . PHP_EOL;
                                        }
                                    }
                                }
                    } else
                    if ($field['type'] == 'background') {
                        $value = get_option(FIELD_PREFIX . $field['name']);

                        if ($value)
                            if ($field['css']) {
                                $variables[] = '@' . $field['name'] . ': ' . "url('$value') " . get_option(FIELD_PREFIX . $field['name'] . '_repeat') .
                                        ' ' . get_option(FIELD_PREFIX . $field['name'] . '_position') . ' ' . get_option(FIELD_PREFIX . $field['name'] . '_attachment') . ';';
                            }
                    } else
                    if ($field['type'] == 'onoff') {

                        $value = get_option(FIELD_PREFIX . $field['name']);

                        if ($value)
                            if ($field['css']) {
                                $css[$fieldCustomizer] .= $field['css'][$value];
                            }
                    }
                }
            }
        }


        $in = THEME_DIR . '/css/skins/default.less';
        $out = THEME_DIR . '/css/skins/default.css';
        $skin_selector = get_option(FIELD_PREFIX . 'skin_selector');
        if ($skin_selector) {
            $in = THEME_DIR . '/css/skins/' . $skin_selector . '.less';
            $out = THEME_DIR . '/css/skins/' . $skin_selector . '.css';
        }


        require_once(ABSPATH . '/wp-admin/includes/file.php');
        WP_Filesystem();
        global $wp_filesystem;
        require_once THEME_DIR . '/beopen_framework/extra/lessc.inc.php';



        $beopen_refresh_css = false;


        // CHECK FOR FILES TO SEE IF SOMETHINGS CHANGED
        if (!$beopen_option_update) {

            $files = $wp_filesystem->dirlist(THEME_DIR . '/css/skins/');

            $files_to_watch_for_changes = array(
                $in,
                THEME_DIR . '/css/skins/predefined.less'
            );

            foreach ($files as $filename => $info) {
                if (pathinfo($filename, PATHINFO_EXTENSION) == 'less') {
                    $files_to_watch_for_changes[] = THEME_DIR . '/css/skins/' . $filename;
                }
            }

            if (!($wp_filesystem->is_file($out))) {
                $beopen_refresh_css = true;
            } else {
                $outmtime = $wp_filesystem->mtime($out);

                foreach ($files_to_watch_for_changes as $watched_file) {

                    if (!$beopen_refresh_css) {
                        if (!($wp_filesystem->is_file($out)) || $wp_filesystem->mtime($watched_file) > $outmtime) {
                            $beopen_refresh_css = true;
                        }
                    }
                }
            }
        }


        if ($beopen_customizer_preview) {
            $beopen_option_update = true;
        }
        
        $beopen_force_update = false;
        $beopen_options_updated = get_option('beopen_options_updated');
        if ($beopen_options_updated) {
            delete_option('beopen_options_updated');
            $beopen_force_update = true;
        }

        // UPDATE CSS FILE ONLY IF IN CUSTOMIZER OR CHANGING OPTIONS
        if ($beopen_force_update || $beopen_option_update || $beopen_refresh_css) {

            $skin_selector = get_option(FIELD_PREFIX . 'skin_selector');

            $less = new lessc;


            if ((!$beopen_force_update) && ($beopen_customizer_preview)) {

                $css[true] .= PHP_EOL . $less->compile(
                                $wp_filesystem->get_contents(THEME_DIR . '/css/skins/predefined.less') . PHP_EOL .
                                implode(PHP_EOL, $variables) . PHP_EOL .
                                $wp_filesystem->get_contents(THEME_DIR . '/css/skins/all.less')
                );
				
				$wp_filesystem->put_contents(THEME_DIR . '/css/skins/customizer.less', implode(PHP_EOL, $variables));
                
                
            } else {

                if (($beopen_force_update) || ($beopen_option_update)) {

                    if ($wp_filesystem->put_contents(THEME_DIR . '/css/skins/customizer.less', implode(PHP_EOL, $variables))) {
                        
                    }
                }

                $less->compileFile($in, $out);
            }

            unset($less);
        }


        echo $includes[false];

        echo $includes[true];
        ?>		
        <!--BEOPEN Options CSS--> 
        <style type="text/css">
        <?php
        echo $css[false];
        ?>
        </style> 
        <!--/BEOPEN Options CSS-->
        <?php
        if (get_option(FIELD_PREFIX . 'reset_colors') != 'on') {
        ?>
        <!--BEOPEN Customizer CSS--> 
        <style id="customizer-style" type="text/css">
        <?php
        echo $css[true];
        ?>
        </style> 
        <!--/BEOPEN Customizer CSS-->
        <?php
        }
    }

}


add_action('customize_register', array('BeOpenCustomizerOptions', 'register'));
add_action('wp_head', array('BeOpenCustomizerOptions', 'render'));

function beopen_on_update_option($option, $oldvalue, $_newvalue) {
    global $beopen_option_update;

    if (strpos($option, FIELD_PREFIX) !== false) {
        $beopen_option_update = true;
    }
    
    if ($option != 'beopen_options_updated') {
        if (!(get_option('beopen_options_updated'))) {
            update_option('beopen_options_updated', 1);
        }
    }
}

add_action('update_option', 'beopen_on_update_option', 10, 3);

add_action('customize_controls_enqueue_scripts', 'beopen_admin_bar');

function beopen_admin_bar() {
    wp_register_style('beopen-customizer', ADMIN_CSS . '/customizer.css');
    wp_enqueue_style('beopen-customizer');
}
?>