<?php
/* TEAM MEMBERS */

add_action('init', 'beopen_create_member');

function beopen_create_member() {
    register_post_type('team_member', array(
        'labels' => array(
            'name' => __('Our Team', 'beopen'),
            'singular_name' => __('Member', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Member', 'beopen'),
            'edit_item' => __('Edit Member', 'beopen'),
            'view_item' => __('View Member', 'beopen'),
            'search_items' => __('Search Member', 'beopen')
        ),
        'rewrite' => true,
        'menu_position' => 33,
        'public' => true,
        'has_archive' => false,
        'can_export' => true,
        'supports' => array('title', 'editor', 'thumbnail', 'page-attributes')
            )
    );
}

add_action('admin_init', 'add_custom_metabox_to_member');
add_action('save_post', 'save_custom_metabox_to_member');

function add_custom_metabox_to_member() {
    add_meta_box('custom-metabox-to-member', __('Additional Info', 'beopen'), 'member_custom_metabox', 'team_member', 'normal', 'high');
}

function member_custom_metabox() {
    global $post;
    $member_size = get_post_meta($post->ID, 'member_size', true);
    
    $member_job_title = get_post_meta($post->ID, 'member_job_title', true);

    $member_mail = get_post_meta($post->ID, 'member_mail', true);
    $member_url = get_post_meta($post->ID, 'member_url', true);

    $member_facebook = get_post_meta($post->ID, 'member_facebook', true);
    $member_googleplus = get_post_meta($post->ID, 'member_googleplus', true);

    $member_twitter = get_post_meta($post->ID, 'member_twitter', true);

    $member_linkedin = get_post_meta($post->ID, 'member_linkedin', true);
    $member_dribbble = get_post_meta($post->ID, 'member_dribbble', true);
    ?>

    <p><label for="member_job_title"><?php _e('Job Title', 'beopen'); ?>:<br />
            <input id="member_job_title" size="37" name="member_job_title" value="<?php if ($member_job_title) {
        echo $member_job_title;
    } ?>" /></label></p>		
    
    <p><label for="member_size"><?php _e('Member Size', 'beopen'); ?>:<br />

            <select id="member_size" name="member_size">
                <option value="0" <?php if (!$member_size) {
        print 'selected="selected"';
    } ?>><?php _e('Normal', 'beopen'); ?></option>
                <option value="big" <?php if ($member_size == 'big') {
        print 'selected="selected"';
    } ?>><?php _e('Big', 'beopen'); ?></option>
            </select>        
    </p>		            
    
    <p><label for="member_facebook"><?php _e('Facebook Account', 'beopen'); ?>:<br />
            <input id="member_facebook" size="37" name="member_facebook" value="<?php if ($member_facebook) {
        echo $member_facebook;
    } ?>" /></label></p>		
    <p><label for="member_googleplus"><?php _e('Google+ Account', 'beopen'); ?>:<br />
            <input id="member_googleplus" size="37" name="member_googleplus" value="<?php if ($member_googleplus) {
        echo $member_googleplus;
    } ?>" /></label></p>		
    <p><label for="member_twitter"><?php _e('Twitter Account:', 'beopen'); ?><br />
            <input id="member_twitter" size="37" name="member_twitter" value="<?php if ($member_twitter) {
        echo $member_twitter;
    } ?>" /></label></p>		
    <p><label for="member_linkedin"><?php _e('LinkedIn Account', 'beopen'); ?>:<br />
            <input id="member_linkedin" size="37" name="member_linkedin" value="<?php if ($member_linkedin) {
        echo $member_linkedin;
    } ?>" /></label></p>		
    <p><label for="member_dribbble"><?php _e('Dribbble Account', 'beopen'); ?>:<br />
            <input id="member_dribbble" size="37" name="member_dribbble" value="<?php if ($member_dribbble) {
        echo $member_dribbble;
    } ?>" /></label></p>		
    <p><label for="member_mail"><?php _e('Contact Mail', 'beopen'); ?>:<br />
            <input id="member_mail" size="37" name="member_mail" value="<?php if ($member_mail) {
        echo $member_mail;
    } ?>" /></label></p>		
    <p><label for="member_url"><?php _e('Personal Web Page', 'beopen'); ?>:<br />
            <input id="member_url" size="37" name="member_url" value="<?php if ($member_url) {
        echo $member_url;
    } ?>" /></label></p>				


    <?php
}

function save_custom_metabox_to_member() {
    global $post;

    if (get_post_type() == 'team_member')
        if ($_POST) {
            update_post_meta($post->ID, 'member_job_title', $_POST['member_job_title']);
            update_post_meta($post->ID, 'member_facebook', $_POST['member_facebook']);
            update_post_meta($post->ID, 'member_linkedin', $_POST['member_linkedin']);
            update_post_meta($post->ID, 'member_twitter', $_POST['member_twitter']);
            update_post_meta($post->ID, 'member_googleplus', $_POST['member_googleplus']);
            update_post_meta($post->ID, 'member_dribbble', $_POST['member_dribbble']);
            update_post_meta($post->ID, 'member_mail', $_POST['member_mail']);
            update_post_meta($post->ID, 'member_url', $_POST['member_url']);
            update_post_meta($post->ID, 'member_size', $_POST['member_size']);
        }
}

/* CLIENTS */

add_action('init', 'beopen_create_client');

function beopen_create_client() {
    register_post_type('client_item', array(
        'labels' => array(
            'name' => __('Clients', 'beopen'),
            'singular_name' => __('Client', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Client', 'beopen'),
            'edit_item' => __('Edit Client', 'beopen'),
            'view_item' => __('View Client', 'beopen'),
            'search_items' => __('Search Clients', 'beopen')
        ),
        'rewrite' => true,
        'menu_position' => 32,
        'public' => true,
        'has_archive' => false,
        'can_export' => true,
        'supports' => array('title', 'thumbnail')
            )
    );
}

add_action('admin_init', 'add_custom_metabox_to_client');
add_action('save_post', 'save_custom_metabox_to_client');

function add_custom_metabox_to_client() {
    add_meta_box('custom-metabox-to-client', __('Additional Info', 'beopen'), 'client_custom_metabox', 'client_item', 'normal', 'high');
}

function client_custom_metabox() {
    global $post;
    $client_url = get_post_meta($post->ID, 'client_url', true);
    ?>
    <p><label for="client_url"><?php _e('Client Url', 'beopen'); ?>:<br />
            <input id="client_url" size="37" name="client_url" value="<?php if ($client_url) {
        echo $client_url;
    } ?>" /></label></p>		
    <?php
}

function save_custom_metabox_to_client() {
    global $post;

    if (get_post_type() == 'client_item')
        if ($_POST) {
            update_post_meta($post->ID, 'client_url', $_POST['client_url']);
        }
                
}

add_filter('manage_edit-client_item_columns', 'set_custom_edit_client_item_columns');
add_action('manage_client_item_posts_custom_column', 'custom_client_item_column', 10, 2);

function set_custom_edit_client_item_columns($columns) {
    unset($columns['author']);
    unset($columns['date']);
    return $columns
            + array(
        'image' => __('Image', 'beopen'),
        'date' => __('Date', 'beopen')
    );
}

function custom_client_item_column($column, $post_id) {
    switch ($column) {
        case 'image':
            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                the_post_thumbnail('client-thumbnail');
            }
            break;
    }
}

/* PORTFOLIO */

add_action('init', 'beopen_create_portfolio');

function beopen_create_portfolio() {
    register_post_type('portfolio_item', array(
        'labels' => array(
            'name' => __('Portfolio Items', 'beopen'),
            'singular_name' => __('Portfolio Item', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Portfolio Item', 'beopen'),
            'edit_item' => __('Edit Portfolio Item', 'beopen'),
            'view_item' => __('View Portfolio Item', 'beopen'),
            'search_items' => __('Search Portfolio Items', 'beopen')
        ),
        'rewrite' => array('slug' => 'project'),
        'menu_position' => 29,
        'public' => true,
        'has_archive' => true,
        'can_export' => true,
        'supports' => array('title', 'editor', 'author', 'thumbnail', 'page-attributes')
            )
    );

    register_taxonomy('portfolio_tag', 'portfolio_item', array('query_var' => true, 'rewrite' => true, 'labels' => array(
        'name' => __('Portfolio Tags (for filters)', 'beopen')
    )));
    register_taxonomy('portfolio_category', 'portfolio_item', array('query_var' => true, 'rewrite' => true, 'labels' => array(
        'name' => __('Portfolio Category (for multiple portfolios)', 'beopen')
    )));
	
	
	global $filter_by_category;
	$portfolio_categories = get_terms('portfolio_category', array());

	$filter_by_category = array('' => __('All categories', 'beopen'));
    
    foreach ($portfolio_categories as $portfolio_category) {
        
        $filter_by_category[$portfolio_category->slug] = $portfolio_category->name;
    }
	

	
}

add_filter('manage_edit-portfolio_item_columns', 'set_custom_edit_portfolio_item_columns');
add_action('manage_portfolio_item_posts_custom_column', 'custom_portfolio_item_column', 10, 2);

function set_custom_edit_portfolio_item_columns($columns) {
    unset($columns['author']);
    unset($columns['date']);
    return $columns
            + array(
        'portfolio_tags' => __('Portfolio Tags', 'beopen'),
        'portfolio_category' => __('Portfolio Categories', 'beopen'),
        'image' => __('Image', 'beopen'),
        'author' => __('Author', 'beopen'),
        'date' => __('Date', 'beopen')
    );
}

function custom_portfolio_item_column($column, $post_id) {
    switch ($column) {
        case 'image':
            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                the_post_thumbnail('portfolio-thumbnail');
            }
            break;
        case 'portfolio_tags':

            $terms = get_the_term_list($post_id, 'portfolio_tag', '', ',', '');
            if (is_string($terms)) {
                echo $terms;
            } else {
                echo 'No tag attached';
            }
            break;
        case 'portfolio_category':

            $terms = get_the_term_list($post_id, 'portfolio_category', '', ',', '');
            if (is_string($terms)) {
                echo $terms;
            } else {
                echo 'No category attached';
            }
            break;            
    }
}

/* TESTIMONIALS */

add_action('init', 'beopen_create_testimonial');

function beopen_create_testimonial() {
    register_post_type('testimonial_item', array(
        'labels' => array(
            'name' => __('Testimonials', 'beopen'),
            'singular_name' => __('Testimonial', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Testimonial', 'beopen'),
            'edit_item' => __('Edit Testimonial', 'beopen'),
            'view_item' => __('View Testimonial', 'beopen'),
            'search_items' => __('Search Testimonials', 'beopen')
        ),
        'rewrite' => true,
        'menu_position' => 31,
        'public' => true,
        'has_archive' => false,
        'can_export' => true,
        'supports' => array('title', 'editor', 'thumbnail')
            )
    );
}

add_filter('manage_edit-testimonial_item_columns', 'set_custom_edit_testimonial_item_columns');
add_action('manage_testimonial_item_posts_custom_column', 'custom_testimonial_item_column', 10, 2);

function set_custom_edit_testimonial_item_columns($columns) {
    unset($columns['date']);
    return $columns
            + array(
        'testimonial_author' => __('Testimonial Author', 'beopen'),
        'testimonial_author_group' => __('Testimonial Author Group', 'beopen'),
        'date' => __('Date', 'beopen')
    );
}

function custom_testimonial_item_column($column, $post_id) {
    switch ($column) {

        case 'testimonial_author':
            echo get_post_meta($post_id, 'testimonial_author', true);
            break;

        case 'testimonial_author_group':
            echo get_post_meta($post_id, 'testimonial_author_group', true);
            break;
    }
}

/* SERVICES */

add_action('init', 'beopen_create_services');

function beopen_create_services() {
    register_post_type('service_item', array(
        'labels' => array(
            'name' => __('Services', 'beopen'),
            'singular_name' => __('Service', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Service', 'beopen'),
            'edit_item' => __('Edit Service', 'beopen'),
            'view_item' => __('View Service', 'beopen'),
            'search_items' => __('Search Services', 'beopen')
        ),
        'rewrite' => true,
        'menu_position' => 28,
        'public' => true,
        'has_archive' => false,
        'can_export' => true,
        'supports' => array('title', 'editor', 'thumbnail')
            )
    );
}

add_filter('manage_edit-service_item_columns', 'set_custom_edit_service_item_columns');
add_action('manage_service_item_posts_custom_column', 'custom_service_item_column', 10, 2);

function set_custom_edit_service_item_columns($columns) {
    unset($columns['date']);
    return $columns
            + array(
        'image' => __('Image', 'beopen'),
        'date' => __('Date', 'beopen')
    );
}

function custom_service_item_column($column, $post_id) {
    switch ($column) {
        case 'image':
            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                the_post_thumbnail('services-thumbnail');
            }
            break;
    }
}

add_action('admin_init', 'add_custom_metabox_to_service');
add_action('save_post', 'save_custom_metabox_to_service');

function add_custom_metabox_to_service() {
    add_meta_box('custom-metabox-to-service', __('Additional Info', 'beopen'), 'service_custom_metabox', 'service_item', 'normal', 'high');   
}

function service_custom_metabox() {
    global $post;
    global $fontello;
    $show_service_link = get_post_meta($post->ID, 'show_service_link', true);
    $service_link_title = get_post_meta($post->ID, 'service_link_title', true);
    $service_url = get_post_meta($post->ID, 'service_url', true);
    ?>
    <p><label for="service_link_show"><?php _e('Show Service Link', 'beopen'); ?>:<br />

            <select id="show_service_link" name="show_service_link">
                <option value="0" <?php if (!$show_service_link) {
        print 'selected="selected"';
    } ?>><?php _e('No', 'beopen'); ?></option>
                <option value="tiny" <?php if ($show_service_link == 'tiny') {
        print 'selected="selected"';
    } ?>><?php _e('Tiny', 'beopen'); ?></option>
                <option value="small" <?php if ($show_service_link == 'small') {
        print 'selected="selected"';
    } ?>><?php _e('Small', 'beopen'); ?></option>
                <option value="normal" <?php if ($show_service_link == 'normal') {
        print 'selected="selected"';
    } ?>><?php _e('Normal', 'beopen'); ?></option>
            </select>        
    </p>		                

    <p><label for="service_link_title"><?php _e('Service Link Title', 'beopen'); ?>:<br />
            <input id="service_link_title" size="37" name="service_link_title" value="<?php if ($service_link_title) {
        echo $service_link_title;
    } ?>" /></label></p>		                
    <p><label for="service_url"><?php _e('Service Url', 'beopen'); ?>:<br />
            <input id="service_url" size="37" name="service_url" value="<?php if ($service_url) {
        echo $service_url;
    } ?>" /></label></p>		
    <?php
    
    
    $service_item_icon = get_post_meta($post->ID, 'service_item_icon', true);
    $service_item_size = get_post_meta($post->ID, 'service_item_size', true);
    $service_item_line_height = get_post_meta($post->ID, 'service_item_line_height', true);        
    $service_item_color = get_post_meta($post->ID, 'service_item_color', true);        
    
    
    ?>
    <p><label for="service_item_icon"><?php _e('Icon', 'beopen'); ?>:<br />
       <select name="service_item_icon">
           <?php foreach ($fontello as $font_name => $font_code) { echo '<option value="'.$font_name.'" '; if ($font_name == $service_item_icon) { echo 'selected '; } echo '>' . $font_name . '</option>'; } ?>
       </select>
    </label></p>

    <p><label for="service_item_size"><?php _e('Icon Size', 'beopen'); ?>:<br />
            <input id="service_item_size" size="37" name="service_item_size" value="<?php echo $service_item_size; ?>" /></label></p>
            
    <p><label for="service_item_line_height"><?php _e('Icon Line Height', 'beopen'); ?>:<br />
            <input id="service_item_line_height" size="37" name="service_item_line_height" value="<?php echo $service_item_line_height; ?>" /></label></p>
            
    <p><label for="service_item_color"><?php _e('Icon Color', 'beopen'); ?>:<br />
            <input id="service_item_color" size="37" name="service_item_color" value="<?php echo $service_item_color; ?>" /></label></p>            
    <?php    
    
}


function save_custom_metabox_to_service() {
    global $post;

    if (get_post_type() == 'service_item')
        if ($_POST) {
            update_post_meta($post->ID, 'show_service_link', $_POST['show_service_link']);
            update_post_meta($post->ID, 'service_link_title', $_POST['service_link_title']);
            update_post_meta($post->ID, 'service_url', $_POST['service_url']);
            
            update_post_meta($post->ID, 'service_item_icon', $_POST['service_item_icon']);            
            update_post_meta($post->ID, 'service_item_size', $_POST['service_item_size']);
            update_post_meta($post->ID, 'service_item_line_height', $_POST['service_item_line_height']);
            update_post_meta($post->ID, 'service_item_color', $_POST['service_item_color']);
        }
}

/* PROCESSES */

add_action('init', 'beopen_create_processes');

function beopen_create_processes() {
    register_post_type('process_item', array(
        'labels' => array(
            'name' => __('Processes', 'beopen'),
            'singular_name' => __('Process', 'beopen'),
            'add_new' => __('Add New', 'beopen'),
            'add_new_item' => __('Add New Process', 'beopen'),
            'edit_item' => __('Edit Process', 'beopen'),
            'view_item' => __('View Process', 'beopen'),
            'search_items' => __('Search Processes', 'beopen')
        ),
        'rewrite' => true,
        'menu_position' => 30,
        'public' => true,
        'has_archive' => false,
        'can_export' => true,
        'supports' => array('title', 'editor', 'thumbnail')
            )
    );
}

add_filter('manage_edit-process_item_columns', 'set_custom_edit_process_item_columns');
add_action('manage_process_item_posts_custom_column', 'custom_process_item_column', 10, 2);
add_action('admin_init', 'add_custom_metabox_to_process_item');
add_action('save_post', 'save_custom_metabox_to_process_item');


function add_custom_metabox_to_process_item() {
    add_meta_box('custom-metabox-to-process-item', __('Icon', 'beopen'), 'process_item_custom_metabox', 'process_item', 'normal', 'high');
}

function process_item_custom_metabox() {
    global $post;
    global $fontello;
    $process_item_icon = get_post_meta($post->ID, 'process_item_icon', true);
    $process_item_size = get_post_meta($post->ID, 'process_item_size', true);
    $process_item_line_height = get_post_meta($post->ID, 'process_item_line_height', true);
    $process_item_color = get_post_meta($post->ID, 'process_item_color', true);        
    
    ?>
    <p><label for="process_item_icon"><?php _e('Icon', 'beopen'); ?>:<br />
       <select name="process_item_icon">
           <?php foreach ($fontello as $font_name => $font_code) { echo '<option value="'.$font_name.'" '; if ($font_name == $process_item_icon) { echo 'selected '; } echo '>' . $font_name . '</option>'; } ?>
       </select>
    </label></p>

    <p><label for="process_item_size"><?php _e('Icon Size', 'beopen'); ?>:<br />
            <input id="process_item_size" size="37" name="process_item_size" value="<?php echo $process_item_size; ?>" /></label></p>
            
    <p><label for="process_item_line_height"><?php _e('Icon Line Height', 'beopen'); ?>:<br />
            <input id="process_item_line_height" size="37" name="process_item_line_height" value="<?php echo $process_item_line_height; ?>" /></label></p>            
            
    <p><label for="process_item_color"><?php _e('Icon Color', 'beopen'); ?>:<br />
            <input id="process_item_color" size="37" name="process_item_color" value="<?php echo $process_item_color; ?>" /></label></p>            
    <?php
}


function save_custom_metabox_to_process_item() {
    global $post;
    
    if (get_post_type() == 'process_item')
        if ($_POST) {
            update_post_meta($post->ID, 'process_item_icon', $_POST['process_item_icon']);            
            update_post_meta($post->ID, 'process_item_size', $_POST['process_item_size']);
            update_post_meta($post->ID, 'process_item_line_height', $_POST['process_item_line_height']);
            update_post_meta($post->ID, 'process_item_color', $_POST['process_item_color']);
        }
}



function set_custom_edit_process_item_columns($columns) {
    unset($columns['date']);
    return $columns
            + array(
        'image' => __('Image', 'beopen'),
        'date' => __('Date', 'beopen')
    );
}

function custom_process_item_column($column, $post_id) {
    switch ($column) {
        case 'image':
            if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
                the_post_thumbnail('processes-thumbnail');
            }
            break;
    }
}

add_action('admin_init', 'add_custom_metabox_to_testimonial');
add_action('save_post', 'save_custom_metabox_to_testimonial');

function add_custom_metabox_to_testimonial() {
    add_meta_box('custom-metabox-to-testimonial', __('Testimonial Author', 'beopen'), 'testimonial_custom_metabox', 'testimonial_item', 'normal', 'high');
}

function testimonial_custom_metabox() {
    global $post;
    $testimonial_author = get_post_meta($post->ID, 'testimonial_author', true);
    $testimonial_author_group = get_post_meta($post->ID, 'testimonial_author_group', true);
    ?>
    <p><label for="testimonial_author"><?php _e('Testimonial Author', 'beopen'); ?>:<br />
            <input id="testimonial_author" size="37" name="testimonial_author" value="<?php if ($testimonial_author) {
        echo $testimonial_author;
    } ?>" /></label></p>

    <p><label for="testimonial_author_group"><?php _e('Testimonial Author Group', 'beopen'); ?>:<br />
            <input id="testimonial_author_group" size="37" name="testimonial_author_group" value="<?php if ($testimonial_author_group) {
        echo $testimonial_author_group;
    } ?>" /></label></p>		
    <?php
}

function save_custom_metabox_to_testimonial() {
    global $post;

    if (get_post_type() == 'testimonial_item')
        if ($_POST) {
            update_post_meta($post->ID, 'testimonial_author', $_POST['testimonial_author']);
            update_post_meta($post->ID, 'testimonial_author_group', $_POST['testimonial_author_group']);
        }
}

// Hook into WordPress
add_action('admin_init', 'add_custom_metabox_to_portfolio_item');
add_action('save_post', 'save_custom_metabox_to_portfolio_item');

/**
 * Add meta box
 */
function add_custom_metabox_to_portfolio_item() {
    add_meta_box('custom-metabox-to-portfolio-item', __('Options', 'beopen'), 'portfolio_item_custom_metabox', 'portfolio_item', 'normal', 'high');
}

/**
 * Display the metabox
 */
function portfolio_item_custom_metabox() {

    $errors = '';

    global $post;
    $urllink = get_post_meta($post->ID, 'urllink', true);
    $portfolioclient = get_post_meta($post->ID, 'portfolioclient', true);
    $embedvideo = get_post_meta($post->ID, 'embedvideo', true);
    $overview = get_post_meta($post->ID, 'overview', true);
    $show_preview_as = get_post_meta($post->ID, 'show_preview_as', true);

    // output invlid url message and add the http:// to the input field
    if ($errors) {
        echo $errors;
    }
    ?>


    <p><label for="overview"><?php _e('Overview', 'beopen'); ?>:</label>
    </p>
    <?php
        wp_editor( $overview, '_wp_editor_overview' );
    ?>
    
    <p><label for="siteurl"><?php _e('External Url', 'beopen'); ?>:<br />
            <input id="siteurl" size="37" name="siteurl" value="<?php if ($urllink) {
        echo $urllink;
    } ?>" /></label></p>		

    <p><label for="portfolioclient"><?php _e('Client', 'beopen'); ?>:<br />
            <input id="portfolioclient" size="37" name="portfolioclient" value="<?php if ($portfolioclient) {
        echo $portfolioclient;
    } ?>" /></label></p>				

    <p><label for="embedvideo"><?php _e('Embed Video', 'beopen'); ?>:<br />
            <textarea id="embedvideo" name="embedvideo" style="width: 100%;" rows="4"><?php if ($embedvideo) {
        echo $embedvideo;
    } ?></textarea></label></p>		

    <p><label for="show_preview_as"><?php _e('Show As', 'beopen'); ?>:<br />
            <select id="show_preview_as" name="show_preview_as">
                <option value="0" <?php if (!$show_preview_as) {
        print 'selected="selected"';
    } ?>><?php _e('Featured Image', 'beopen'); ?></option>
                <option value="2" <?php if ($show_preview_as == 2) {
        print 'selected="selected"';
    } ?>><?php _e('Gallery (attached to this item)', 'beopen'); ?></option>
            </select>
        </label>
    </p>		
    <?php
}

/**
 * Process the custom metabox fields
 */
function save_custom_metabox_to_portfolio_item($post_id) {

    global $post;

    if (get_post_type() == 'portfolio_item')
        if ($_POST) {
            if (isset($_POST['siteurl'])) {
                update_post_meta($post->ID, 'urllink', $_POST['siteurl']);
            }

            if (isset($_POST['portfolioclient'])) {
                update_post_meta($post->ID, 'portfolioclient', $_POST['portfolioclient']);
            }

            if (isset($_POST['embedvideo'])) {
                update_post_meta($post->ID, 'embedvideo', $_POST['embedvideo']);
            }

            if (isset($_POST['_wp_editor_overview'])) {
                update_post_meta($post->ID, 'overview', $_POST['_wp_editor_overview']);
            }

            if (isset($_POST['show_preview_as'])) {
                update_post_meta($post->ID, 'show_preview_as', $_POST['show_preview_as']);
            }
        }
}

// Hook into WordPress
add_action('admin_init', 'add_post_custom_metabox');
add_action('save_post', 'save_post_custom_metabox_to_post');

/**
 * Add meta box
 */
function add_post_custom_metabox() {
    add_meta_box('post-custom-metabox', __('Options', 'beopen'), 'post_custom_metabox', 'post', 'normal', 'high');
}

/**
 * Display the metabox
 */
function post_custom_metabox() {
    global $post;

    $show_preview_as = get_post_meta($post->ID, 'show_preview_as', true);
	
	
	$beopen_audio_file_source = get_post_meta($post->ID, 'beopen_audio_file_source', true);	

	$beopen_video_embed_code = get_post_meta($post->ID, 'beopen_video_embed_code', true);
	
	$beopen_quote_preview = get_post_meta($post->ID, 'beopen_quote_preview', true);
	
    ?>			
    <p><label for="show_preview_as"><?php _e('Show Preview As', 'beopen'); ?>:<br />
            <select id="show_preview_as" name="show_preview_as">
                <option value="0" <?php if (!$show_preview_as) {
        print 'selected="selected"';
    } ?>><?php _e('Featured Image', 'beopen'); ?></option>
                <option value="2" <?php if ($show_preview_as == 2) {
        print 'selected="selected"';
    } ?>><?php _e('Gallery (attached to this post)', 'beopen'); ?></option>
                <option value="3" <?php if ($show_preview_as == 3) {
        print 'selected="selected"';
    } ?>><?php _e('Audio player (playing audio file from links)', 'beopen'); ?></option>
            <option value="4" <?php if ($show_preview_as == 4) {
        print 'selected="selected"';
    } ?>><?php _e('Video player (playing Youtube, VIMEO videos etc)', 'beopen'); ?></option>
            <option value="5" <?php if ($show_preview_as == 5) {
        print 'selected="selected"';
    } ?>><?php _e('Quote', 'beopen'); ?></option>            
            </select>
        </label>
    </p>		
    
    <p><label for="beopen_audio_file_source"><?php _e('Audio file link for preview', 'beopen'); ?>:<br />
            <input id="beopen_audio_file_source" name="beopen_audio_file_source" value="<?php if ($beopen_audio_file_source) { echo $beopen_audio_file_source; } ?>" style="width: 90%;" />
    </label></p>
    </p>		    
    <p><label for="beopen_video_embed_code"><?php _e('Video embed code for preview', 'beopen'); ?>:<br />
            <textarea id="beopen_video_embed_code" name="beopen_video_embed_code" value="<?php echo $video_embed_code; ?>" style="width: 100%;" rows="4"><?php if ($beopen_video_embed_code) {
                echo $beopen_video_embed_code;
    } ?></textarea></label></p>
    </p>		    
    <p><label for="beopen_quote_preview"><?php _e('Quote for preview', 'beopen'); ?>:<br />
            <textarea id="beopen_quote_preview" name="beopen_quote_preview" style="width: 100%;" rows="4"><?php if ($beopen_quote_preview) {
        echo $beopen_quote_preview;
    } ?></textarea></label></p>
    </p>		    
    <?php
}

/**
 * Process the custom metabox fields
 */
function save_post_custom_metabox_to_post($post_id) {

    global $post;

    if ($_POST) {
        if (!empty($_POST['show_preview_as'])) {
            update_post_meta($post->ID, 'show_preview_as', $_POST['show_preview_as']);
		}
            
		if (!empty($_POST['beopen_audio_file_source'])) {
            update_post_meta($post->ID, 'beopen_audio_file_source', $_POST['beopen_audio_file_source']);
		}
		
		if (!empty($_POST['beopen_video_embed_code'])) {
            update_post_meta($post->ID, 'beopen_video_embed_code', $_POST['beopen_video_embed_code']);
		}
		
		if (!empty($_POST['beopen_quote_preview'])) {
            update_post_meta($post->ID, 'beopen_quote_preview', $_POST['beopen_quote_preview']);
        }
    }
}

/* LAYOUT EDITOR CUSTOM TEMPLATE */

add_action('admin_init', 'add_custom_metabox_to_page');
add_action('save_post', 'save_custom_metabox_to_page');

function add_custom_metabox_to_page() {
    add_meta_box('custom-metabox-to-page', __('Assign template from Layout Editor', 'beopen'), 'page_custom_metabox', 'page', 'normal', 'high');
    add_meta_box('custom-arrangement-to-page', __('Combine Page Content with Layout Editor', 'beopen'), 'combine_page_custom_metabox', 'page', 'normal', 'high');
}

function combine_page_custom_metabox() {
    
   global $post;


    $apages = get_option('beopen_visualeditor_pages');
    $apages = beopen_reorder($apages);
    
    $template_visualeditor_before = get_post_meta($post->ID, 'template_visualeditor_before', true);
    $template_visualeditor_after = get_post_meta($post->ID, 'template_visualeditor_after', true);

    ?>
    <p><label for="template_visualeditor_before"><?php _e('Add layout template before content', 'beopen'); ?>:<br />
            <select id="template_visualeditor_before" name="template_visualeditor_before">
                <option value="0"><?php _e('No layout selected', 'beopen'); ?></option>
            <?php
                if (is_array($apages)) {
						foreach ($apages as $pageslug => $page) {
                            $selected = '';
                            if ($pageslug == $template_visualeditor_before) {
                                $selected = ' selected="selected"';
                            }
							print '<option value="' . $pageslug . '" '.$selected.'>'.$page.'</option>';
						}
					}
            ?>
            </select></label>
    </p>
    
    <p><label for="template_visualeditor_after"><?php _e('Add layout template after content', 'beopen'); ?>:<br />
            <select id="template_visualeditor_after" name="template_visualeditor_after">
                <option value="0"><?php _e('No layout selected', 'beopen'); ?></option>
            <?php
                if (is_array($apages)) {
						foreach ($apages as $pageslug => $page) {
                            $selected = '';
                            if ($pageslug == $template_visualeditor_after) {
                                $selected = ' selected="selected"';
                            }
							print '<option value="' . $pageslug . '" '.$selected.'>'.$page.'</option>';
						}
					}
            ?>
            </select></label>
    </p>    
   
    
    <?php    
    
}


function page_custom_metabox() {
    global $post;


    $apages = get_option('beopen_visualeditor_pages');
    $apages = beopen_reorder($apages);
    
    $template_visualeditor = get_post_meta($post->ID, 'template_visualeditor', true);

    if (is_array($apages)) {
        foreach ($apages as $pageslug => $page) {
            print '<option value="' . $pageslug . '">' . $page . '</option>';
        }
    }
    ?>
    <p><label for="template_visualeditor"><?php _e('Layout Editor Template', 'beopen'); ?>:<br />
            <select id="template_visualeditor" name="template_visualeditor">
                <option value="0"><?php _e('Select a template', 'beopen'); ?></option>
            <?php
                if (is_array($apages)) {
						foreach ($apages as $pageslug => $page) {
                            $selected = '';
                            if ($pageslug == $template_visualeditor) {
                                $selected = ' selected="selected"';
                            }
							print '<option value="' . $pageslug . '" '.$selected.'>'.$page.'</option>';
						}
					}
            ?>
            </select></label>
    </p>
    <?php
    $beopen_show_pagetitlebar = get_post_meta($post->ID, 'beopen_show_pagetitlebar', true);
    ?>			
    <p><label for="beopen_show_pagetitlebar"><?php _e('Show page title bar', 'beopen'); ?>:<br />
            <select id="beopen_show_pagetitlebar" name="beopen_show_pagetitlebar">
                <option value="yes" <?php if ($beopen_show_pagetitlebar == 'yes') {
        print 'selected="selected"';
    } ?>><?php _e('Yes', 'beopen'); ?></option>
               <option value="no" <?php if ($beopen_show_pagetitlebar != 'yes') {
        print 'selected="selected"';
    } ?>><?php _e('No', 'beopen'); ?></option>
    </select></label>
    </p>
    <p>        
    First assign this page template from "Page Attributes" tab (usually, to the right) to "Custom Template From Layout Editor".
    </p>		
    
    <?php
}

function save_custom_metabox_to_page() {
    global $post;

    if (get_post_type() == 'page')
        if ($_POST) {
            update_post_meta($post->ID, 'template_visualeditor', $_POST['template_visualeditor']);
            update_post_meta($post->ID, 'beopen_show_pagetitlebar', $_POST['beopen_show_pagetitlebar']);
            
            update_post_meta($post->ID, 'template_visualeditor_before', $_POST['template_visualeditor_before']);
            update_post_meta($post->ID, 'template_visualeditor_after', $_POST['template_visualeditor_after']);
        }
}

/* UPDATE */

add_action('admin_init', 'add_parts_metabox_to_page');
add_action('save_post', 'save_parts_metabox_to_page');

function add_parts_metabox_to_page() {
    add_meta_box('parts-metabox-to-page', __('Customize Header & Footer', 'beopen'), 'parts_custom_metabox', 'page', 'normal', 'high');
}

function parts_custom_metabox() {
    global $post;
    
    
    $beopen_show_header = get_post_meta($post->ID, 'beopen_show_header', true);
    ?>			
    <p><label for="beopen_show_header"><?php _e('Show header', 'beopen'); ?>:<br />
            <select id="beopen_show_header" name="beopen_show_header">
                <option value="0" <?php if (!$beopen_show_header) {
        print 'selected="selected"';
    } ?>><?php _e('Yes', 'beopen'); ?></option>
               <option value="no" <?php if ($beopen_show_header == 'no') {
        print 'selected="selected"';
    } ?>><?php _e('No', 'beopen'); ?></option>
    </select></label>
    </p>
    <?php
    
    $beopen_show_footer = get_post_meta($post->ID, 'beopen_show_footer', true);
    ?>			
    <p><label for="beopen_show_footer"><?php _e('Show footer', 'beopen'); ?>:<br />
            <select id="beopen_show_footer" name="beopen_show_footer">
                <option value="0" <?php if (!$beopen_show_footer) {
        print 'selected="selected"';
    } ?>><?php _e('Yes', 'beopen'); ?></option>
               <option value="no" <?php if ($beopen_show_footer == 'no') {
        print 'selected="selected"';
    } ?>><?php _e('No', 'beopen'); ?></option>
    </select></label>
    </p>
    

    <?php
}

function save_parts_metabox_to_page() {
    global $post;

    if (get_post_type() == 'page')
        if ($_POST) {
            update_post_meta($post->ID, 'beopen_show_header', $_POST['beopen_show_header']);
            update_post_meta($post->ID, 'beopen_show_footer', $_POST['beopen_show_footer']);
        }
}


add_action('admin_init', 'add_portfolio_metabox_to_page');
add_action('save_post', 'save_portfolio_metabox_to_page');

function add_portfolio_metabox_to_page() {
    add_meta_box('portfolio-metabox-to-page', __('Portfolio Template settings', 'beopen'), 'portfolio_custom_metabox', 'page', 'normal', 'high');
}

function portfolio_custom_metabox() {
    global $post;
    
    
    $portfolio_categories = get_terms('portfolio_category', array());
    

    
    $select_options = array('' => array('title' => __('All categories', 'beopen'), 'value' => ''));
    
    foreach ($portfolio_categories as $portfolio_category) {
        
        $select_options[] = array('title' => $portfolio_category->name, 'value' => $portfolio_category->slug);
    }
    
    $beopen_portfolio_category = get_post_meta($post->ID, 'beopen_portfolio_category', true);
    ?>			
    <p><label for="beopen_portfolio_category"><?php _e('Show only projects from this portfolio category', 'beopen'); ?>:<br />
    <select id="beopen_portfolio_category" name="beopen_portfolio_category">
        
    <?php
        foreach ($select_options as $select_option) {
            echo '<option value="'.$select_option['value'].'"';
                if ($select_option['value'] == $beopen_portfolio_category) {
                    echo ' selected="selected"';
                }
            echo '>'. $select_option['title'].'</option>';
        }
    ?>
    </select>
    </label>
    </p>
    <?php
    

}

function save_portfolio_metabox_to_page() {
    global $post;

    if (get_post_type() == 'page')
        if ($_POST) {
            update_post_meta($post->ID, 'beopen_portfolio_category', $_POST['beopen_portfolio_category']);
            
        }
}












?>