<?php

constants();

global $allfonts;
global $include_js;
global $beopen_post;

// Functions

include(TEMPLATEPATH . '/beopen_framework/admin/functions.php');

// FrontEnd Functions

include(TEMPLATEPATH . '/beopen_framework/frontend-utils.php');

// TGM activation

include(TEMPLATEPATH . '/lib/activation.php');




// Option

include(TEMPLATEPATH . '/beopen_framework/options-utils.php');

// Customtypes

include(TEMPLATEPATH . '/beopen_framework/customtypes.php');

if (file_exists(TEMPLATEPATH . '/beopen_framework/elements/settings.php')) {
    include(TEMPLATEPATH . '/beopen_framework/elements/settings.php');
}

if (file_exists(TEMPLATEPATH . '/elements/settings.php')) {
    include(TEMPLATEPATH . '/elements/settings.php');
}


// Render

if ((IS_CHILD) && (file_exists(CHILD_BEOPEN_FRAMEWORK . '/render.php'))) {
    include(CHILD_BEOPEN_FRAMEWORK . '/render.php');
}
else
{
    include(TEMPLATEPATH . '/beopen_framework/render.php');
}

include(TEMPLATEPATH . '/beopen_framework/options.php');


if (is_admin()) 
{

    // Install

    include(TEMPLATEPATH . '/beopen_framework/install.php');

    // Update Notifier

    require(TEMPLATEPATH . '/beopen_framework/update-notifier.php');

    // Ajax Calls

    include(TEMPLATEPATH . '/beopen_framework/ajax.php');
}

// Customizer

include(TEMPLATEPATH . '/beopen_framework/customizer.php');

// Widgets

include(TEMPLATEPATH . '/beopen_framework/widgets/widgets.php');

// Shortcodes

include(TEMPLATEPATH . '/beopen_framework/shortcodes.php');


function get_font_list() {

    global $allfonts;

    $webfonts = get_option(FIELD_PREFIX . 'webfonts');

    if (($webfonts) && (is_array($webfonts))) {
        
    } else {
        $webfonts_file = file_get_contents(TEMPLATEPATH . '/fonts/webfonts');

        $webfonts_object = json_decode($webfonts_file);

        $webfonts = array();

        $webfonts['Google Fonts'] = array('name' => 'Google Fonts');

        $webfonts_items = $webfonts_object->items;

        foreach ($webfonts_items as $index => $webfonts_item) {

            
            $variants = $webfonts_item->variants;
            

            $webfonts[$webfonts_item->family] = array(
                'name' => '&nbsp;&nbsp;' . $webfonts_item->family,
                'family' => $webfonts_item->family,
                'include' => str_replace(' ', '+', $webfonts_item->family) . ':' . implode(',', $variants),
                'css' => "'" . $webfonts_item->family . "'"
            );
        }

        update_option(FIELD_PREFIX . 'webfonts', $webfonts);
    }


    $standard_fonts = array(
        'arial' => array(
            'name' => 'Arial',
            'css' => 'Arial',
            'standard' => 'yes'
        ),
        'verdana' => array(
            'name' => 'Verdana',
            'css' => 'Verdana, Geneva',
            'standard' => 'yes'
        ),
        'trebuchet' => array(
            'name' => 'Trebuchet',
            'css' => 'Trebuchet',
            'standard' => 'yes'
        ),
        'georgia' => array(
            'name' => 'Georgia',
            'css' => 'Georgia',
            'standard' => 'yes'
        ),
        'times' => array(
            'name' => 'Times New Roman',
            'css' => 'Times New Roman',
            'standard' => 'yes'
        ),
        'tahoma' => array(
            'name' => 'Tahoma, Geneva',
            'css' => 'Tahoma, Geneva',
            'standard' => 'yes'
        ),
        'palatino' => array(
            'name' => 'Palatino',
            'css' => 'Palatino',
            'standard' => 'yes'
        )
    );

    $all_fonts = array_merge($standard_fonts, $webfonts);

    $allfonts = $all_fonts;

    return $all_fonts;
}

function beopen_reset_button() {
    echo '<p class="submit reset-all-options"><input type="submit" name="reset-options" id="reset-options" class="button-primary" value="Reset All Settings to Default"  /></p>';
}

function beopen_save_button() {
    echo '<p class="submit"><input type="submit" name="submit" id="submit" class="button-primary" value="Save Changes"  /></p>';
}

function beopen_getting_started_page() {
    // move from first position
    update_option('beopen_getting_started_first', true);

    echo "<h2>" . __('Getting Started', 'beopen-framework') . "</h2>";
}

function beopen_admin_page_render($function_name) {

    $page_name = str_replace('_page', '', str_replace('beopen_', '', $function_name));

    global $optionPages;

    $optionPage = $optionPages[$page_name];
    $fields = $optionPage['fields'];

    foreach ($fields as $field) {
        if ((!isset($field['customizer'])) || (!$field['customizer'])) {
            beopen_show_field($field);
        }
    }
}

function beopen_header_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('Header', 'beopen-framework') . "</h2>";
    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';


    beopen_admin_page_render(__FUNCTION__);

    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_general_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('General', 'beopen-framework') . "</h2>";
    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';

    beopen_reset_button();
    echo '</form>';


    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';

    beopen_admin_page_render(__FUNCTION__);

    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_homepage_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('Homepage', 'beopen-framework') . "</h2>";

    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';

    beopen_admin_page_render(__FUNCTION__);

    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_blog_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('Blog', 'beopen-framework') . "</h2>";
    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';

    beopen_admin_page_render(__FUNCTION__);


    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_contact_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('Contact', 'beopen-framework') . "</h2>";
    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';

    beopen_admin_page_render(__FUNCTION__);



    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_footer_page() {

    //must check that the user has the required capability 
    if (!current_user_can('manage_options')) {
        wp_die(__('You do not have sufficient permissions to access this page.', 'beopen'));
    }

    echo "<h2>" . __('Footer', 'beopen-framework') . "</h2>";
    echo '<form name="form" method="post" action="" enctype="multipart/form-data">';
    beopen_save_button();
    echo '<table class="form-table beopen-admin">';
    echo '<tbody>';

    beopen_admin_page_render(__FUNCTION__);


    echo '</tbody>';
    echo '</table>';

    beopen_save_button();
    echo '</form>';
}

function beopen_visualeditor_page() {
    include(THEME_ADMIN . '/pages/editor.php');
}

function beopen_slider_page() {
    include(THEME_ADMIN . '/pages/slider.php');
}

function beopen_documentation() {
    include(THEME_ADMIN . '/pages/documentation.php');
}

function beopen_support() {
    include(THEME_ADMIN . '/pages/support.php');
}

function beopen_import_export() {
    include(THEME_ADMIN . '/pages/import-export.php');
}


// Defines the constant paths for use within the theme.
function constants() {
    $beopen_theme = wp_get_theme();
    
    define('THEME_NAME', $beopen_theme->get('Name'));
    define('THEME_NAME_FOLDER', get_template());
    
    define('THEME_DIR', get_template_directory());    
    define('THEME_URI', get_template_directory_uri());
    define('CHILD_THEME_DIR', get_stylesheet_directory());
    define('CHILD_THEME_URI', get_stylesheet_directory_uri());
        
    define('IS_CHILD', get_stylesheet_directory() != get_template_directory());

    define('THEME_LIBRARY', THEME_DIR . '/beopen_framework');
    define('BEOPEN_FRAMEWORK', THEME_DIR . '/beopen_framework');

    define('THEME_ADMIN', BEOPEN_FRAMEWORK . '/admin'); ///
    define('THEME_FUNCTIONS', BEOPEN_FRAMEWORK . '/functions'); ///

    define('ADMIN_URI', THEME_URI . '/beopen_framework/admin');
    define('ADMIN_IMAGES', ADMIN_URI . '/images');
    define('ADMIN_CSS', ADMIN_URI . '/css');
    define('ADMIN_JS', ADMIN_URI . '/js');
    define('ADMIN_AJAX', ADMIN_URI . '/ajax');
    define('THEME_IMAGES', THEME_URI . '/images');
    define('THEME_CSS', THEME_URI . '/css');
    define('THEME_JS', THEME_URI . '/js');
    
    define('CHILD_THEME_IMAGES', CHILD_THEME_URI . '/images');
    define('CHILD_THEME_CSS', CHILD_THEME_URI . '/css');
    define('CHILD_THEME_JS', CHILD_THEME_URI . '/js');    
    
    define('CHILD_BEOPEN_FRAMEWORK', CHILD_THEME_DIR . '/beopen_framework');    


    define('FIELD_PREFIX', 'beopen_' . str_replace(' ', '_', wp_get_theme()) . '_');
}

// Hook for adding admin menus
add_action('admin_menu', 'beopen_add_pages');

/* Initialize the theme admin functionality. */
add_action('init', 'beopen_admin_init');

function beopen_admin_init() {

    $allfonts = get_font_list();

    beopen_process_form();

    if (beopen_get_option('login_image')) {

        add_action("login_enqueue_scripts", "beopen_login_enqueue_css");

        function beopen_login_enqueue_css() {
        
            wp_enqueue_style(
                'beopen-login-style',
                get_template_directory_uri() . '/css/login.css'
            );
            
            $login_image = beopen_get_option('login_image');
            $custom_css = " 
                body.login #login h1 a {
                    background: url('{$login_image}') no-repeat scroll center top transparent;
                }";
            wp_add_inline_style( 'beopen-login-style', $custom_css );            
        }
    }
}

function beopen_create_settings_page() {
    
}

function add_admin_menu_separator($position) {
    global $menu;
    $index = 0;
    foreach ($menu as $offset => $section) {
        if (substr($section[2], 0, 9) == 'separator')
            $index++;
        if ($offset >= $position) {
            $menu[$position] = array('', 'read', "separator{$index}", '', 'wp-menu-separator');
            break;
        }
    }
    ksort($menu);
}

function beopen_add_pages() {

    $theme = wp_get_theme();

    add_object_page('Page Title', $theme->get('Name'), null, 'beopen', 'beopen_create_settings_page', ADMIN_IMAGES . '/theme-settings.png');

    add_admin_menu_separator(25);

    add_submenu_page('beopen', __('General', 'beopen-framework'), __('General', 'beopen-framework'), 'manage_options', 'beopen-general', 'beopen_general_page');

    add_submenu_page('beopen', __('Layout Editor', 'beopen-framework'), __('Layout Editor', 'beopen-framework'), 'manage_options', 'beopen-visual-editor', 'beopen_visualeditor_page');

    add_submenu_page('beopen', __('Visual Customizer', 'beopen-framework'), __('Visual Customizer', 'beopen-framework'), 'manage_options', 'customize.php');

    add_submenu_page('beopen', __('Header', 'beopen-framework'), __('Header', 'beopen-framework'), 'manage_options', 'beopen-header-page', 'beopen_header_page');

    add_submenu_page('beopen', __('Footer', 'beopen-framework'), __('Footer', 'beopen-framework'), 'manage_options', 'beopen-footer-page', 'beopen_footer_page');

    add_submenu_page('beopen', __('Homepage', 'beopen-framework'), __('Homepage', 'beopen-framework'), 'manage_options', 'beopen-homepage-page', 'beopen_homepage_page');

    add_submenu_page('beopen', __('Blog', 'beopen-framework'), __('Blog', 'beopen-framework'), 'manage_options', 'beopen-blog-page', 'beopen_blog_page');

    add_submenu_page('beopen', __('Contact', 'beopen-framework'), __('Contact', 'beopen-framework'), 'manage_options', 'beopen-contact-page', 'beopen_contact_page');

    add_submenu_page('beopen', __('Documentation', 'beopen-framework'), '<span class="beopen-help-page">' . __('Documentation', 'beopen-framework') . '</span>', 'manage_options', 'beopen-documentation', 'beopen_documentation');

    add_submenu_page('beopen', __('Support', 'beopen-framework'), '<span class="beopen-help-page">' . __('Support', 'beopen-framework') . '</span>', 'manage_options', 'beopen-support', 'beopen_support');
    
    add_submenu_page('beopen', __('Import / Export', 'beopen-framework'), '<span class="beopen-help-page">' . __('Import / Export', 'beopen-framework') . '</span>', 'manage_options', 'beopen-import-export', 'beopen_import_export');
}

function beopen_admin_notice() {
    if (beopen_get_option('show_under_construction') == 2) {
        echo '<div class="updated">
            <p>The site is in Construction Mode. You can change this setting from <strong>' . THEME_NAME . '</strong> &gt; <a href="' . get_admin_url() . 'admin.php?page=beopen-general">General</a> </p>
        </div>';
    }
}

add_action('admin_notices', 'beopen_admin_notice');

?>