<?php

	global $optionPages;


	$optionPages = array(
		'general' => array(
			'title' => 'General',
			'fields' => array(
				array(
					'name' => 'skin_selector',
					'label' => 'Skin Selector (Color Scheme)',
					'type' => array('default' => __('Blue', 'beopen'),
						'orange' => __('Orange', 'beopen'),
						'green' => __('Green', 'beopen'),
						'violet' => __('Violet', 'beopen'),
						'red' => __('Red', 'beopen'),
					),
					'default' => 'default',
					'css' => '',
					'customizer' => false,
					'description' => 'Changing the color scheme of the entire website. You can make further changes from the Visual Customizer.',
					'alert' => 'Changing the color scheme will reset any color and background changes made from the Visual Customizer!'
				),
				array(
					'name' => 'layout_type',
					'label' => 'Layout Type',
					'type' => array(
						'boxed' => __('Boxed', 'beopen'),
						'full' => __('Full', 'beopen')
					),
					'default' => 'full',
					'customizer' => true,
					'css' => ' ',
				),
				array(
					'name' => 'favicon',
					'label' => 'Fav Icon',
					'type' => 'fileupload',
					'default' => '',
					'customizer' => false,
					'description' => 'The little icon that shows in the browser tab'
				),
				array(
					'name' => 'login_image',
					'label' => 'Login Screen Logo (Admin)',
					'type' => 'fileupload',
					'default' => '',
					'customizer' => false,
					'description' => 'The logo that shows on the WordPress login page'
				),
				array(
					'name' => 'google_analytics_code',
					'label' => 'Google Analytics Tracking Code',
					'type' => 'textarea',
					'default' => '',
					'customizer' => false,
					'description' => 'The code that you get from the Google Analytics website'
				),
				array(
					'name' => 'google_analytics_position',
					'label' => 'Google Analytics Position',
					'type' => array('top' => 'Header', 'bottom' => 'Footer'),
					'default' => 'bottom',
					'customizer' => false,
					'description' => 'Where you want the Google Analytics code to be inserted'
				),
				array(
					'name' => 'beopen_theme_update_notifier',
					'label' => 'Theme Update Notifier',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'If you would like to be notified when new theme updates are available'
				),
				array(
					'name' => 'show_sidebar',
					'label' => 'Show Sidebar',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Enable sidebar for pages / posts. For pages, will be overridden by page`s selected template settings.'
				),
				array(
					'name' => 'sidebar_position',
					'label' => 'Sidebar Position',
					'type' => array('left' => 'Left', 'right' => 'Right'),
					'default' => 'right',
					'customizer' => false,
					'description' => 'Show the sidebar on the left or the right'
				),
				array(
					'name' => 'general_css',
					'label' => 'CSS to overwrite everything',
					'type' => 'largetextarea',
					'default' => '',
					'customizer' => false,
					'description' => 'Add custom CSS that will overwrite everything'
				),
				array(
					'name' => 'twitter_access_token',
					'label' => 'Twitter Access Token',
					'type' => 'text',
					'default' => '953820794-LJ5ySHqKA4o5Q4ggRvcNe8qnHiZ2AfUlnsoidF3t',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'twitter_access_token_secret',
					'label' => 'Twitter Acess Token Secret',
					'type' => 'text',
					'default' => 'YLZAvDHcPABKsDTxWanHxqLq5cAHFA8ymmXpGAMpe0',
					'customizer' => false,
					'description' => ''
				)
			)
		),
		'header' => array(
			'title' => 'Header',
			'fields' => array(
				array(
					'name' => 'fixed_header',
					'label' => 'Keep header visible when scrolling down',
					'type' => 'onoff',
					'default' => '2',
					'description' => 'Keep header visible when scrolling down'
				),
				array(
					'name' => 'site_logo',
					'label' => 'Site Logo',
					'type' => 'fileupload',
					'default' => '',
					'description' => 'Logo for your website that appears at the top of the website'
				),
				array(
					'name' => 'site_logo_retina',
					'label' => 'Site Logo Retina',
					'type' => 'fileupload',
					'default' => '',
					'description' => 'Retina Logo 2x for your website that appears at the top of the website'
				),
				array(
					'name' => 'show_logo_decoration',
					'label' => 'Show Logo Decoration',
					'type' => 'onoff',
					'default' => '',
					'description' => 'Decoration that appears near your logo'
				),
				array(
					'name' => 'site_logo_dimensions_width',
					'label' => 'Site Logo Dimensions Width',
					'type' => 'number',
					'default' => '',
					'description' => 'Width of the website logo',
					'css' => '#logo a { display: block; overflow: hidden; width: %px; }'
				),
				array(
					'name' => 'site_logo_dimensions_height',
					'label' => 'Site Logo Dimensions Height',
					'type' => 'number',
					'default' => '',
					'description' => 'Height of the website logo',
					'css' => '#logo a { display: block; overflow: hidden; height: %px; }'
				),
				array(
					'name' => 'site_logo_position_left',
					'label' => 'Site Logo Position From Left',
					'type' => 'number',
					'default' => '0',
					'description' => 'Website logo position from the left margin',
					'css' => 'body #inner-header { display: block; margin-left: %px; }',
				),
				array(
					'name' => 'site_logo_position_top',
					'label' => 'Site Logo Position From Top',
					'type' => 'number',
					'default' => '35',
					'description' => 'Website logo position from the top margin',
					'css' => 'body #inner-header { display: block; margin-top: %px; } @media only screen and (max-width: 767px) { #inner-header { margin-bottom: %px; } }',
				),
				array(
					'name' => 'site_logo_position_left_fixed',
					'label' => 'Site Logo Position From Left (for floating header)',
					'type' => 'number',
					'default' => '0',
					'description' => 'Website logo position from the left margin for floating header',
					'css' => '.is-sticky #inner-header { display: block; margin-left: %px; }',
				),
				array(
					'name' => 'site_logo_position_top_fixed',
					'label' => 'Site Logo Position From Top (for floating header)',
					'type' => 'number',
					'default' => '17',
					'description' => 'Website logo position from the top margin for floating header',
					'css' => '.is-sticky #inner-header { display: block; margin-top: %px; }',
				),
				array(
					'name' => 'site_mainmenu_spacing',
					'label' => 'Main Menu Spacing (top and bottom)',
					'type' => 'number',
					'default' => '42',
					'description' => 'Website main menu position from top and bottom margins',
					'css' => 'ul#beopen-nav-bar > li > a { padding-top: %px; padding-bottom: %px; } #beopen-quick-search { margin-top: %px; }',
				),
				array(
					'name' => 'site_mainmenu_spacing_fixed',
					'label' => 'Main Menu Spacing (top and bottom) (for floating header)',
					'type' => 'number',
					'default' => '20',
					'description' => 'Website main menu position from top and bottom margins for floating header',
					'css' => '.is-sticky ul#beopen-nav-bar > li > a { padding-top: %px; padding-bottom: %px; }  .is-sticky #beopen-quick-search { margin-top: %px; }',
				),
				array(
					'name' => 'site_header_height',
					'label' => 'Header Height',
					'type' => 'number',
					'default' => '40',
					'description' => 'Header Height to cover everything',
					'css' => 'body #header { min-height: %px; }',
				),
				array(
					'name' => 'slogan',
					'label' => 'Slogan Text',
					'type' => 'text',
					'default' => '',
					'description' => 'Slogan for your website that appears under the logo at the top of the website and overwrites Settings / General / Tagline'
				),
				array(
					'name' => 'slogan_position_left',
					'label' => 'Slogan Position From Left',
					'type' => 'number',
					'default' => '0',
					'description' => 'Slogan position from the left margin',
					'css' => '#inner-header #header-logo-stuff .slogan { padding-left: %px; }',
				),
				array(
					'name' => 'slogan_position_top',
					'label' => 'Slogan Position From Top',
					'type' => 'number',
					'default' => '0',
					'description' => 'Slogan position from the top margin',
					'css' => '#inner-header #header-logo-stuff .slogan { padding-top: %px; }',
				),
				array(
					'name' => 'show_header_action',
					'label' => 'Show TopBar',
					'type' => 'onoff',
					'default' => '1',
					'description' => 'The bar about the logo and menu.',
				),
				array(
					'name' => 'header_action_text',
					'label' => 'TopBar Action Text',
					'type' => 'text',
					'default' => '',
					'description' => 'The text in the bar about the logo and menu.',
				),
				array(
					'name' => 'show_header_action_social_icons',
					'label' => 'Show TopBar Social Icons',
					'type' => 'onoff',
					'default' => '1',
					'description' => 'Show the social icon in the bar about the logo and menu.',
				),
				array(
					'name' => 'show_header_telephone',
					'label' => 'Show TopBar Telephone',
					'type' => 'onoff',
					'default' => '2',
					'description' => 'Show the telephone in the bar about the logo and menu.',
				),
				array(
					'name' => 'header_telephone',
					'label' => 'Header Telephone',
					'type' => 'text',
					'default' => '1 (234) 567 890',
					'description' => 'The telephone number in the bar about the logo and menu.',
				),
				array(
					'name' => 'show_header_email',
					'label' => 'Show TopBar Email',
					'type' => 'onoff',
					'default' => '2',
					'description' => 'Show the email in the bar about the logo and menu.',
				),
				array(
					'name' => 'header_email',
					'label' => 'Header Email',
					'type' => 'text',
					'default' => 'office@example.com',
					'description' => 'The email in the bar about the logo and menu.',
				),
			)
		),
		'footer' => array(
			'title' => 'Footer',
			'fields' => array(
				array(
					'name' => 'show_footer',
					'label' => 'Show Footer',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Enable footer'
				),
				array(
					'name' => 'footer_custom_content',
					'label' => 'Footer Custom Content (Overrides Footer Description &amp; Widgets)',
					'type' => 'tinymce',
					'default' => '',
					'customizer' => false,
					'description' => 'HTML/Text that overrides Footer Description &amp; Widgets'
				),
				array(
					'name' => 'footer_logo',
					'label' => 'Footer Logo',
					'type' => 'fileupload',
					'default' => '',
					'customizer' => false,
					'description' => 'Logo for your website that appears in the footer'
				),
				array(
					'name' => 'footer_logo_dimensions_width',
					'label' => 'Footer Logo Dimensions Width',
					'type' => 'number',
					'default' => '',
					'customizer' => false,
					'description' => 'Width of the footer logo',
					'css' => '.footer #inner-footer #logo-footer { display: block; overflow: hidden; width: %px; }'
				),
				array(
					'name' => 'footer_logo_dimensions_height',
					'label' => 'Footer Logo Dimensions Height',
					'type' => 'number',
					'default' => '',
					'customizer' => false,
					'description' => 'Height of the footer logo',
					'css' => '.footer #inner-footer #logo-footer { display: block; overflow: hidden; height: %px; }'
				),
				array(
					'name' => 'footer_logo_position_left',
					'label' => 'Footer Logo Position From Left',
					'type' => 'number',
					'default' => '0',
					'customizer' => false,
					'description' => 'Footer logo position from the left margin',
					'css' => '.footer #inner-footer #logo-footer { display: block; overflow: hidden; padding-left: %px; }'
				),
				array(
					'name' => 'footer_logo_position_top',
					'label' => 'Footer Logo Position From Top',
					'type' => 'number',
					'default' => '0',
					'customizer' => false,
					'description' => 'Footer logo position from the top margin',
					'css' => '.footer #inner-footer #logo-footer { display: block; overflow: hidden; padding-top: %px; }'
				),
				array(
					'name' => 'footer_description',
					'label' => 'Footer Description',
					'type' => 'tinymce',
					'default' => 'This footer section is powered by a WYSIWYG box, allowing you to customize it any way you want with the help of HTML and shortcodes.',
					'customizer' => false,
					'description' => 'Text that appears under the logo in the footer'
				),
				array(
					'name' => 'copyright_in_footer',
					'label' => 'Copyright Text',
					'type' => 'text',
					'default' => '&copy; ' . date('Y') . ' beopenthemes.',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_privacy_policy',
					'label' => 'Show Privacy Policy Link',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'privacy_policy_url',
					'label' => 'Privacy Policy URL',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_terms_and_conditions',
					'label' => 'Show Terms and Conditions Link',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'terms_and_conditions_url',
					'label' => 'Terms &amp; Conditions URL',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_sitemap',
					'label' => 'Show Sitemap Link',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'sitemap_url',
					'label' => 'Sitemap URL',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_facebook',
					'label' => 'Show Facebook Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_facebook_url',
					'label' => 'Facebook Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_twitter',
					'label' => 'Show Twitter Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_twitter_url',
					'label' => 'Twitter Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_linkedin',
					'label' => 'Show LinkedIn Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_linkedin_url',
					'label' => 'LinkedIn Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_googleplus',
					'label' => 'Show Google+ Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_googleplus_url',
					'label' => 'Google+ Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_pinterest',
					'label' => 'Show PInterest Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_pinterest_url',
					'label' => 'PInterest Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_dribbble',
					'label' => 'Show Dribble Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'social_dribbble_url',
					'label' => 'Dribble Link',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => ''
				),
				array(
					'name' => 'show_social_rss',
					'label' => 'Show RSS Icon',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Enable RSS feed icon'
				),
				array(
					'name' => 'social_rss_url',
					'label' => 'Custom RSS Feed Url',
					'type' => 'text',
					'default' => '#',
					'customizer' => false,
					'description' => 'The URL for the website\'s RSS feed'
				),
			)
		),
		'homepage' => array(
			'title' => 'Homepage',
			'fields' => array(
				array(
					'name' => 'homepage_layout',
					'label' => 'Homepage Layout',
					'type' => beopen_reorder(get_option('beopen_visualeditor_pages', array())),
					'default' => 'layout_1',
					'customizer' => false,
					'description' => 'Choose one of the default homepage layouts or a user created layout'
				),
				array(
					'name' => 'motto',
					'label' => 'Motto Text',
					'type' => 'textarea',
					'default' => 'Say hello to Breathe, a responsive multi-purpose WordPress theme, beautiful and clean, easy to use and rich in features.',
					'customizer' => false,
					'description' => 'Text that will be used as a motto'
				),
				array(
					'name' => 'call_to_action',
					'label' => 'Call To Action Text',
					'type' => 'textarea',
					'default' => 'Buy Breathe, a responsive multi-purpose WordPress theme, exclusively on the Themeforest marketplace!',
					'customizer' => false,
					'description' => 'Text that will be used as a call to action'
				),
				array(
					'name' => 'call_to_action_button_text',
					'label' => 'Call To Action Button Text',
					'type' => 'text',
					'default' => 'Buy it now!',
					'customizer' => false,
					'description' => 'Text to be displayed on the call to action button'
				),
				array(
					'name' => 'call_to_action_button_link',
					'label' => 'Call To Action Button Link',
					'type' => 'text',
					'default' => 'http://breathe.beopenthemes.com/buy',
					'customizer' => false,
					'description' => 'Link for the call to action button'
				),
			)
		),
		'blog' => array(
			'title' => 'Blog',
			'fields' => array(
				array(
					'name' => 'show_breadcrumbs',
					'label' => 'Show Breadcrumbs',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Enable breadcrumbs under the top menu'
				),
				array(
					'name' => 'show_post_author',
					'label' => 'Show Post Author',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Show post`s author'
				),
				array(
					'name' => 'show_post_date',
					'label' => 'Show Post Date',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Show post`s date'
				),
				array(
					'name' => 'show_post_categories',
					'label' => 'Show Post Categories',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Show post`s categories'
				),
				array(
					'name' => 'show_post_tags',
					'label' => 'Show Post Tags',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Show post`s tags'
				),
				array(
					'name' => 'show_excerpt_or_full_post',
					'label' => 'Show Excerpt or Full Post',
					'type' => array('excerpt' => 'Excerpt', 'full_post' => 'Full Post'),
					'default' => 'excerpt',
					'customizer' => false,
					'description' => 'Show excerpts only or the full posts on the blog page'
				),
				array(
					'name' => 'excerpt_length',
					'label' => 'Maximum Words In Excerpt',
					'type' => 'number',
					'default' => '70',
					'customizer' => false,
					'description' => 'Length of the excerpt (number of words)'
				),
				array(
					'name' => 'show_about_author_in_post',
					'label' => 'Show About Author In Post',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Display information about the author in the post page'
				)
			)
		),
		'contact' => array(
			'title' => 'Contact',
			'fields' => array(
				array(
					'name' => 'show_map',
					'label' => 'Show Map',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Show Google Map on contact page'
				),
				array(
					'name' => 'map_coordinates',
					'label' => 'Google Map Coordinates',
					'type' => 'text',
					'default' => '',
					'customizer' => false,
					'description' => 'Coordinates for the Google Map. They should look like \'44.442681,26.180803\'. Go to http://maps.google.com and right click on the center of the map and choose \'What\'s here\''
				),
				array(
					'name' => 'map_zoom',
					'label' => 'Google Map Zoom',
					'type' => 'number_hundred',
					'default' => '',
					'customizer' => false,
					'description' => 'Zoom level for the map'
				),
				array(
					'name' => 'map_address',
					'label' => 'Address',
					'type' => 'tinymce',
					'default' => '<h5>Contact Details</h5>' . PHP_EOL . '19 Your Street Name' . PHP_EOL . 'California, CA 12105, USA' . PHP_EOL . '<br />' . PHP_EOL . '<strong>Phone</strong>: (123) 456-7890' . PHP_EOL . '<strong>Fax</strong>: (123) 456-7890' . PHP_EOL . '<strong>Email</strong>: info@yoursitename.com' . PHP_EOL . '<strong>Web</strong>: www.yoursitename.com',
					'customizer' => false,
					'description' => 'Your contact address'
				),
				array(
					'name' => 'show_contact_form',
					'label' => 'Show Contact Form',
					'type' => 'onoff',
					'default' => '2',
					'customizer' => false,
					'description' => 'Text that will show at the top of the contact form, under the title'
				),
				array(
					'name' => 'contact_email_from',
					'label' => 'Contact E-mail Sender',
					'type' => 'text',
					'default' => 'example@example.com',
					'customizer' => false,
					'description' => 'The e-mail address who sends the contact form submission'
				),
				array(
					'name' => 'contact_form_text',
					'label' => 'Contact Form Text',
					'type' => 'tinymce',
					'default' => 'Inquire about business or just say \'Hi\'',
					'customizer' => false,
					'description' => 'Enable the contact form on the "Contact" page'
				),
				array(
					'name' => 'contact_email_to',
					'label' => 'Contact E-mail Recipient',
					'type' => 'text',
					'default' => 'example@example.com',
					'customizer' => false,
					'description' => 'The e-mail address for the contact form submission'
				),
				array(
					'name' => 'contact_email_subject',
					'label' => 'Contact E-mail Subject',
					'type' => 'text',
					'default' => 'Contact Form Submission',
					'customizer' => false,
					'description' => 'The subject of the e-mail sent by the contact form'
				),
				array(
					'name' => 'show_recaptcha',
					'label' => 'Show Recaptcha',
					'type' => 'onoff',
					'default' => '',
					'customizer' => false,
					'description' => 'Enable reCAPTCHA'
				),
				array(
					'name' => 'recaptcha_public_key',
					'label' => 'Recaptcha Public Key',
					'type' => 'text',
					'default' => '',
					'customizer' => false,
					'description' => 'Your reCAPTCHA public key'
				),
				array(
					'name' => 'recaptcha_private_key',
					'label' => 'Recaptcha Private Key',
					'type' => 'text',
					'default' => '',
					'customizer' => false,
					'description' => 'Your reCAPTCHA private key'
				)
			)
		),
		'fonts' => array(
			'title' => 'Fonts',
			'fields' => array(
				array(
					'name' => 'general_font',
					'label' => 'General Font (generally applied)',
					'type' => 'font',
					'default' => array('name' => '', 'size' => '', 'style' => ''),
					'css' => 'body, body * ',
					'customizer' => true
				),
				array(
					'name' => 'logo_font',
					'label' => 'Logo Font',
					'type' => 'font',
					'default' => '',
					'css' => '#inner-header #logo a',
					'customizer' => true
				),
				array(
					'name' => 'slogan_font',
					'label' => 'Logo Slogan Font',
					'type' => 'font',
					'default' => '',
					'css' => 'span.slogan span',
					'customizer' => true
				),
				array(
					'name' => 'main_menu_font',
					'label' => 'Top Menu Font',
					'type' => 'font',
					'default' => '',
					'css' => 'ul.nav-bar, ul.nav-bar a, ul.nav-bar li a, ul.nav-bar li *',
					'customizer' => true
				),
				array(
					'name' => 'motto_font',
					'label' => 'Motto Font',
					'type' => 'font',
					'default' => '',
					'css' => '.motto',
					'customizer' => true
				),
				array(
					'name' => 'titles_font',
					'label' => 'Titles Font (H1, H2, H3)',
					'type' => 'font',
					'default' => '',
					'css' => 'h1, h2, h3, h4, h5, h2 span.title ',
					'customizer' => true
				),
				array(
					'name' => 'content_font',
					'label' => 'Content Font (Paragraphs)',
					'type' => 'font',
					'default' => '',
					'css' => 'p, .feature ',
					'customizer' => true
				),
				array(
					'name' => 'footer_titles_font',
					'label' => 'Footer Titles',
					'type' => 'font',
					'default' => '',
					'css' => '.footer h6, .footer h6 strong ',
					'customizer' => true
				),
				array(
					'name' => 'footer_content_font',
					'label' => 'Footer Content Font',
					'type' => 'font',
					'default' => '',
					'css' => '.footer p, .footer p strong ',
					'customizer' => true
				),
				array(
					'name' => 'sidebar_titles_font',
					'label' => 'Sidebar Titles Font',
					'type' => 'font',
					'default' => '',
					'css' => '.sidebar-section h6, .sidebar-section h6 strong, .sidebar-section h3 ',
					'customizer' => true
				),
				array(
					'name' => 'sidebar_content_font',
					'label' => 'Sidebar Content Font',
					'type' => 'font',
					'default' => '',
					'css' => '#sidebar p, #sidebar a, #sidebar .service-text ',
					'customizer' => true
				),
				array(
					'name' => 'topbar_font',
					'label' => 'Header Topbar Font',
					'type' => 'font',
					'default' => '',
					'css' => '.topbar h1 ',
					'customizer' => true
				),
				array(
					'name' => 'breadcrumbs_font',
					'label' => 'Breadcrumbs Font',
					'type' => 'font',
					'default' => '',
					'css' => 'ul.breadcrumbs li a, ul.breadcrumbs li span, ul.breadcrumbs li ',
					'customizer' => true
				),
				array(
					'name' => 'posts_titles_font',
					'label' => 'Posts Titles Font',
					'type' => 'font',
					'default' => '',
					'css' => 'article.type-post h1, article.type-post h2, article.type-page h1, article.type-page h2 ',
					'customizer' => true
				),
				array(
					'name' => 'posts_content_font',
					'label' => 'Posts Content Font',
					'type' => 'font',
					'default' => '',
					'css' => 'article.type-post p, article.type-page p ',
					'customizer' => true
				),
				array(
					'name' => 'posts_meta_font',
					'label' => 'Posts Meta Font',
					'type' => 'font',
					'default' => '',
					'css' => '.metainfo ',
					'customizer' => true
				),
			)
		),
		'pages_backgrounds' => array(
			'title' => 'Pages Backgrounds',
			'fields' => array(
				array(
					'name' => 'outer_page_background_color',
					'label' => 'Outer Page Background Color',
					'type' => 'color',
					'default' => '#dadada',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'outer_page_background_image',
					'label' => 'Outer Page Background Image',
					'type' => 'background',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'page_background_color',
					'label' => 'Page Background Color',
					'type' => 'color',
					'default' => '#fff',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'page_background_image',
					'label' => 'Page Background Image',
					'type' => 'background',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'header_background_color',
					'label' => 'Header Background Color',
					'type' => 'color',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'header_background_image',
					'label' => 'Header Background Image',
					'type' => 'background',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_background_color',
					'label' => 'Footer Background Color',
					'type' => 'color',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_background_image',
					'label' => 'Footer Background Image',
					'type' => 'background',
					'default' => '',
					'css' => true,
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'header_colors_backgrounds' => array(
			'title' => 'Header Colors + Backgrounds',
			'fields' => array(
				array(
					'name' => 'logo_color',
					'label' => 'Logo Color',
					'type' => 'color',
					'default' => '',
					'css' => '#inner-header #logo a, #inner-header #logo a:hover { color: % !important; }',
					'customizer' => true,
					'skin' => true
				),
				// MAIN MENU
				array(
					'name' => 'header_background_color',
					'label' => 'Header Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'header_background_image',
					'label' => 'Header Background Image',
					'type' => 'background',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'mainmenu_1level_text_color',
					'label' => 'MainMenu 1st Level Text Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'mainmenu_1level_text_hover_color',
					'label' => 'MainMenu 1st Level Text Hover Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'topbar_background_color',
					'label' => 'Bar Under Menu Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'footer_colors_backgrounds' => array(
			'title' => 'Footer Colors + Backgrounds',
			'fields' => array(
				array(
					'name' => 'footer_text_color',
					'label' => 'Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_widget_heading_color',
					'label' => 'Footer Widget Heading Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_background_color',
					'label' => 'Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_background',
					'label' => 'Background Image',
					'type' => 'background',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_link_color',
					'label' => 'Link Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'footer_link_hover_color',
					'label' => 'Link Hover Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'social_icons_color',
					'label' => 'Social Icons Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'visual_editor_colors' => array(
			'title' => 'Visual Editor Colors',
			'fields' => array(
				array(
					'name' => 'process_background_color',
					'label' => 'Process Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_bullet_color',
					'label' => 'Pagination Bullet Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_bullet_selected_color',
					'label' => 'Pagination Bullet Selected Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'portfolio' => array(
			'title' => 'Portfolio',
			'fields' => array(
				array(
					'name' => 'portfolio_filter_selected_color',
					'label' => 'Portfolio Filter Selected Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'portfolio_filter_selected_color',
					'label' => 'Portfolio Filter Selected Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'portfolio_h_color',
					'label' => 'H1, H2, H3, H4, H5, H6 Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'portfolio_overview_background_color',
					'label' => 'Overview Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'content' => array(
			'title' => 'Buttons, Colors, Content',
			'fields' => array(
				array(
					'name' => 'button_background_color',
					'label' => 'Button Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'link_color',
					'label' => 'Link Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'link_hover_color',
					'label' => 'Link Hover Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		),
		'pagination' => array(
			'title' => 'Pagination Colors',
			'fields' => array(
				array(
					'name' => 'pagination_background',
					'label' => 'Pagination Background',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_current_page_color',
					'label' => 'Pagination Current Page Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_current_page_background_color',
					'label' => 'Pagination Current Page Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_link_color',
					'label' => 'Pagination Link Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_link_background_color',
					'label' => 'Pagination Link Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
				array(
					'name' => 'pagination_link_hover_background_color',
					'label' => 'Pagination Link Hover Background Color',
					'type' => 'color',
					'default' => '',
					'css' => ' ',
					'customizer' => true,
					'skin' => true
				),
			)
		)
	);
?>