<?php

    /*
     * Beopen Framework v.2.2
     * By BeopenThemes
     */

    class beopen_visual_render {

        static function render($custom_layout = false, $just_css = false, $test = false) {
							
			if (isset($_GET['test'])) {
				$test = true;
			}
			
			
			if (!$just_css) {
				do_action('beopen_visual_render_before');
			}

            global $visual_editor_elements;

            if ($custom_layout) {
                $layoutPage = $custom_layout;
            } else {
                $layoutPage = beopen_get_option('homepage_layout', 0);
            }

			if (((!empty($_SESSION['beopen-layout'])) || (beopen_get_option('layout_type') == 'boxed')) && (get_option(beopen_slug('beopen_visualeditor_' . $layoutPage . '_boxed')))) {
				
				$layoutPage = $layoutPage . '_boxed';
			}
			

            $layoutContent = get_option('beopen_visualeditor_' . $layoutPage);
            $language_layoutContent = get_option(beopen_slug('beopen_visualeditor_' . $layoutPage . get_bloginfo('language')));
			
			

            if ($language_layoutContent) {
                $layoutContent = $language_layoutContent;
            }

            global $beopen_item_count;

            $banner_here = false;

			if ($test) {
				$layoutContent = beopen_visual_render::test();
			} else 
			{
				$layoutContent = stripslashes_deep($layoutContent);
			}

            $elementStyleCss = array();
			


            $k1 = 0;
            if (is_array($layoutContent))
                foreach ($layoutContent as $k1 => $element)
                    if (is_array($element)) {

                        $styleCss = '';

						$addSubStyleClass = '';
                        $addStyleClass = '';
						$addData = '';
                        if (isset($element['rowSettings']['backgroundAlternativeStyle']) && ($element['rowSettings']['backgroundAlternativeStyle'])) {
                            $addStyleClass .= ' ' . $element['rowSettings']['backgroundAlternativeStyle'];
                        }

                        if (isset($element['rowSettings']['titleAlternativeStyle']) && ($element['rowSettings']['titleAlternativeStyle'])) {
                            $addStyleClass .= ' ' . $element['rowSettings']['titleAlternativeStyle'];
                        }
						
						// animations
						if (isset($element['rowSettings']['animations']) && ($element['rowSettings']['animations'])) {
                            $addSubStyleClass .= ' beopen-row-animated ';
							$addData .= ' data-beopen-animation="' . $element['rowSettings']['animations'] . '"';
                        }
						

                        $idAnchor = 'beopen-section-' . $k1;
                        if (isset($element['rowSettings']['anchor']) && ($element['rowSettings']['anchor'])) {
                            $idAnchor = $element['rowSettings']['anchor'];
                        }


                        if ($just_css) {

                            if (isset($element['rowSettings']['textColor']) && ($element['rowSettings']['textColor'])) {
                                $elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('*', 'h2 span.title', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', '.description'),
                                    'rules' => 'color: ' . $element['rowSettings']['textColor'] . ';'
                                );
								
								$elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('h2:after'),
                                    'rules' => 'border-color: ' . $element['rowSettings']['textColor'] . ';'
                                );
								
								
                            }

                            if (isset($element['rowSettings']['color']) && ($element['rowSettings']['color'])) {
                                $styleCss .= 'background-color: ' . $element['rowSettings']['color'] . ';';
                            }

                            if (isset($element['rowSettings']['backgroundImage']) && ($element['rowSettings']['backgroundImage'])) {
                                $styleCss .= 'background-image: url(' . $element['rowSettings']['backgroundImage'] . ');';
                            }

                            if (isset($element['rowSettings']['backgroundPosition']) && ($element['rowSettings']['backgroundPosition'])) {
                                $styleCss .= 'background-position: ' . $element['rowSettings']['backgroundPosition'] . ';';
                            }

                            if (isset($element['rowSettings']['backgroundRepeat']) && ($element['rowSettings']['backgroundRepeat'])) {
                                $styleCss .= 'background-repeat: ' . $element['rowSettings']['backgroundRepeat'] . ';';
                            }

                            if (isset($element['rowSettings']['backgroundAttachment']) && ($element['rowSettings']['backgroundAttachment'])) {
                                $styleCss .= 'background-attachment: ' . $element['rowSettings']['backgroundAttachment'] . ';';
                            }

                            if (isset($element['rowSettings']['backgroundSize']) && ($element['rowSettings']['backgroundSize'])) {
                                $styleCss .= 'background-size: ' . $element['rowSettings']['backgroundSize'] . ';';
                            }

                            if (isset($element['rowSettings']['paddingTop']) && ($element['rowSettings']['paddingTop'] != '')) {

                                $elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('> div'),
                                    'rules' => 'padding-top: ' . $element['rowSettings']['paddingTop'] . 'px;'
                                );

                                $responsiveElementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('> div'),
                                    'rules' => 'padding-top: ' . round($element['rowSettings']['paddingTop'] / 3) . 'px;'
                                );
                            }

                            if (isset($element['rowSettings']['paddingBottom']) && ($element['rowSettings']['paddingBottom'] != '')) {

                                $elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('> div'),
                                    'rules' => 'padding-bottom: ' . $element['rowSettings']['paddingBottom'] . 'px;'
                                );

                                $responsiveElementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('> div'),
                                    'rules' => 'padding-bottom: ' . round($element['rowSettings']['paddingBottom'] / 3) . 'px;'
                                );
                            }


                            if (isset($element['rowSettings']['titleColor']) && ($element['rowSettings']['titleColor'] != '')) {
                                $elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('h2 span.title'),
                                    'rules' => 'color: ' . $element['rowSettings']['titleColor'] . ';'
                                );
                            }
							
                            if (isset($element['rowSettings']['backgroundVideoOpacity']) && ($element['rowSettings']['backgroundVideoOpacity'] != '')) {
								
								$backgroundVideoOpacity = $element['rowSettings']['backgroundVideoOpacity'] / 100;
								
                                $elementStyleCss['.beopen-' . $layoutPage . '-row-' . $k1][] = array(
                                    'selectors' => array('video'),
                                    'rules' => 'opacity: ' . $backgroundVideoOpacity  . ';'
                                );
                            }							

                            $astylecss[] = '.beopen-' . $layoutPage . '-row-' . $k1 . ' { ' . $styleCss . ' }';
                        } else {

                            if ($element['elements'][0]['typeName'] == 'slideshow') {
                                echo '<div class="bannercontainer beopen-section beopen-' . $layoutPage . '-row-' . $k1 . ' ' . $addStyleClass . '">';
                                echo '<div class="rev-shadow-top"></div>';



                                if (!empty($element['rowSettings']['backgroundVideo'])) {
									echo sprintf('<div class="beopen-framework-video-frame"><video class="beopen-framework-video" autoplay="autoplay" loop="loop" src="%s"></video>', $element['rowSettings']['backgroundVideo']);
                                }


                                echo '<div>';
                                $banner_here = true;
                            } else {
                                if ($k1 % 2 == 0) {

                                    echo '<div class="even-separator"></div>';

                                    echo '<div id="' . $idAnchor . '" class="beopen-home beopen-even beopen-section beopen-' . $layoutPage . '-row-' . $k1 . ' ' . $addStyleClass . '">';
                                } else {
                                    if (!$banner_here) {
                                        echo '<div class="odd-separator"></div>';
                                    } else {
                                        echo '<div class="after-slider-separator"></div>';
                                    }
                                    $banner_here = false;
                                    echo '<div id="' . $idAnchor . '" class="beopen-home beopen-odd beopen-section beopen-' . $layoutPage . '-row-' . $k1 . ' ' . $addStyleClass  . '">';
                                }


                                if (!empty($element['rowSettings']['backgroundVideo'])) {
                                    echo sprintf('<div class="beopen-framework-video-frame"><video class="beopen-framework-video" autoplay="autoplay" loop="loop" src="%s"></video>', $element['rowSettings']['backgroundVideo']);
                                }


                                $typeName = $element['elements'][0]['typeName'];
                                $visual_editor_element = $visual_editor_elements[$typeName];
                                if (empty($visual_editor_element['wide'])) {
                                    echo '<div class="row '. $addSubStyleClass.'" ' . $addData . '>';
                                }
                            }
                            $columnCurrent = 0;

                            foreach ($element['elements'] as $k2 => $box) {


                                if (isset($box['data']['item_count'])) {
                                    $beopen_item_count = $box['data']['item_count'];
                                } else
                                    $beopen_item_count = $box['columnWidth'] / 3;




                                if ($box['columnStart'] != $columnCurrent) {
                                    print '<div class="' . columnNumberToString($box['columnStart'] - $columnCurrent) . ' columns">';
                                    print '</div>';
                                }


                                if (strpos($box['typeName'], 'widget_bar_') !== false) {

                                    $widget_area_number = str_replace('widget_bar_', '', $box['typeName']);
                                    beopen_visual_render::widgetbar($widget_area_number);
                                } else {
                                    beopen_visual_render::displayElement($box);
                                }


                                $columnCurrent = $columnCurrent + $box['columnWidth'];
                            }

                            if (empty($visual_editor_element['wide'])) {
                                echo '</div>';
                            }

                            if (!empty($element['rowSettings']['backgroundVideo'])) {
                                echo '</div>';
                            }

                            echo '</div>';
                        }
                    }


            if ($just_css) {
                echo '<style type="text/css">';
                echo PHP_EOL;
                foreach ($elementStyleCss as $row_class => $a_css_objects) {

                    foreach ($a_css_objects as $a_css_object) {

                        $a_selectors = array();
                        foreach ($a_css_object['selectors'] as $selector) {
                            $a_selectors[] = $row_class . ' ' . $selector;
                        }

                        echo implode(',', $a_selectors) . ' { ' . $a_css_object['rules'] . ' } ' . PHP_EOL;
                    }
                }
                echo PHP_EOL;
                echo '@media only screen and (max-width: 767px) {';
                echo PHP_EOL;
                foreach ($responsiveElementStyleCss as $row_class => $a_css_objects) {

                    foreach ($a_css_objects as $a_css_object) {

                        $a_selectors = array();
                        foreach ($a_css_object['selectors'] as $selector) {
                            $a_selectors[] = $row_class . ' ' . $selector;
                        }

                        echo implode(',', $a_selectors) . ' { ' . $a_css_object['rules'] . ' } ' . PHP_EOL;
                    }
                }
                echo PHP_EOL;
                echo '}';
                echo PHP_EOL;
                echo implode(PHP_EOL, $astylecss);
                echo PHP_EOL;
                echo '</style>';
            }
			
			if (!$just_css) {
				do_action('beopen_visual_render_after');
			}
        }

        static function sdisplay($type, $box, $swidth, $show_carousel = true, $wide = false) {

            $output = '';

            if ($show_carousel) {
                if ($swidth) {
                    $output .= '<div class="' . $swidth . ' columns ' . $type . ' ';
                    if ($show_carousel) {
                        $output .= 'carousels';
                    }

                    $output .= '">';
                }

                $title = '';

                if (isset($box['data']['title'])) {
                    $title = $box['data']['title'];
                }

                $subtitle = '';

                if (isset($box['data']['subtitle'])) {
                    $subtitle = $box['data']['subtitle'];
                }

				

                $output .= self::beginCarousel($box, $title, $subtitle);

                $output .= self::includeElement($type, $box); //self::$type($box, $swidth);

                $output .= self::endCarousel($box);

                if ($swidth) {
                    $output .= '</div>';
                }
            } else {

                if (!$wide) {
                    $output .= '<div class="' . $swidth . ' columns ' . $type . '">';
                }
                else
                {
                    $output .= '<div>';
                }

                if (isset($box['data']['title']) && ($box['data']['title'])) {
                    $output .= '<h2 class="headline">';

                    $output .= '<span class="beopen-extra-style"></span>';
					
					$output .= '<span class="subtitle">';
					if (!empty($box['data']['subtitle'])) {
						$output .= $box['data']['subtitle'];
					}
					$output .= '</span>';
					

                    $output .= '<span class="title">';
                    $output .= $box['data']['title'];
                    $output .= '</span>';

                    $output .= '</h2>';
                }

                if (!$wide) {
                    $output .= '<div class="home-inner-section">';
                }
                $output .= self::includeElement($type, $box);
                
                if (!$wide) {
                    $output .= '</div>';
                }
                
                $output .= '</div>';
            }
            return $output;
        }

        static function display($type, $box, $swidth, $show_carousel = true, $wide = false) {

            if (has_action('beopen_framework_display')) {
                do_action('beopen_framework_display', array('type' => $type, 'box' => $box, 'swidth' => $swidth, 'show_carousel' => $show_carousel, 'wide' => $wide));
            } else {
                echo self::sdisplay($type, $box, $swidth, $show_carousel, $wide);
            }
        }

        static function displayElement($box) {
            global $visual_editor_elements;

            $elementType = $box['typeName'];

            $element = $visual_editor_elements[$elementType];

            $has_carousel = isset($element['carousel']) && ($element['carousel']);

            $has_wide = ((!empty($element['wide'])) || (strpos($box['typeName'], 'wide_') !== false));

            beopen_visual_render::display($elementType, $box, columnNumberToString($box['columnWidth']), $has_carousel, $has_wide);
        }

        static function includeElement($element, $box, $show_error = true) {
            if (has_action('beopen_framework_include_element')) {
                do_action('beopen_framework_include_element', array('element' => $element, 'box' => $box));
            } else {

                $elementfile = $element . '.php';

                $priorityLoad = array(
                    CHILD_THEME_DIR . '/elements/',
                    THEME_DIR . '/elements/',
                    THEME_DIR . '/beopen_framework/elements/'
                );


                $found = null;
                foreach ($priorityLoad as $elementfolder)
                    if (!$found) {
                        if (file_exists($elementfolder . $elementfile)) {
                            $found = $elementfolder . $elementfile;
                        }
                    }

                if ($found) {
                    $output = '';
                    include($found);

                    return $output;
                } else {
					if ($show_error) {
						return 'ERROR ELEMENT ' . $element;
					}
                }
            }
        }

        static function beginCarousel($box, $title, $subtitle) {

            $output = '';
			
			$output .= self::includeElement($box['typeName'] . '_begin', $box, false);

            if (isset($box['data']['title']) && ($box['data']['title'])) {

                $output .= '<h2 class="headline">';

                if ($title) {
                    $output .= '<span class="beopen-extra-style"></span>';
                }

				$output .= '<span class="subtitle">';
                $output .= $subtitle;
                $output .= '</span>';
				
                $output .= '<span class="title">';
                $output .= $title;
                $output .= '</span>';

                $output .= '<a href="#" class="jc-next"></a><a href="#" class="jc-previous"></a></h2>';
            } else {
                $output .= '<a href="#" class="jc-next"></a><a href="#" class="jc-previous"></a>';
            }

            $output .= '<div class="clearfix pb25"></div>';

            $typeName = '';
            if (isset($box['typeName'])) {
                $typeName = $box['typeName'];
            }

            $output .= '<div class="fred">';

            return $output;
        }

        static function endCarousel($box) {

            $output = '';

            $output .= '</div>';

            if (empty($box['data']['display_pagination'])) {
                $output .= '<div class="pagination"></div>';
            }

			
			$output .= self::includeElement($box['typeName'] . '_end', $box, false);

            return $output;
        }

        static function widget($type, $attr = null) {
            return self::includeElement($type . '_widget', $attr);
        }

        static function widgetbar($widget_bar_id) {
            dynamic_sidebar('Widget Bar ' . $widget_bar_id);
        }
		
		
		static function test() {
			
			global $visual_editor_elements;
			
			$testLayout = array();
			$rowCount = 0;
			
			foreach ($visual_editor_elements as $item_name => $item_value) {
				
				$data = array();
				if (isset($item_value['options'])) {
					foreach ($item_value['options'] as $option_name => $option_value) {
						
						if (is_array($option_value['type'])) {
						
							$data[$option_value['name']] = $option_value['type'][''];
						}
						else
						{
							$data[$option_value['name']] = $option_value['label'];
						}
					}
				}
				
				foreach ($item_value['columns'] as $columns) {
					
				$rowCount += 1;
				
				$testLayout[$rowCount]['elements'][] = array(
					'typeName' => $item_name, 
					'columnWidth' => $columns * 3, 
					'columnStart' => 0,
					'data' => array_merge($data, array('title' => $item_value['title'], 'subtitle' => $item_value['title']))
				);
				
				
				
				}
				
							
			}
		
			
			return $testLayout;
			
		}

    }
	
	

?>
