<?php
add_action('widgets_init', 'beopen_load_widgets');

function beopen_load_widgets()
{
	register_widget('Beopen_Social_Widget');
}

class Beopen_Social_Widget extends WP_Widget {
	
	function Beopen_Social_Widget()
	{
		$widget_ops = array('classname' => 'beopen-social', 'description' => 'Display the social icons defined in General.');

		$control_ops = array('id_base' => 'beopen-social-widget');

		$this->WP_Widget('beopen-social-widget', 'BeOpen Social', $widget_ops, $control_ops);
	}
	
	function widget($args, $instance)
	{
		extract($args);
		
		echo $before_widget;
        
        $title = apply_filters( 'widget_title', $instance['title'] );

		if($title) {
			echo $before_title.$title.$after_title;
		}
		
        beopen_show_social_icons();			
        
		echo $after_widget;
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
        $instance['title'] = strip_tags( $new_instance['title'] );
        
		return $instance;
	}

	function form($instance)
	{
		$defaults = array();
		$instance = wp_parse_args((array) $instance, $defaults);
        
        if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Social', 'beopen' );
		}
		
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'beopen' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<?php 		        

	}
}
?>