/*
 *	jQuery BeOpen Grid 1.0.0
 *
 *	Copyright (c) 2013 Beopen
 *	www.beopenthemes.com
 *
 *	Dual licensed under the MIT and GPL licenses.
 *	http://en.wikipedia.org/wiki/MIT_License
 *	http://en.wikipedia.org/wiki/GNU_General_Public_License
 */

(function($) {

    $.fn.beOpenGrid = function(options) {
        
        
        function cycleUpdates() {
            
            $(this).each(function(index, element) {

                if ($(element).is(":hover")) {

                    var currentSelection = $(element).data('currentSelection');
                    if (currentSelection) {
                        currentSelection = currentSelection + 1;
                        if (currentSelection > $(element).find('img').length) {
                            currentSelection = 1;
                        }
                    }
                    else
                    {
                        currentSelection = 1;
                    }

                    $(element).data('currentSelection', currentSelection);


                    $(element).find('img').removeClass('beopen-focused');
                    $(element).find("li:nth-child(" + currentSelection + ") img").addClass('beopen-focused');


                }
            });
   
        }

        // This is the easiest way to have default options.
        var settings = $.extend({
            // These are the defaults.
            duration: "4000"
        }, options);

        setInterval($.proxy(cycleUpdates, this), settings['duration']);

        /*
         if ( action === "open") {
         // Open popup code.
         }
         
         if ( action === "close" ) {
         // Close popup code.
         }
         */
    };



}(jQuery));