<?php
	/*
	  Template Name: Blog Masonry
	 */
?>

<?php get_header(); ?>

<div id="main-content">

	<div class="row">
		<div class="masonry">

			<?php
				global $wp_query;
				global $numposts;

				$page = (get_query_var('paged')) ? get_query_var('paged') : 1;
				$args = array('posts_per_page' => $numposts, 'paged' => $page);

				query_posts($args);
			?>

			<?php /* If there are no posts to display, such as an empty archive page */ ?>
			<?php if (!have_posts()) : ?>
					<div class="notice">
						<p class="bottom"><?php _e('Sorry, no results were found.', 'beopen'); ?></p>
					</div>
					<?php get_search_form(); ?>	
				<?php endif; ?>

			<?php /* Start loop */ ?>
			<?php while (have_posts()) : the_post(); ?>
					<div class="three columns masonry-item end">

						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<div class="post-top">
							</div>

							<header>			
								<?php
								if (beopen_get_option('show_excerpt_or_full_post') != 'full_post') {
									get_template_part('single', 'preview');
								}
								?>
								<?php echo beopen_entry_categories(); ?>
								<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
								<div class="post-meta">
									<?php beopen_entry_meta(array('date', 'comments')); ?>
								</div>
							</header>
							<div class="entry-content">
								<?php
								if (beopen_get_option('show_excerpt_or_full_post') == 'full_post') {
									the_content();
								} else {
									the_excerpt();
								}
								?>
							</div>
							<footer></footer>
						</article>	

					</div>
	<?php endwhile; // End the loop 
?>

		</div>
<?php /* Display navigation to next/previous pages when applicable */ ?>
		<?php if (function_exists('beopen_pagination')) {
				beopen_pagination();
			} else if (is_paged()) { ?>

				<nav id="post-nav">
					<div class="post-previous"><?php next_posts_link(__('&larr; Older posts', 'beopen')); ?></div>
					<div class="post-next"><?php previous_posts_link(__('Newer posts &rarr;', 'beopen')); ?></div>
				</nav>
			<?php } ?>



	</div>

</div>

<?php get_footer(); ?>