<?php
add_action( 'after_setup_theme', 'inbound_enable_site_logo', 15);
add_action( 'after_setup_theme', 'inbound_remove_genesis_title_description', 20 ); 
add_action( 'after_setup_theme', 'inbound_remove_genesis_header', 25 );
add_action( 'genesis_header',  'inbound_set_custom_header' );

function inbound_enable_site_logo() {
	add_theme_support( 'custom-logo', array('size' => 'large') );
}

function inbound_remove_genesis_title_description() {
	remove_action( 'genesis_site_title', 'genesis_seo_site_title' ); 
	remove_action( 'genesis_site_description', 'genesis_seo_site_description');
}

function inbound_remove_genesis_header() {
	remove_action('genesis_header', 'genesis_do_header');
}

function inbound_set_custom_header() {
	div('container');
		div('row');
			div('col-xs-12 logo text-center');
				if (has_custom_logo()) {
					echo '<a href="' . esc_url(home_url('/')) . '">' . get_custom_logo() . '</a>';
				}
				else {							   
				    echo '<h1><a href="' . esc_url(home_url('/')) . '">' . get_bloginfo('name') . '</a></h1>';
				}
			div();
		div();
	div();
	div('primary-navigation-container');
		wp_nav_menu(array('theme_location' => 'primary', 'menu_class' => 'nav navbar-nav', 'container_class' => 'primary-navigation navbar-collapse collapse container'));
	div();
}