<?php
add_action( 'after_setup_theme', 'inbound_remove_default_stylesheet', 15 ); 
add_action( 'wp_enqueue_scripts', 'inbound_enqueue_css_js' );

function inbound_remove_default_stylesheet() {
    remove_action( 'genesis_meta', 'genesis_load_stylesheet' );
}

function inbound_enqueue_css_js() {
    // wp_enqueue_style( $handle, $src, $deps, $ver, $media );
    wp_enqueue_style( 'vendors', get_stylesheet_directory_uri() . '/css/vendors.min.css', '1.0.0' );
    wp_enqueue_style( 'font-roboto-slab', '//fonts.googleapis.com/css?family=Roboto+Slab:400,700' );
    wp_enqueue_style( 'inbound_style', get_stylesheet_directory_uri() . '/style.css' );

    // wp_enqueue_script( $handle, $src, $deps, $ver, $in_footer );
    wp_enqueue_script( 'script',   get_stylesheet_directory_uri() . '/js/min/script.min.js', array(), '1.0.0', true );
    wp_enqueue_script( 'respond', '//cdnjs.cloudflare.com/ajax/libs/respond.js/1.4.2/respond.js', array(), '1.4.2', true );
}