<?php
/**
 * [year]
 */
add_shortcode('year', 'inbound_current_year');
function inbound_current_year($atts) {
	return date('Y');
}

/**
 * [domainname]
 */
add_shortcode('domainname', 'inbound_domainname');
function inbound_domainname($atts) {
	$host = $_SERVER['HTTP_HOST'];
	preg_match("/[^\.\/]+\.[^\.\/]+$/", $host, $matches);
	return ucfirst($matches[0]);
}

/**
 * [latest_posts] shortcode
 */
add_shortcode('latest_posts', 'inbound_latest_posts');
function inbound_latest_posts($atts) {
	$atts = shortcode_atts( array(
		'nr_of_items' => 3,
		'category'    => 0,
		'excerpt_length' => 35
	), $atts);

	$cat_id = $atts['category'] ? get_cat_ID($atts['category']) : 0;

	$string = '';
	global $wp_query;
	$wp_query = new WP_Query(array(
		'posts_per_page' =>  $atts['nr_of_items'],
		'cat'       => $cat_id,
		'orderby'        => 'date',
		'order'          => 'desc'
	));

	if (have_posts()):
		$string .= '<div class="row">';
		while(have_posts()) : the_post();
			$string .= archive_entry(array('col' => 'col-md-4', 'excerpt_length' => $atts['excerpt_length']));
		endwhile;
		$string .= '</div>';
	else:
		$string .= __('Geen resultaten', 'inbound');
	endif;
	wp_reset_query();
	return $string;
}

/**
 * [icon] shortcode
 */
add_shortcode('icon', 'inbound_icon');
function inbound_icon($atts) {
	$atts = shortcode_atts( array(
		'id' => '',
		'size' => ''
	), $atts);
	$size = empty($atts['size']) ? '' : 'fa-' . $atts['size'];
	$id = empty($atts['id']) ? '' : 'fa-' . $atts['id'];

	$string = '<i class="fa fa-fw ' . $id . ' ' . $size . '"></i>&nbsp;&nbsp;';
	return $string;
}

/**
 * [read_more] shortcode
 */
add_shortcode('read_more', 'inbound_read_more');
function inbound_read_more($atts) {
	$atts = shortcode_atts( array(
		'link' => '#',
		'text' => 'Read More'
	), $atts);

	extract($atts);

	$link_host = parse_url($link, PHP_URL_HOST);
	$site_host = parse_url(get_site_url(), PHP_URL_HOST);

	// internal link
	if($link == $site_host || !strstr($link, 'http://')) 
	  return '<a class="read-more" href="' . $link . '">' . $text . '</a>';
	// external link 
	else 	  
	  return '<a class="read-more" target="_blank" href="' . $link . '">' . $text . '</a>';	
}
?>