<?php
/**
 * Debug a specific variable, cakePHP style
 * @param  [type]  $var variable to debug
 * @param  boolean $showHtml display html tags
 * @param  boolean $showFrom display stacktrace
 */
if (!function_exists('debug')) {
    function debug($var = false, $showHtml = false, $showFrom = true) {
       if ($showFrom) {
          $calledFrom = debug_backtrace();
          echo '<strong>' . substr(str_replace(ROOT, '', $calledFrom[0]['file']), 1) . '</strong>';
          echo ' (line <strong>' . $calledFrom[0]['line'] . '</strong>)';
       }
       echo "\n<pre class=\"cake-debug\">\n";
       $var = print_r($var, true);
       if ($showHtml) {
          $var = str_replace('<', '&lt;', str_replace('>', '&gt;', $var));
       }
       echo $var . "\n</pre>\n";
    }
}

/**
 * Wrap a newline in <p> tags
 * @param  [type] $string text to wrap
 * @param  boolean $line_breaks 
 * @param  boolean $xml 
 * @return string wrapped text
 */
if (!function_exists('nl2p')) {
   function nl2p($string, $line_breaks = true, $xml = true) {

   $string = str_replace(array('<p>', '</p>', '<br>', '<br />'), '', $string);

   // It is conceivable that people might still want single line-breaks
   // without breaking into a new paragraph.
   if ($line_breaks == true)
       return '<p>'.preg_replace(array("/([\n]{2,})/i", "/([^>])\n([^<])/i"), array("</p>\n<p>", '$1<br'.($xml == true ? ' /' : '').'>$2'), trim($string)).'</p>';
   else 
       return '<p>'.preg_replace(
       array("/([\n]{2,})/i", "/([\r\n]{3,})/i","/([^>])\n([^<])/i"),
       array("</p>\n<p>", "</p>\n<p>", '$1<br'.($xml == true ? ' /' : '').'>$2'),

       trim($string)).'</p>'; 
   }
}


/**
 * Get the url of the featured image of a post/page 
 * @param  int $post_id 
 * @param  string $size
 * @return string featured image url if found
 */
if (!function_exists('get_featured_image_src')) {
    function get_featured_image_src($post_id, $size) {
        $attachment_id = get_post_thumbnail_id($post_id);
        $image = wp_get_attachment_image_src($attachment_id, $size);
        return $image ? $image[0] : 'no image found';
    }
}

/**
 * Find an attachment ID by a given URL
 * @param  string $image_url
 * @return int attachment_id
 */
if (!function_exists('get_attachment_id_from_url')) {
    function get_attachment_id_from_url($image_url) {
        global $wpdb;
        $attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url )); 
        return $attachment[0]; 
    }
}

/**
 * Create a div html element
 * @param  string $class 
 * @param  string $id
 * @return string
 */
if (!function_exists('div')) {
    function div($class = '', $id = '') {
        if (empty($class) && empty($id)) {
            echo '</div>';
            return;
        }

        if (!empty($id)) 
            echo '<div id="' . $id . '" class="' . $class . '">';
        else
            echo '<div class="' . $class . '">';    
    }
}

/**
 * Load given wordpress sidebar
 * @param  string $sidebar sidebar ID
 * @param  string $before  
 * @param  string $after  
 */
if (!function_exists('load_sidebar')) {
    function load_sidebar($sidebar = '', $before = '', $after = '') {
        if ( is_active_sidebar( $sidebar ) ) : 
            echo $before;
            dynamic_sidebar( $sidebar ); 
            echo $after;
        endif; 
    }
}

/**
 * Get a portion of the post excerpt
 * @param  int $limit number of words
 * @return string the excerpt of the excerpt :-)
 */
if (!function_exists('excerpt')) {
    function excerpt($limit) {
        $excerpt = explode(' ', get_the_excerpt(), $limit);
        if (count($excerpt)>=$limit) {
            array_pop($excerpt);
            $excerpt = implode(" ",$excerpt).'...';
        } else {
            $excerpt = implode(" ",$excerpt);
        } 
        $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
        return $excerpt;
    }
}


/**
 * Print preview of a post/page entry
 * @param  array  $args 
 * @return string view content
 */
if (!function_exists('archive_entry')) {
    function archive_entry($args = array()) {
        do_action('genesis_before_entry');
        printf('<article class="%s">', 'archive-entry ' . $args['col']);
            div('archive-entry-image');                
                echo '<a href="' . get_the_permalink() . '">';
                if (has_post_thumbnail()):
                    echo  get_the_post_thumbnail();
                else:
                    echo '<img width="360" height="220" src="http://placehold.it/720x440/012951/ffffff?text=Geen+afbeelding" class="wp-post-image" />';
                endif;
                echo  '</a>';
                div('archive-entry-date');
                    echo '<span><i class="fa fa-calendar"></i>&nbsp;&nbsp;&nbsp;' . get_the_date('j F Y') . '</span>';
                div();
            div();

            div('archive-entry-content');               
                echo '<h3 class="archive-entry-content-title"><a href="' . get_the_permalink() . '">' . wp_trim_words(get_the_title(), 8) . '</a></h3>';
                div('archive-entry-content-text');
                    echo '<p class="archive-entry-content-excerpt">' . get_the_excerpt() . '</p>';
                    echo '<p>' . do_shortcode('[read_more text="Lees meer" link="' . get_permalink(get_the_ID()) . '"]') . '</p>';
                div();                
            div();     
        echo '</article>';
        do_action('genesis_after_entry');
    }
}
?>