<?php

add_filter( 'wpseo_canonical', function($canonical) {
	global $post;	
	$primary_domain = get_primary_domain(get_current_blog_id());
	// no primary domain found, return the current url/defined canonical
	if (!$primary_domain) return $canonical;

	// replace occurence of current domain name with the primary domain name
	$current_domain = preg_replace("(^https?://)", "", get_home_url());
	$current_url = get_permalink(get_the_ID());
	return str_replace($current_domain, $primary_domain, $current_url);
} );

// get the main mapped domain of current blog
function get_primary_domain($blog_id) {
	global $wpdb;
	$table = $wpdb->base_prefix . 'domain_mappings';
	// active is 1 => the primary domain 
	$results = $wpdb->get_results("SELECT * FROM " . $table . " WHERE active = 1 AND blog_id = " . $blog_id);

	if (empty($results)) return false;

	return reset($results)->domain;
}