<?php
add_filter( 'genesis_post_meta', 'inbound_post_meta_filter' );
function inbound_post_meta_filter($post_meta) {
	$post_meta = '[post_tags sep="" before="' . utf8_encode('<h4><i class=\'fa fa-tags\'></i> Tags</h4>') . '"]';
	return $post_meta;
}

remove_action( 'genesis_before_content_sidebar_wrap', 'genesis_do_post_title' );
add_action( 'genesis_before_while', 'do_blog_title');

remove_action( 'genesis_loop', 'genesis_do_loop' );
add_action( 'genesis_loop', 'inbound_custom_loop' );

function inbound_custom_loop() {	
	global $wp_query;
	if (have_posts()):
		do_action( 'genesis_before_while' );	
		while ( have_posts() ) : the_post();
			do_action( 'genesis_before_entry' );
			printf( '<article %s>', genesis_attr( 'entry' ) );
				do_action( 'genesis_entry_header' );
				do_action( 'genesis_before_entry_content' );
				printf( '<div %s>', genesis_attr( 'entry-content' ) );
					do_action( 'genesis_entry_content' );
				echo '</div>';
				do_action( 'genesis_after_entry_content' );				
			echo '</article>';
			do_action( 'genesis_after_entry' );

		endwhile; //* end of one post		
		do_action( 'genesis_after_endwhile' );
	endif;
	genesis_posts_nav(); 
}

remove_action( 'genesis_entry_header', 'genesis_entry_header_markup_open', 5 );
remove_action( 'genesis_entry_header', 'genesis_post_info', 12 );
remove_action( 'genesis_entry_header', 'genesis_do_post_title' );
remove_action( 'genesis_entry_header', 'genesis_entry_header_markup_close', 15 );
//add_action( 'genesis_entry_header', 'inbound_do_post_thumbnail', 9);
add_action( 'genesis_entry_header', 'inbound_do_post_title', 10 );
add_action( 'genesis_entry_header', 'inbound_post_info', 15);

function inbound_do_post_title() {
	$title = apply_filters( 'genesis_post_title_text', get_the_title() );
	if ( 0 === mb_strlen( $title ) )
		return;

	//* Wrap in H1 on singular pages
	$wrap = 'h2';

	$wrap = apply_filters( 'genesis_entry_title_wrap', $wrap );

	//* Build the output
	$output = genesis_markup( array(
		'html5'   => "<{$wrap} %s>",
		'xhtml'   => sprintf( '<%s class="entry-title">%s</%s>', $wrap, $title, $wrap ),
		'context' => 'entry-title',
		'echo'    => false,
	) );

	$output .= genesis_html5() ? "{$title}</{$wrap}>" : '';

	echo apply_filters( 'genesis_post_title_output', "$output \n" );
}

function inbound_post_info() {
	div('entry-meta');
		printf('<span class="%s"><i class="fa fa-calendar"></i>&nbsp;&nbsp;%s</span>', 'entry-meta-date', get_the_date('j F Y'));
		printf('<span class="%s"><i class="fa fa-user"></i>&nbsp;&nbsp;%s</span>', 'entry-meta-author', get_the_author());
	div();
}

function inbound_do_post_thumbnail() {
	if (has_post_thumbnail()):
		div('entry-thumbnail');
			the_post_thumbnail( 'entry-thumbnail' );
		div();
	endif;
}

genesis();