<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0+
 * @link    http://my.studiopress.com/themes/genesis/
 */

add_action( 'admin_notices', 'genesis_use_child_theme_notice' );

/**
 * Display Warning that Genesis should always be used with a child theme.
 *
 * @since 2.3.0
 */
function genesis_use_child_theme_notice() {

	if ( is_child_theme() ) {
		return;
	}

	$allowed_html = array(
		'a' => array(
			'href' => array(),
		),
	);

	echo '<div class="error"><p><strong>';
	esc_html_e( 'Please Activate a Genesis Child Theme:', 'genesis' );
	echo '</strong> ';
	esc_html_e( 'We\'ve noticed you are using the Genesis Framework parent theme alone. We strongly recommend you run a Genesis child theme with it (we even have a free theme you can use). ', 'genesis' );
	printf(
		wp_kses( __( 'For more information, see our article at <a href="%1$s">%1$s</a>', 'genesis' ), $allowed_html ),
		esc_url( __( 'https://www.studiopress.com/genesis-always-use-child-theme/', 'genesis' ) )
	);
	echo '</p></div>';
}
